/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005EsA\u0002\f\u0018\u0011\u0003IrD\u0002\u0004\"/!\u0005\u0011D\t\u0005\u0006S\u0005!\ta\u000b\u0005\bY\u0005\u0011\r\u0011\"\u0003.\u0011\u00191\u0014\u0001)A\u0005]!9q'\u0001b\u0001\n\u0013A\u0004B\u0002$\u0002A\u0003%\u0011\bC\u0004H\u0003\t\u0007I\u0011\u0002%\t\rI\u000b\u0001\u0015!\u0003J\r\u0015\ts\u0003A\u000eT\u0011!q\u0016B!A!\u0002\u0013y\u0006\"B\u0015\n\t\u00039\u0007b\u00026\n\u0005\u0004%Ia\u001b\u0005\u0007_&\u0001\u000b\u0011\u00027\t\u000fAL!\u0019!C\u0005c\"1a0\u0003Q\u0001\nID\u0001b`\u0005C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u0003\u001bI\u0001\u0015!\u0003\u0002\u0004!I\u0011qB\u0005C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u00033I\u0001\u0015!\u0003\u0002\u0014!9\u00111D\u0005\u0005\u0002\u0005u\u0001bBA\u001d\u0013\u0011%\u00111H\u0001\u0013'Nd7i\u001c8uKb$8OR1di>\u0014\u0018P\u0003\u0002\u00193\u0005!Q\u000f^5m\u0015\tQ2$\u0001\u0003iiR\u0004(B\u0001\u000f\u001e\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AH\u0001\u0003S>\u0004\"\u0001I\u0001\u000e\u0003]\u0011!cU:m\u0007>tG/\u001a=ug\u001a\u000b7\r^8ssN\u0011\u0011a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aH\u0001\u0017\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[V\ta\u0006\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005A1/Z2ve&$\u0018PC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$\u0001D*fGV\u0014XMU1oI>l\u0017a\u0006#fM\u0006,H\u000e^*tYN+7-\u001e:f%\u0006tGm\\7!\u0003Q!UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3sgV\t\u0011\bE\u0002%uqJ!aO\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015aA:tY*\u0011\u0011IQ\u0001\u0004]\u0016$(\"A\"\u0002\u000b)\fg/\u0019=\n\u0005\u0015s$\u0001\u0004+skN$X*\u00198bO\u0016\u0014\u0018!\u0006#fM\u0006,H\u000e\u001e+skN$X*\u00198bO\u0016\u00148\u000fI\u0001\u0004\u0003BtW#A%\u0011\u0005)\u0003V\"A&\u000b\u0005}b%BA'O\u0003\u001dA\u0017M\u001c3mKJT!aT\u000f\u0002\u000b9,G\u000f^=\n\u0005E[%!G!qa2L7-\u0019;j_:\u0004&o\u001c;pG>d7i\u001c8gS\u001e\fA!\u00119oAM\u0019\u0011b\t+\u0011\u0005UcV\"\u0001,\u000b\u0005]C\u0016\u0001D:dC2\fGn\\4hS:<'BA-[\u0003!!\u0018\u0010]3tC\u001a,'\"A.\u0002\u0007\r|W.\u0003\u0002^-\ni1\u000b\u001e:jGRdunZ4j]\u001e\f!\u0002\u001b;ua\u000e{gNZ5h!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0004d_:4\u0017n\u001a\u0006\u0003In\tAaY8sK&\u0011a-\u0019\u0002\u0012\u0011R$\boQ8oM&<WO]1uS>tGC\u00015j!\t\u0001\u0013\u0002C\u0003_\u0017\u0001\u0007q,\u0001\rtg2\u001cVm]:j_:$\u0016.\\3pkR\u001cVmY8oIN,\u0012\u0001\u001c\t\u0003I5L!A\\\u0013\u0003\t1{gnZ\u0001\u001agNd7+Z:tS>tG+[7f_V$8+Z2p]\u0012\u001c\b%\u0001\tf]\u0006\u0014G.\u001a3Qe>$xnY8mgV\t!\u000fE\u0002%uM\u0004\"\u0001^>\u000f\u0005UL\bC\u0001<&\u001b\u00059(B\u0001=+\u0003\u0019a$o\\8u}%\u0011!0J\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{K\u0005\tRM\\1cY\u0016$\u0007K]8u_\u000e|Gn\u001d\u0011\u0002'\u0015t\u0017M\u00197fI\u000eK\u0007\u000f[3s'VLG/Z:\u0016\u0005\u0005\r\u0001#BA\u0003\u0003\u0013\u0019XBAA\u0004\u0015\tA\"'\u0003\u0003\u0002\f\u0005\u001d!\u0001\u0002'jgR\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0013AC;tK>\u0003XM\\*tYV\u0011\u00111\u0003\t\u0004I\u0005U\u0011bAA\fK\t9!i\\8mK\u0006t\u0017aC;tK>\u0003XM\\*tY\u0002\naB\\3x'Nd7i\u001c8uKb$8\u000f\u0006\u0004\u0002 \u0005\u0015\u0012\u0011\u0006\t\u0004A\u0005\u0005\u0012bAA\u0012/\tY1k\u001d7D_:$X\r\u001f;t\u0011\u001d\t9\u0003\u0006a\u0001\u0003'\tA\u0002\u001b;uaJ*e.\u00192mK\u0012Dq!a\u000b\u0015\u0001\u0004\ti#\u0001\rqKJ,6/\u001a:LKfl\u0015M\\1hKJ4\u0015m\u0019;pef\u0004R\u0001JA\u0018\u0003gI1!!\r&\u0005\u0019y\u0005\u000f^5p]B\u0019Q(!\u000e\n\u0007\u0005]bHA\tLKfl\u0015M\\1hKJ4\u0015m\u0019;pef\fQB\\3x'Nd7i\u001c8uKb$HCBA\u001f\u0003\u0007\ni\u0005E\u0002K\u0003\u007fI1!!\u0011L\u0005)\u00196\u000f\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u000b*\u0002\u0019AA$\u00035QGm[*tY\u000e{g\u000e^3yiB\u0019Q(!\u0013\n\u0007\u0005-cH\u0001\u0006T'2\u001buN\u001c;fqRDa!a\u0014\u0016\u0001\u0004I\u0015aA1q]\u0002")
public class SslContextsFactory
implements StrictLogging {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final boolean useOpenSsl;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        SslContexts sslContexts;
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable & scala.Serializable)() -> $this.httpConfig.ssl().keyManagerFactory());
        if (this.useOpenSsl()) {
            BoxedUnit boxedUnit;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            Option option = this.httpConfig.ssl().trustManagerFactory();
            if (option instanceof Some) {
                Some some = (Some)option;
                TrustManagerFactory tmf = (TrustManagerFactory)some.value();
                boxedUnit = sslContextBuilder.trustManager(tmf);
            } else {
                boxedUnit = this.httpConfig.advanced().useInsecureTrustManager() ? sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE) : BoxedUnit.UNIT;
            }
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultTrustManagers(), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? this.enabledProtocols() : null, false);
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(HttpConfiguration httpConfig) {
        boolean bl;
        this.httpConfig = httpConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        if (httpConfig.advanced().useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
    }
}

