/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f!\u0002\u00180\u0001=:\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\ta\u0002\u0011\t\u0011)A\u0005c\"AA\u000f\u0001B\u0001B\u0003%Q\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011)\t\u0019\u0001\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\b\u0003+\u0001A\u0011AA\f\u0011%\tI\u0003\u0001b\u0001\n\u0013\tY\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0017\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA\u001d\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%I!!\u0013\t\u0017\u0005U\u0003\u00011AA\u0002\u0013%\u0011q\u000b\u0005\f\u0003G\u0002\u0001\u0019!A!B\u0013\tY\u0005C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011\u0011\u0012\u0001!\u0002\u0013\tI\u0007C\u0005\u0002\f\u0002\u0011\r\u0011\"\u0003\u0002\u000e\"A\u0011\u0011\u0015\u0001!\u0002\u0013\ty\tC\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002&\"A\u0011Q\u0016\u0001!\u0002\u0013\t9\u000bC\u0005\u00020\u0002\u0011\r\u0011\"\u0003\u00022\"A\u0011Q\u0017\u0001!\u0002\u0013\t\u0019\fC\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002&\"I\u0011\u0011\u0018\u0001A\u0002\u0013%\u00111\u0018\u0005\t\u0003\u007f\u0003\u0001\u0015)\u0003\u0002(\"I\u0011\u0011\u0019\u0001A\u0002\u0013%\u00111\u0019\u0005\n\u0003#\u0004\u0001\u0019!C\u0005\u0003'D\u0001\"a6\u0001A\u0003&\u0011Q\u0019\u0005\n\u00033\u0004!\u0019!C\u0005\u00037D\u0001\"a9\u0001A\u0003%\u0011Q\u001c\u0005\b\u0003K\u0004A\u0011IA%\u0011\u001d\t9\u000f\u0001C!\u0003SDq!!<\u0001\t\u0013\ty\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0003\u0001\u0005\n\tU\u0001b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[AqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003x\u0001!\tE!\u001f\t\u000f\t\r\u0005\u0001\"\u0011\u0003\u0006\"9!Q\u0013\u0001\u0005B\t]\u0005b\u0002BQ\u0001\u0011\u0005#1\u0015\u0002\u001a\t\u00164\u0017-\u001e7u%\u0016\u001cx.\u001e:dK\u0006;wM]3hCR|'O\u0003\u00021c\u0005)a-\u001a;dQ*\u0011!gM\u0001\u0005QR$\bO\u0003\u00025k\u00059q-\u0019;mS:<'\"\u0001\u001c\u0002\u0005%|7\u0003\u0002\u00019}\t\u0003\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0007CA A\u001b\u0005y\u0013BA!0\u0005I\u0011Vm]8ve\u000e,\u0017iZ4sK\u001e\fGo\u001c:\u0011\u0005\rSU\"\u0001#\u000b\u0005\u00153\u0015\u0001D:dC2\fGn\\4hS:<'BA$I\u0003!!\u0018\u0010]3tC\u001a,'\"A%\u0002\u0007\r|W.\u0003\u0002L\t\ni1\u000b\u001e:jGRdunZ4j]\u001e\faA]8piRC8\u0001\u0001\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000b!\u0001\u001e=\u000b\u0005M\u000b\u0014AB3oO&tW-\u0003\u0002V!\n1\u0001\n\u001e;q)b\f\u0001#\u001b8ji&\fGNU3t_V\u00148-Z:\u0011\u0007a\u00037M\u0004\u0002Z=:\u0011!,X\u0007\u00027*\u0011A,T\u0001\u0007yI|w\u000e\u001e \n\u0003mJ!a\u0018\u001e\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\u0004'\u0016\f(BA0;!\t!w-D\u0001f\u0015\t1\u0017'A\u0004sKF,Xm\u001d;\n\u0005!,'a\u0003%uiB\u0014V-];fgR\f!\u0002\u001b;ua\u000e\u000b7\r[3t!\tYg.D\u0001m\u0015\ti\u0017'A\u0003dC\u000eDW-\u0003\u0002pY\nQ\u0001\n\u001e;q\u0007\u0006\u001c\u0007.Z:\u0002\u001fI,7o\\;sG\u00164U\r^2iKJ\u0004\"a\u0010:\n\u0005M|#a\u0004*fg>,(oY3GKR\u001c\u0007.\u001a:\u0002\u001d!$H\u000f\u001d+y\u000bb,7-\u001e;peB\u0011qJ^\u0005\u0003oB\u0013a\u0002\u0013;uaRCX\t_3dkR|'/A\u0003dY>\u001c7\u000e\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006!Q\u000f^5m\u0015\tq8'A\u0004d_6lwN\\:\n\u0007\u0005\u00051PA\u0003DY>\u001c7.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\u0019\u0019wN\u001c4jO*\u0019\u0011qB\u001a\u0002\t\r|'/Z\u0005\u0005\u0003'\tIA\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0002CA \u0001\u0011\u0015a\u0005\u00021\u0001O\u0011\u00151\u0006\u00021\u0001X\u0011\u0015I\u0007\u00021\u0001k\u0011\u0015\u0001\b\u00021\u0001r\u0011\u0015!\b\u00021\u0001v\u0011\u0015A\b\u00021\u0001z\u0011\u001d\t\u0019\u0001\u0003a\u0001\u0003\u000b\t\u0011\u0002\u001e5s_R$H.\u001a3\u0016\u0005\u00055\u0002cA\u001d\u00020%\u0019\u0011\u0011\u0007\u001e\u0003\u000f\t{w\u000e\\3b]\u0006QA\u000f\u001b:piRdW\r\u001a\u0011\u0002\u0019!$H\u000f\u001d)s_R|7m\u001c7\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\u0012'\u0001\u0005qe>$xnY8m\u0013\u0011\t\u0019%!\u0010\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\u0002\u001b!$H\u000f\u001d)s_R|7m\u001c7!\u0003\u001d\u0019Xm]:j_:,\"!a\u0013\u0011\t\u00055\u0013\u0011K\u0007\u0003\u0003\u001fRA!a\u0012\u0002\u000e%!\u00111KA(\u0005\u001d\u0019Vm]:j_:\f1b]3tg&|gn\u0018\u0013fcR!\u0011\u0011LA0!\rI\u00141L\u0005\u0004\u0003;R$\u0001B+oSRD\u0011\"!\u0019\u000f\u0003\u0003\u0005\r!a\u0013\u0002\u0007a$\u0013'\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003-\tGN]3bIf\u001cV-\u001a8\u0016\u0005\u0005%\u0004CBA6\u0003k\nI(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u001diW\u000f^1cY\u0016T1!a\u001d;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\niGA\u0002TKR\u0004B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0002ve&T1!a!2\u0003\u0019\u0019G.[3oi&!\u0011qQA?\u0005\r)&/[\u0001\rC2\u0014X-\u00193z'\u0016,g\u000eI\u0001\u0018EV4g-\u001a:fIJ+7o\\;sG\u0016\u001c()\u001f%pgR,\"!a$\u0011\u0011\u0005-\u0014\u0011SAK\u00037KA!a%\u0002n\t\u0019Q*\u00199\u0011\t\u0005m\u0012qS\u0005\u0005\u00033\u000biD\u0001\u0004SK6|G/\u001a\t\u00051\u0006u5-C\u0002\u0002 \n\u0014A\u0001T5ti\u0006A\"-\u001e4gKJ,GMU3t_V\u00148-Z:Cs\"{7\u000f\u001e\u0011\u0002+5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'\u000fS8tiV\u0011\u0011q\u0015\t\u0004s\u0005%\u0016bAAVu\t\u0019\u0011J\u001c;\u0002-5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'\u000fS8ti\u0002\nQ#\u0019<bS2\f'\r\\3U_.,gn\u001d\"z\u0011>\u001cH/\u0006\u0002\u00024BA\u00111NAI\u0003+\u000b9+\u0001\fbm\u0006LG.\u00192mKR{7.\u001a8t\u0005fDun\u001d;!\u0003U\u0001XM\u001c3j]\u001e\u0014Vm]8ve\u000e,7oQ8v]R\f\u0011\u0004]3oI&twMU3t_V\u00148-Z:D_VtGo\u0018\u0013fcR!\u0011\u0011LA_\u0011%\t\t'GA\u0001\u0002\u0004\t9+\u0001\fqK:$\u0017N\\4SKN|WO]2fg\u000e{WO\u001c;!\u000319Gn\u001c2bYN#\u0018\r^;t+\t\t)\r\u0005\u0003\u0002H\u00065WBAAe\u0015\r\tY-`\u0001\u0006gR\fGo]\u0005\u0005\u0003\u001f\fIM\u0001\u0004Ti\u0006$Xo]\u0001\u0011O2|'-\u00197Ti\u0006$Xo]0%KF$B!!\u0017\u0002V\"I\u0011\u0011\r\u000f\u0002\u0002\u0003\u0007\u0011QY\u0001\u000eO2|'-\u00197Ti\u0006$Xo\u001d\u0011\u0002\u001dM$\u0018M\u001d;US6,7\u000f^1naV\u0011\u0011Q\u001c\t\u0004s\u0005}\u0017bAAqu\t!Aj\u001c8h\u0003=\u0019H/\u0019:u)&lWm\u001d;b[B\u0004\u0013AD2veJ,g\u000e^*fgNLwN\\\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u00033\nY\u000fC\u0004\u0002H\u0005\u0002\r!a\u0013\u0002!\r\u0014X-\u0019;f%\u0016\u001cx.\u001e:dKRCH#\u0002(\u0002r\u0006U\bBBAzE\u0001\u00071-\u0001\u0005sKN|WO]2f\u0011\u001d\t9P\ta\u0001\u0003s\fQ#[:IiR\u0004(\u0007\u0015:j_J\\en\\<mK\u0012<W\rE\u0003:\u0003w\fi#C\u0002\u0002~j\u0012aa\u00149uS>t\u0017\u0001\u00065b]\u0012dWmQ1dQ\u0016$'+Z:pkJ\u001cW\r\u0006\u0003\u0002Z\t\r\u0001BBAzG\u0001\u00071-\u0001\fgKR\u001c\u0007n\u0014:Ck\u001a4WM\u001d*fg>,(oY3t)\u0011\tIF!\u0003\t\u000f\t-A\u00051\u0001\u0003\u000e\u0005I!/Z:pkJ\u001cWm\u001d\t\u00051\n=1-C\u0002\u0003\u0012\t\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0005I>tW\r\u0006\u0002\u0002Z\u0005\u00192/\u001a8e\u0005V4g-\u001a:fIJ+\u0017/^3tiR1\u0011\u0011\fB\u000e\u0005;AQA\u001a\u0014A\u0002\rDqAa\b'\u0001\u0004\t)*\u0001\u0004sK6|G/Z\u0001\u0018e\u0016dW-Y:f)>\\WM\\!oI\u000e{g\u000e^5ok\u0016$b!!\u0017\u0003&\t\u001d\u0002b\u0002B\u0010O\u0001\u0007\u0011Q\u0013\u0005\b\u0005S9\u0003\u0019AA\u0017\u0003\u001dI7\u000f\u0013;uaJ\nqB]3t_V\u00148-\u001a$fi\u000eDW\r\u001a\u000b\u000b\u00033\u0012yC!\r\u00036\te\u0002b\u0002B\u0010Q\u0001\u0007\u0011Q\u0013\u0005\b\u0005gA\u0003\u0019AAc\u0003\u0019\u0019H/\u0019;vg\"9!q\u0007\u0015A\u0002\u00055\u0012AB:jY\u0016tG\u000fC\u0004\u0003*!\u0002\r!!\f\u0002\u0015\r\u001c8OR3uG\",G\r\u0006\u0007\u0002Z\t}\"\u0011\tB\"\u0005;\u0012\u0019\bC\u0004\u0002\u0000%\u0002\r!!\u001f\t\u000f\tM\u0012\u00061\u0001\u0002F\"9!QI\u0015A\u0002\t\u001d\u0013A\u0004:fgB|gn]3Ti\u0006$Xo\u001d\t\u0005\u0005\u0013\u0012I&\u0004\u0002\u0003L)\u0019!G!\u0014\u000b\t\t=#\u0011K\u0001\u0006G>$Wm\u0019\u0006\u0005\u0005'\u0012)&A\u0004iC:$G.\u001a:\u000b\u0007\t]S'A\u0003oKR$\u00180\u0003\u0003\u0003\\\t-#A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukNDqAa\u0018*\u0001\u0004\u0011\t'\u0001\nmCN$Xj\u001c3jM&,Gm\u0014:Fi\u0006<\u0007#B\u001d\u0002|\n\r\u0004\u0003\u0002B3\u0005[rAAa\u001a\u0003jA\u0011!LO\u0005\u0004\u0005WR\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003p\tE$AB*ue&twMC\u0002\u0003liBqA!\u001e*\u0001\u0004\u0011\u0019'A\u0004d_:$XM\u001c;\u00021=t'+Z4vY\u0006\u0014(+Z:pkJ\u001cWMR3uG\",G\r\u0006\u0006\u0002Z\tm$Q\u0010B@\u0005\u0003Cq!a +\u0001\u0004\tI\bC\u0004\u00034)\u0002\r!!2\t\u000f\u0005\u001d#\u00061\u0001\u0002L!9!q\u0007\u0016A\u0002\u00055\u0012\u0001F8o\u0007N\u001c(+Z:pkJ\u001cWMR3uG\",G\r\u0006\t\u0002Z\t\u001d%\u0011\u0012BF\u0005\u001b\u0013yI!%\u0003\u0014\"9\u0011qP\u0016A\u0002\u0005e\u0004b\u0002B\u001aW\u0001\u0007\u0011Q\u0019\u0005\b\u0003\u000fZ\u0003\u0019AA&\u0011\u001d\u00119d\u000ba\u0001\u0003[AqA!\u0012,\u0001\u0004\u00119\u0005C\u0004\u0003`-\u0002\rA!\u0019\t\u000f\tU4\u00061\u0001\u0003d\u0005QqN\u001c*fI&\u0014Xm\u0019;\u0015\r\u0005e#\u0011\u0014BO\u0011\u0019\u0011Y\n\fa\u0001\u001d\u0006QqN]5hS:\fG\u000e\u0016=\t\r\t}E\u00061\u0001O\u0003)\u0011X\rZ5sK\u000e$H\u000b_\u0001\u0011_:\u001c\u0015m\u00195fIJ+7o\\;sG\u0016$b!!\u0017\u0003&\n\u001d\u0006bBA@[\u0001\u0007\u0011\u0011\u0010\u0005\u0006#6\u0002\rA\u0014")
public class DefaultResourceAggregator
implements ResourceAggregator,
StrictLogging {
    private final HttpTx rootTx;
    private final Seq<HttpRequest> initialResources;
    private final HttpCaches httpCaches;
    private final ResourceFetcher resourceFetcher;
    private final HttpTxExecutor httpTxExecutor;
    private final Clock clock;
    private final boolean throttled;
    private final HttpProtocol httpProtocol;
    private Session session;
    private final Set<Uri> alreadySeen;
    private final Map<Remote, List<HttpRequest>> bufferedResourcesByHost;
    private final int maxConnectionsPerHost;
    private final Map<Remote, Object> availableTokensByHost;
    private int pendingResourcesCount;
    private Status globalStatus;
    private final long startTimestamp;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private boolean throttled() {
        return this.throttled;
    }

    private HttpProtocol httpProtocol() {
        return this.httpProtocol;
    }

    private Session session() {
        return this.session;
    }

    private void session_$eq(Session x$1) {
        this.session = x$1;
    }

    private Set<Uri> alreadySeen() {
        return this.alreadySeen;
    }

    private Map<Remote, List<HttpRequest>> bufferedResourcesByHost() {
        return this.bufferedResourcesByHost;
    }

    private int maxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    private Map<Remote, Object> availableTokensByHost() {
        return this.availableTokensByHost;
    }

    private int pendingResourcesCount() {
        return this.pendingResourcesCount;
    }

    private void pendingResourcesCount_$eq(int x$1) {
        this.pendingResourcesCount = x$1;
    }

    private Status globalStatus() {
        return this.globalStatus;
    }

    private void globalStatus_$eq(Status x$1) {
        this.globalStatus = x$1;
    }

    private long startTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Session currentSession() {
        return this.session();
    }

    @Override
    public void start(Session session) {
        this.session_$eq(session);
        this.fetchOrBufferResources((Iterable<HttpRequest>)this.initialResources);
    }

    private HttpTx createResourceTx(HttpRequest resource, Option<Object> isHttp2PriorKnowledge) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Fetching resource {}", new Object[]{resource.clientRequest().getUri()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        boolean isAlpnRequired = this.rootTx.request().clientRequest().isHttp2Enabled() && isHttp2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$createResourceTx$1(BoxesRunTime.unboxToBoolean((Object)x$1))));
        Session x$4 = this.session();
        Request x$12 = resource.clientRequest().copyWithAlpnRequiredAndPriorKnowledge(isAlpnRequired, isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        String x$2 = resource.copy$default$1();
        HttpRequestConfig x$3 = resource.copy$default$3();
        HttpRequest x$5 = resource.copy(x$2, x$12, x$3);
        Some x$6 = new Some((Object)new ResourceTx(this, resource.clientRequest().getUri()));
        int x$7 = 0;
        Action x$8 = this.rootTx.copy$default$3();
        HttpTx resourceTx = this.rootTx.copy(x$4, x$5, x$8, (Option<ResourceTx>)x$6, x$7);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating resourceTx {}", new Object[]{resourceTx});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return resourceTx;
    }

    private void handleCachedResource(HttpRequest resource) {
        BoxedUnit boxedUnit;
        Uri uri = resource.clientRequest().getUri();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Fetching resource {} from cache", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean silent = resource.isSilent(false);
        if (this.httpCaches.isCssCached(uri)) {
            this.onCssResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent, HttpResponseStatus.NOT_MODIFIED, (Option<String>)None$.MODULE$, "");
        } else {
            this.onRegularResourceFetched(uri, (Status)OK$.MODULE$, this.session(), silent);
        }
    }

    private void fetchOrBufferResources(Iterable<HttpRequest> resources) {
        this.alreadySeen().$plus$plus$eq((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.clientRequest().getUri(), Iterable$.MODULE$.canBuildFrom()));
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() + resources.size());
        Tuple2 tuple2 = resources.partition((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$fetchOrBufferResources$3(this, resource)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable cached = (Iterable)tuple2._1();
        Iterable nonCached = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cached, (Object)nonCached);
        Tuple2 tuple23 = tuple22;
        Iterable cached2 = (Iterable)tuple23._1();
        Iterable nonCached2 = (Iterable)tuple23._2();
        cached2.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.handleCachedResource(resource);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map requestsByRemote = nonCached2.groupBy((Function1 & Serializable & scala.Serializable)resource -> Remote$.MODULE$.apply(resource.clientRequest().getUri()));
        if (this.httpProtocol().enginePart().enableHttp2()) {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$6(this, resources, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            requestsByRemote.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DefaultResourceAggregator.$anonfun$fetchOrBufferResources$8(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void done() {
        Session session;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("All resources were fetched");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.rootTx.silent()) {
            session = this.session();
        } else {
            Status status = this.globalStatus();
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithMark = !(status != null ? !status.equals(kO$) : kO$ != null) ? this.session().markAsFailed() : this.session();
            session = sessionWithMark.logGroupRequestTimings(this.startTimestamp(), this.clock.nowMillis());
        }
        Session newSession = session;
        this.rootTx.next().$bang(newSession);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendBufferedRequest(HttpRequest request, Remote remote) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<ContentCacheEntry> option2 = this.httpCaches.contentCacheEntry(this.session(), request.clientRequest());
        if (None$.MODULE$.equals(option2)) {
            this.httpTxExecutor.execute(this.createResourceTx(request, Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(this.session(), remote)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && (option = contentCacheEntry.expires()) instanceof Some) {
            Some some2 = (Some)option;
            long expire = BoxesRunTime.unboxToLong((Object)some2.value());
            if (this.clock.nowMillis() > expire) {
                this.session_$eq(this.httpCaches.clearContentCache(this.session(), request.clientRequest()));
                this.httpTxExecutor.execute(this.createResourceTx(request, Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(this.session(), remote)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.handleCachedResource(request);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void releaseTokenAndContinue(Remote remote, boolean isHttp2) {
        Some some;
        List list;
        Option option = this.bufferedResourcesByHost().get((Object)remote);
        boolean bl = option instanceof Some && Nil$.MODULE$.equals(list = (List)(some = (Some)option).value()) ? true : None$.MODULE$.equals(option);
        if (bl) {
            int availableToken = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)(availableToken == this.maxConnectionsPerHost() ? BoxesRunTime.boxToInteger((int)availableToken) : BoxesRunTime.boxToInteger((int)(availableToken + 1)))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some2 = (Some)option;
            List requests = (List)some2.value();
            if (isHttp2) {
                this.bufferedResourcesByHost().remove((Object)remote);
                requests.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    this.sendBufferedRequest(x$7, remote);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                List list2 = requests;
                if (!(list2 instanceof .colon.colon)) {
                    throw new MatchError((Object)list2);
                }
                .colon.colon colon2 = (.colon.colon)list2;
                HttpRequest request = (HttpRequest)colon2.head();
                List tail = colon2.tl$access$1();
                Tuple2 tuple2 = new Tuple2((Object)request, (Object)tail);
                Tuple2 tuple22 = tuple2;
                HttpRequest request2 = (HttpRequest)tuple22._1();
                List tail2 = (List)tuple22._2();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)tail2));
                this.sendBufferedRequest(request2, remote);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void resourceFetched(Remote remote, Status status, boolean silent, boolean isHttp2) {
        this.pendingResourcesCount_$eq(this.pendingResourcesCount() - 1);
        if (!silent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
                this.globalStatus_$eq((Status)KO$.MODULE$);
            }
        }
        if (this.pendingResourcesCount() == 0) {
            this.done();
        } else {
            this.releaseTokenAndContinue(remote, isHttp2);
        }
    }

    private void cssFetched(Uri uri, Status status, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        block0: {
            List<HttpRequest> cssResources;
            Status status2 = status;
            OK$ oK$ = OK$.MODULE$;
            if ((status2 != null ? !status2.equals(oK$) : oK$ != null) || !(cssResources = this.resourceFetcher.cssFetched(uri, responseStatus, lastModifiedOrEtag, content, this.session(), this.throttled())).nonEmpty()) break block0;
            List filtered = (List)cssResources.filterNot((Function1 & Serializable & scala.Serializable)resource -> BoxesRunTime.boxToBoolean((boolean)DefaultResourceAggregator.$anonfun$cssFetched$1(this, resource)));
            this.fetchOrBufferResources((Iterable<HttpRequest>)filtered);
        }
    }

    @Override
    public void onRegularResourceFetched(Uri uri, Status status, Session session, boolean silent) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onCssResourceFetched(Uri uri, Status status, Session session, boolean silent, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Css resource {} was fetched", new Object[]{uri});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.session_$eq(session);
        this.cssFetched(uri, status, responseStatus, lastModifiedOrEtag, content);
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, status, silent, Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(session, remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    @Override
    public void onRedirect(HttpTx originalTx, HttpTx redirectTx) {
        Remote redirectRemote;
        this.session_$eq(redirectTx.session());
        Uri originUri = originalTx.request().clientRequest().getUri();
        Remote originRemote = Remote$.MODULE$.apply(originUri);
        Uri redirectUri = redirectTx.request().clientRequest().getUri();
        Remote remote = redirectRemote = Remote$.MODULE$.apply(redirectUri);
        Remote remote2 = originRemote;
        if (!(remote != null ? !remote.equals(remote2) : remote2 != null)) {
            this.sendBufferedRequest(redirectTx.request(), redirectRemote);
        } else {
            this.releaseTokenAndContinue(originRemote, Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(this.session(), originRemote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) - 1))));
            if (BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)redirectRemote)) > 0) {
                this.sendBufferedRequest(redirectTx.request(), redirectRemote);
            } else {
                HttpRequest httpRequest = redirectTx.request();
                this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)redirectRemote), (Object)((List)this.bufferedResourcesByHost().apply((Object)redirectRemote)).$colon$colon((Object)httpRequest)));
            }
        }
    }

    @Override
    public void onCachedResource(Uri uri, HttpTx tx) {
        Remote remote = Remote$.MODULE$.apply(uri);
        this.resourceFetched(remote, (Status)OK$.MODULE$, tx.silent(), Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(tx.session(), remote).contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public static final /* synthetic */ boolean $anonfun$createResourceTx$1(boolean x$1) {
        return x$1;
    }

    private final void fetchAndBufferWithTokens$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        int availableTokens = BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote));
        Tuple2 tuple2 = resources.splitAt(availableTokens);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterable immediate = (Iterable)tuple2._1();
        Iterable buffered = (Iterable)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)immediate, (Object)buffered);
        Tuple2 tuple23 = tuple22;
        Iterable immediate2 = (Iterable)tuple23._1();
        Iterable buffered2 = (Iterable)tuple23._2();
        this.fetchHttp1Resources$1(remote, immediate2, isHttp2PriorKnowledge);
        this.bufferResources$1(remote, buffered2);
    }

    private final void fetchHttp1Resources$1(Remote remote, Iterable resources, Option isHttp2PriorKnowledge) {
        this.availableTokensByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.availableTokensByHost().apply((Object)remote)) - resources.size()))));
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            this.httpTxExecutor.execute(this.createResourceTx(resource, (Option<Object>)isHttp2PriorKnowledge));
            return BoxedUnit.UNIT;
        });
    }

    private final void bufferResources$1(Remote remote, Iterable resources) {
        List list = (List)this.bufferedResourcesByHost().apply((Object)remote);
        this.bufferedResourcesByHost().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)remote), (Object)resources.toList().$colon$colon$colon(list)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fetchOrBufferResources$3(DefaultResourceAggregator $this, HttpRequest resource) {
        Option<Object> option;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Request request = resource.clientRequest();
        Option<ContentCacheEntry> option2 = $this.httpCaches.contentCacheEntry($this.session(), request);
        if (None$.MODULE$.equals(option2)) {
            return false;
        }
        if (option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && None$.MODULE$.equals(option = contentCacheEntry.expires())) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (!(option2 instanceof Some)) return true;
        Some some2 = (Some)option2;
        ContentCacheEntry contentCacheEntry2 = (ContentCacheEntry)some2.value();
        if (contentCacheEntry2 == null) return true;
        Option<Object> option3 = contentCacheEntry2.expires();
        if (!(option3 instanceof Some)) return true;
        Some some3 = (Some)option3;
        long expire = BoxesRunTime.unboxToLong((Object)some3.value());
        if ($this.clock.nowMillis() <= expire) return true;
        $this.session_$eq($this.httpCaches.clearContentCache($this.session(), request));
        return false;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$6(DefaultResourceAggregator $this, Iterable resources$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Remote remote = (Remote)tuple2._1();
            Iterable res = (Iterable)tuple2._2();
            Option<Object> isHttp2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge($this.session(), remote);
            if (isHttp2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                $this.httpTxExecutor.execute((Iterable<HttpTx>)((Iterable)resources$1.map((Function1 & Serializable & scala.Serializable)x$6 -> $this.createResourceTx((HttpRequest)x$6, isHttp2PriorKnowledge), Iterable$.MODULE$.canBuildFrom())));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.fetchAndBufferWithTokens$1(remote, res, isHttp2PriorKnowledge);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$fetchOrBufferResources$8(DefaultResourceAggregator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Remote remote = (Remote)tuple2._1();
        Iterable res = (Iterable)tuple2._2();
        $this.fetchAndBufferWithTokens$1(remote, res, (Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$cssFetched$1(DefaultResourceAggregator $this, HttpRequest resource) {
        return $this.alreadySeen().contains((Object)resource.clientRequest().getUri());
    }

    public DefaultResourceAggregator(HttpTx rootTx, Seq<HttpRequest> initialResources, HttpCaches httpCaches, ResourceFetcher resourceFetcher, HttpTxExecutor httpTxExecutor, Clock clock, GatlingConfiguration configuration) {
        this.rootTx = rootTx;
        this.initialResources = initialResources;
        this.httpCaches = httpCaches;
        this.resourceFetcher = resourceFetcher;
        this.httpTxExecutor = httpTxExecutor;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.throttled = rootTx.request().requestConfig().throttled();
        this.httpProtocol = rootTx.request().requestConfig().httpProtocol();
        this.alreadySeen = Set$.MODULE$.empty();
        this.bufferedResourcesByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)Nil$.MODULE$);
        this.maxConnectionsPerHost = this.httpProtocol().enginePart().maxConnectionsPerHost();
        this.availableTokensByHost = HashMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)this.maxConnectionsPerHost()));
        this.pendingResourcesCount = 0;
        this.globalStatus = OK$.MODULE$;
        this.startTimestamp = clock.nowMillis();
    }
}

