/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.falcon;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon.FalconKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon.FalconKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon.FalconParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon.FalconPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.falcon.BCFalconPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import io.gatling.recorder.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class FalconKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    FalconKeyGenerationParameters param;
    FalconKeyPairGenerator engine = new FalconKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public FalconKeyPairGeneratorSpi() {
        super("Falcon");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = FalconKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new FalconKeyGenerationParameters(secureRandom, (FalconParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof FalconParameterSpec) {
            FalconParameterSpec falconParameterSpec = (FalconParameterSpec)algorithmParameterSpec;
            return falconParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new FalconKeyGenerationParameters(this.random, FalconParameters.falcon_512);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        FalconPublicKeyParameters falconPublicKeyParameters = (FalconPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        FalconPrivateKeyParameters falconPrivateKeyParameters = (FalconPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCFalconPublicKey(falconPublicKeyParameters), new BCFalconPrivateKey(falconPrivateKeyParameters));
    }

    static {
        parameters.put(FalconParameterSpec.falcon_512.getName(), FalconParameters.falcon_512);
        parameters.put(FalconParameterSpec.falcon_1024.getName(), FalconParameters.falcon_1024);
    }
}

