/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.rainbow;

import io.gatling.recorder.internal.bouncycastle.asn1.DERNull;
import io.gatling.recorder.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.gatling.recorder.internal.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.pqc.asn1.RainbowPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.RainbowPublicKeySpec;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.rainbow.RainbowParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.rainbow.RainbowPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.rainbow.util.RainbowUtil;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;
import java.security.PublicKey;

public class BCRainbowPublicKey
implements PublicKey {
    private static final long serialVersionUID = 1L;
    private short[][] coeffquadratic;
    private short[][] coeffsingular;
    private short[] coeffscalar;
    private int docLength;
    private RainbowParameters rainbowParams;

    public BCRainbowPublicKey(int n, short[][] sArray, short[][] sArray2, short[] sArray3) {
        this.docLength = n;
        this.coeffquadratic = sArray;
        this.coeffsingular = sArray2;
        this.coeffscalar = sArray3;
    }

    public BCRainbowPublicKey(RainbowPublicKeySpec rainbowPublicKeySpec) {
        this(rainbowPublicKeySpec.getDocLength(), rainbowPublicKeySpec.getCoeffQuadratic(), rainbowPublicKeySpec.getCoeffSingular(), rainbowPublicKeySpec.getCoeffScalar());
    }

    public BCRainbowPublicKey(RainbowPublicKeyParameters rainbowPublicKeyParameters) {
        this(rainbowPublicKeyParameters.getDocLength(), rainbowPublicKeyParameters.getCoeffQuadratic(), rainbowPublicKeyParameters.getCoeffSingular(), rainbowPublicKeyParameters.getCoeffScalar());
    }

    public int getDocLength() {
        return this.docLength;
    }

    public short[][] getCoeffQuadratic() {
        return this.coeffquadratic;
    }

    public short[][] getCoeffSingular() {
        short[][] sArrayArray = new short[this.coeffsingular.length][];
        for (int i = 0; i != this.coeffsingular.length; ++i) {
            sArrayArray[i] = Arrays.clone(this.coeffsingular[i]);
        }
        return sArrayArray;
    }

    public short[] getCoeffScalar() {
        return Arrays.clone(this.coeffscalar);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCRainbowPublicKey)) {
            return false;
        }
        BCRainbowPublicKey bCRainbowPublicKey = (BCRainbowPublicKey)object;
        return this.docLength == bCRainbowPublicKey.getDocLength() && RainbowUtil.equals(this.coeffquadratic, bCRainbowPublicKey.getCoeffQuadratic()) && RainbowUtil.equals(this.coeffsingular, bCRainbowPublicKey.getCoeffSingular()) && RainbowUtil.equals(this.coeffscalar, bCRainbowPublicKey.getCoeffScalar());
    }

    public int hashCode() {
        int n = this.docLength;
        n = n * 37 + Arrays.hashCode(this.coeffquadratic);
        n = n * 37 + Arrays.hashCode(this.coeffsingular);
        n = n * 37 + Arrays.hashCode(this.coeffscalar);
        return n;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        RainbowPublicKey rainbowPublicKey = new RainbowPublicKey(this.docLength, this.coeffquadratic, this.coeffsingular, this.coeffscalar);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, DERNull.INSTANCE);
        return KeyUtil.getEncodedSubjectPublicKeyInfo(algorithmIdentifier, rainbowPublicKey);
    }
}

