/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike;

import io.gatling.recorder.internal.bouncycastle.crypto.digests.SHAKEDigest;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.Fpx;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.Internal;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.Isogeny;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.P434;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.P503;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.P610;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.P751;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.SIDH;
import io.gatling.recorder.internal.bouncycastle.pqc.legacy.crypto.sike.SIDH_Compressed;
import java.security.SecureRandom;

class SIKEEngine {
    protected Internal params;
    protected Isogeny isogeny;
    protected Fpx fpx;
    private SIDH sidh;
    private SIDH_Compressed sidhCompressed;
    private boolean isCompressed;

    public int getDefaultSessionKeySize() {
        return this.params.MSG_BYTES * 8;
    }

    public int getCipherTextSize() {
        return this.params.CRYPTO_CIPHERTEXTBYTES;
    }

    public int getPrivateKeySize() {
        return this.params.CRYPTO_SECRETKEYBYTES;
    }

    public int getPublicKeySize() {
        return this.params.CRYPTO_PUBLICKEYBYTES;
    }

    public SIKEEngine(int n, boolean bl) {
        this.isCompressed = bl;
        switch (n) {
            case 434: {
                this.params = new P434(bl);
                break;
            }
            case 503: {
                this.params = new P503(bl);
                break;
            }
            case 610: {
                this.params = new P610(bl);
                break;
            }
            case 751: {
                this.params = new P751(bl);
                break;
            }
        }
        this.fpx = new Fpx(this);
        this.isogeny = new Isogeny(this);
        if (bl) {
            this.sidhCompressed = new SIDH_Compressed(this);
        }
        this.sidh = new SIDH(this);
    }

    public int crypto_kem_keypair(byte[] byArray, byte[] byArray2, SecureRandom secureRandom) {
        byte[] byArray3 = new byte[this.params.MSG_BYTES];
        secureRandom.nextBytes(byArray3);
        if (this.isCompressed) {
            byte[] byArray4 = new byte[this.params.SECRETKEY_A_BYTES];
            secureRandom.nextBytes(byArray4);
            byArray4[0] = (byte)(byArray4[0] & 0xFE);
            int n = this.params.SECRETKEY_A_BYTES - 1;
            byArray4[n] = (byte)(byArray4[n] & this.params.MASK_ALICE);
            System.arraycopy(byArray3, 0, byArray2, 0, this.params.MSG_BYTES);
            System.arraycopy(byArray4, 0, byArray2, this.params.MSG_BYTES, this.params.SECRETKEY_A_BYTES);
            this.sidhCompressed.EphemeralKeyGeneration_A_extended(byArray2, byArray);
            System.arraycopy(byArray, 0, byArray2, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        } else {
            byte[] byArray5 = new byte[this.params.SECRETKEY_B_BYTES];
            secureRandom.nextBytes(byArray5);
            int n = this.params.SECRETKEY_B_BYTES - 1;
            byArray5[n] = (byte)(byArray5[n] & this.params.MASK_BOB);
            System.arraycopy(byArray3, 0, byArray2, 0, this.params.MSG_BYTES);
            System.arraycopy(byArray5, 0, byArray2, this.params.MSG_BYTES, this.params.SECRETKEY_B_BYTES);
            this.sidh.EphemeralKeyGeneration_B(byArray2, byArray);
            System.arraycopy(byArray, 0, byArray2, this.params.MSG_BYTES + this.params.SECRETKEY_B_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        }
        return 0;
    }

    public int crypto_kem_enc(byte[] byArray, byte[] byArray2, byte[] byArray3, SecureRandom secureRandom) {
        if (this.isCompressed) {
            byte[] byArray4 = new byte[this.params.SECRETKEY_B_BYTES];
            byte[] byArray5 = new byte[this.params.FP2_ENCODED_BYTES];
            byte[] byArray6 = new byte[this.params.MSG_BYTES];
            byte[] byArray7 = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
            byte[] byArray8 = new byte[this.params.MSG_BYTES];
            secureRandom.nextBytes(byArray8);
            System.arraycopy(byArray8, 0, byArray7, 0, this.params.MSG_BYTES);
            System.arraycopy(byArray3, 0, byArray7, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
            SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
            sHAKEDigest.update(byArray7, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
            sHAKEDigest.doFinal(byArray4, 0, this.params.SECRETKEY_B_BYTES);
            this.sidhCompressed.FormatPrivKey_B(byArray4);
            this.sidhCompressed.EphemeralKeyGeneration_B_extended(byArray4, byArray, 1);
            this.sidhCompressed.EphemeralSecretAgreement_B(byArray4, byArray3, byArray5);
            sHAKEDigest.update(byArray5, 0, this.params.FP2_ENCODED_BYTES);
            sHAKEDigest.doFinal(byArray6, 0, this.params.MSG_BYTES);
            for (int i = 0; i < this.params.MSG_BYTES; ++i) {
                byArray[i + this.params.PARTIALLY_COMPRESSED_CHUNK_CT] = (byte)(byArray7[i] ^ byArray6[i]);
            }
            System.arraycopy(byArray, 0, byArray7, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
            sHAKEDigest.update(byArray7, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
            sHAKEDigest.doFinal(byArray2, 0, this.params.CRYPTO_BYTES);
            return 0;
        }
        byte[] byArray9 = new byte[this.params.SECRETKEY_A_BYTES];
        byte[] byArray10 = new byte[this.params.FP2_ENCODED_BYTES];
        byte[] byArray11 = new byte[this.params.MSG_BYTES];
        byte[] byArray12 = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
        byte[] byArray13 = new byte[this.params.MSG_BYTES];
        secureRandom.nextBytes(byArray13);
        System.arraycopy(byArray13, 0, byArray12, 0, this.params.MSG_BYTES);
        System.arraycopy(byArray3, 0, byArray12, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray12, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
        sHAKEDigest.doFinal(byArray9, 0, this.params.SECRETKEY_A_BYTES);
        int n = this.params.SECRETKEY_A_BYTES - 1;
        byArray9[n] = (byte)(byArray9[n] & this.params.MASK_ALICE);
        this.sidh.EphemeralKeyGeneration_A(byArray9, byArray);
        this.sidh.EphemeralSecretAgreement_A(byArray9, byArray3, byArray10);
        sHAKEDigest.update(byArray10, 0, this.params.FP2_ENCODED_BYTES);
        sHAKEDigest.doFinal(byArray11, 0, this.params.MSG_BYTES);
        for (int i = 0; i < this.params.MSG_BYTES; ++i) {
            byArray[i + this.params.CRYPTO_PUBLICKEYBYTES] = (byte)(byArray12[i] ^ byArray11[i]);
        }
        System.arraycopy(byArray, 0, byArray12, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
        sHAKEDigest.update(byArray12, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
        sHAKEDigest.doFinal(byArray2, 0, this.params.CRYPTO_BYTES);
        return 0;
    }

    public int crypto_kem_dec(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte by;
        if (this.isCompressed) {
            byte by2;
            byte[] byArray4 = new byte[this.params.SECRETKEY_B_BYTES];
            byte[] byArray5 = new byte[this.params.FP2_ENCODED_BYTES + 2 * this.params.FP2_ENCODED_BYTES + this.params.SECRETKEY_A_BYTES];
            byte[] byArray6 = new byte[this.params.MSG_BYTES];
            byte[] byArray7 = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
            byte[] byArray8 = byArray5;
            this.sidhCompressed.EphemeralSecretAgreement_A_extended(byArray3, this.params.MSG_BYTES, byArray2, byArray5, 1);
            SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
            sHAKEDigest.update(byArray5, 0, this.params.FP2_ENCODED_BYTES);
            sHAKEDigest.doFinal(byArray6, 0, this.params.MSG_BYTES);
            for (by2 = 0; by2 < this.params.MSG_BYTES; ++by2) {
                byArray7[by2] = (byte)(byArray2[by2 + this.params.PARTIALLY_COMPRESSED_CHUNK_CT] ^ byArray6[by2]);
            }
            System.arraycopy(byArray3, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES, byArray7, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
            sHAKEDigest.update(byArray7, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
            sHAKEDigest.doFinal(byArray4, 0, this.params.SECRETKEY_B_BYTES);
            this.sidhCompressed.FormatPrivKey_B(byArray4);
            by2 = this.sidhCompressed.validate_ciphertext(byArray4, byArray2, byArray3, this.params.MSG_BYTES + this.params.SECRETKEY_A_BYTES + this.params.CRYPTO_PUBLICKEYBYTES, byArray8, this.params.FP2_ENCODED_BYTES);
            this.fpx.ct_cmov(byArray7, byArray3, this.params.MSG_BYTES, by2);
            System.arraycopy(byArray2, 0, byArray7, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
            sHAKEDigest.update(byArray7, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
            sHAKEDigest.doFinal(byArray, 0, this.params.CRYPTO_BYTES);
            return 0;
        }
        byte[] byArray9 = new byte[this.params.SECRETKEY_A_BYTES];
        byte[] byArray10 = new byte[this.params.FP2_ENCODED_BYTES];
        byte[] byArray11 = new byte[this.params.MSG_BYTES];
        byte[] byArray12 = new byte[this.params.CRYPTO_PUBLICKEYBYTES];
        byte[] byArray13 = new byte[this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES];
        this.sidh.EphemeralSecretAgreement_B(byArray3, byArray2, byArray10);
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray10, 0, this.params.FP2_ENCODED_BYTES);
        sHAKEDigest.doFinal(byArray11, 0, this.params.MSG_BYTES);
        for (by = 0; by < this.params.MSG_BYTES; ++by) {
            byArray13[by] = (byte)(byArray2[by + this.params.CRYPTO_PUBLICKEYBYTES] ^ byArray11[by]);
        }
        System.arraycopy(byArray3, this.params.MSG_BYTES + this.params.SECRETKEY_B_BYTES, byArray13, this.params.MSG_BYTES, this.params.CRYPTO_PUBLICKEYBYTES);
        sHAKEDigest.update(byArray13, 0, this.params.CRYPTO_PUBLICKEYBYTES + this.params.MSG_BYTES);
        sHAKEDigest.doFinal(byArray9, 0, this.params.SECRETKEY_A_BYTES);
        int n = this.params.SECRETKEY_A_BYTES - 1;
        byArray9[n] = (byte)(byArray9[n] & this.params.MASK_ALICE);
        this.sidh.EphemeralKeyGeneration_A(byArray9, byArray12);
        by = this.fpx.ct_compare(byArray12, byArray2, this.params.CRYPTO_PUBLICKEYBYTES);
        this.fpx.ct_cmov(byArray13, byArray3, this.params.MSG_BYTES, by);
        System.arraycopy(byArray2, 0, byArray13, this.params.MSG_BYTES, this.params.CRYPTO_CIPHERTEXTBYTES);
        sHAKEDigest.update(byArray13, 0, this.params.CRYPTO_CIPHERTEXTBYTES + this.params.MSG_BYTES);
        sHAKEDigest.doFinal(byArray, 0, this.params.CRYPTO_BYTES);
        return 0;
    }
}

