/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.crypto.engines;

import io.gatling.recorder.internal.bouncycastle.crypto.DataLengthException;
import io.gatling.recorder.internal.bouncycastle.crypto.InvalidCipherTextException;
import io.gatling.recorder.internal.bouncycastle.crypto.OutputLengthException;
import io.gatling.recorder.internal.bouncycastle.crypto.engines.AEADBaseEngine;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;

abstract class AEADBufferBaseEngine
extends AEADBaseEngine {
    protected byte[] m_buf;
    protected byte[] m_aad;
    protected int m_bufPos;
    protected int m_aadPos;
    protected boolean aadFinished;
    protected boolean initialised = false;
    protected int AADBufferSize;
    protected int BlockSize;
    protected State m_state = State.Uninitialized;

    AEADBufferBaseEngine() {
    }

    @Override
    public void processAADByte(byte by) {
        this.checkAAD();
        if (this.m_aadPos == this.AADBufferSize) {
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        this.m_aad[this.m_aadPos++] = by;
    }

    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_aadPos > 0) {
            int n3 = this.AADBufferSize - this.m_aadPos;
            if (n2 <= n3) {
                System.arraycopy(byArray, n, this.m_aad, this.m_aadPos, n2);
                this.m_aadPos += n2;
                return;
            }
            System.arraycopy(byArray, n, this.m_aad, this.m_aadPos, n3);
            n += n3;
            n2 -= n3;
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        while (n2 > this.AADBufferSize) {
            this.processBufferAAD(byArray, n);
            n += this.AADBufferSize;
            n2 -= this.AADBufferSize;
        }
        System.arraycopy(byArray, n, this.m_aad, this.m_aadPos, n2);
        this.m_aadPos += n2;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (n + n2 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean bl = this.checkData();
        int n4 = 0;
        if (bl) {
            if (this.m_bufPos > 0) {
                int n5 = this.BlockSize - this.m_bufPos;
                if (n2 <= n5) {
                    System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                    this.m_bufPos += n2;
                    return 0;
                }
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n5);
                n += n5;
                n2 -= n5;
                this.validateAndProcessBuffer(this.m_buf, 0, byArray2, n3);
                n4 = this.BlockSize;
            }
            while (n2 > this.BlockSize) {
                this.validateAndProcessBuffer(byArray, n, byArray2, n3 + n4);
                n += this.BlockSize;
                n2 -= this.BlockSize;
                n4 += this.BlockSize;
            }
        } else {
            int n6 = this.BlockSize + this.MAC_SIZE - this.m_bufPos;
            if (n2 <= n6) {
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                this.m_bufPos += n2;
                return 0;
            }
            if (this.BlockSize >= this.MAC_SIZE) {
                if (this.m_bufPos > this.BlockSize) {
                    this.validateAndProcessBuffer(this.m_buf, 0, byArray2, n3);
                    this.m_bufPos -= this.BlockSize;
                    System.arraycopy(this.m_buf, this.BlockSize, this.m_buf, 0, this.m_bufPos);
                    n4 = this.BlockSize;
                    if (n2 <= (n6 += this.BlockSize)) {
                        System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                        this.m_bufPos += n2;
                        return n4;
                    }
                }
                n6 = this.BlockSize - this.m_bufPos;
                System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n6);
                n += n6;
                n2 -= n6;
                this.validateAndProcessBuffer(this.m_buf, 0, byArray2, n3 + n4);
                n4 += this.BlockSize;
            } else {
                while (this.m_bufPos > this.BlockSize && n2 + this.m_bufPos > this.BlockSize + this.MAC_SIZE) {
                    this.validateAndProcessBuffer(this.m_buf, n4, byArray2, n3 + n4);
                    this.m_bufPos -= this.BlockSize;
                    n4 += this.BlockSize;
                }
                if (this.m_bufPos != 0) {
                    System.arraycopy(this.m_buf, n4, this.m_buf, 0, this.m_bufPos);
                    if (this.m_bufPos + n2 > this.BlockSize + this.MAC_SIZE) {
                        n6 = Math.max(this.BlockSize - this.m_bufPos, 0);
                        System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n6);
                        n += n6;
                        this.validateAndProcessBuffer(this.m_buf, 0, byArray2, n3 + n4);
                        n4 += this.BlockSize;
                        n2 -= n6;
                    } else {
                        System.arraycopy(byArray, n, this.m_buf, this.m_bufPos, n2);
                        this.m_bufPos += n2;
                        return n4;
                    }
                }
            }
            while (n2 > this.BlockSize + this.MAC_SIZE) {
                this.validateAndProcessBuffer(byArray, n, byArray2, n3 + n4);
                n += this.BlockSize;
                n2 -= this.BlockSize;
                n4 += this.BlockSize;
            }
        }
        System.arraycopy(byArray, n, this.m_buf, 0, n2);
        this.m_bufPos = n2;
        return n4;
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        boolean bl = this.checkData();
        if (bl) {
            n2 = this.m_bufPos + this.MAC_SIZE;
        } else {
            if (this.m_bufPos < this.MAC_SIZE) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.MAC_SIZE;
            n2 = this.m_bufPos;
        }
        if (n > byArray.length - n2) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processFinalBlock(byArray, n);
        if (bl) {
            System.arraycopy(this.mac, 0, byArray, n + n2 - this.MAC_SIZE, this.MAC_SIZE);
        } else if (!Arrays.constantTimeAreEqual(this.MAC_SIZE, this.mac, 0, this.m_buf, this.m_bufPos)) {
            throw new InvalidCipherTextException(this.algorithmName + " mac does not match");
        }
        this.reset(!bl);
        return n2;
    }

    public int getBlockSize() {
        return this.BlockSize;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        int n2 = Math.max(0, n) - 1;
        switch (this.m_state.ordinal()) {
            case 5: 
            case 6: {
                n2 = Math.max(0, n2 - this.MAC_SIZE);
                break;
            }
            case 7: 
            case 8: {
                n2 = Math.max(0, n2 + this.m_bufPos - this.MAC_SIZE);
                break;
            }
            case 3: 
            case 4: {
                n2 = Math.max(0, n2 + this.m_bufPos);
                break;
            }
        }
        return n2 - n2 % this.BlockSize;
    }

    @Override
    public int getOutputSize(int n) {
        int n2 = Math.max(0, n);
        switch (this.m_state.ordinal()) {
            case 5: 
            case 6: {
                return Math.max(0, n2 - this.MAC_SIZE);
            }
            case 7: 
            case 8: {
                return Math.max(0, n2 + this.m_bufPos - this.MAC_SIZE);
            }
            case 3: 
            case 4: {
                return n2 + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return n2 + this.MAC_SIZE;
    }

    protected void checkAAD() {
        switch (this.m_state.ordinal()) {
            case 5: {
                this.m_state = State.DecAad;
                break;
            }
            case 1: {
                this.m_state = State.EncAad;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state.ordinal()) {
            case 5: 
            case 6: {
                this.finishAAD(State.DecData);
                return false;
            }
            case 1: 
            case 2: {
                this.finishAAD(State.EncData);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void finishAAD(State state) {
        switch (this.m_state.ordinal()) {
            case 2: 
            case 6: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_aadPos = 0;
        this.m_state = state;
    }

    protected void bufferReset() {
        Arrays.fill(this.m_buf, (byte)0);
        Arrays.fill(this.m_aad, (byte)0);
        this.m_bufPos = 0;
        this.m_aadPos = 0;
        switch (this.m_state.ordinal()) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = State.DecInit;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = State.EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected void validateAndProcessBuffer(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n2 > byArray2.length - this.BlockSize) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBuffer(byArray, n, byArray2, n2);
    }

    protected abstract void processFinalBlock(byte[] var1, int var2);

    protected abstract void processBufferAAD(byte[] var1, int var2);

    protected abstract void processFinalAAD();

    protected abstract void processBuffer(byte[] var1, int var2, byte[] var3, int var4);

    protected static enum State {
        Uninitialized,
        EncInit,
        EncAad,
        EncData,
        EncFinal,
        DecInit,
        DecAad,
        DecData,
        DecFinal;

    }
}

