/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.http;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.client.uri.Uri;
import io.gatling.netty.util.ahc.ByteBufUtils;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.http.flows.Remote;
import io.gatling.recorder.model.HttpRequest;
import io.gatling.recorder.model.HttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0005\u000b\u0001MA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019I\u0005\u0001)A\u0005c!)!\n\u0001C\u0001\u0017\")Q\r\u0001C\u0001M\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0005\u0001\t\u0003\t)BA\u0007Ue\u00064g-[2M_\u001e<WM\u001d\u0006\u0003\u00171\tA\u0001\u001b;ua*\u0011QBD\u0001\te\u0016\u001cwN\u001d3fe*\u0011q\u0002E\u0001\bO\u0006$H.\u001b8h\u0015\u0005\t\u0012AA5p\u0007\u0001\u00192\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111DI\u0007\u00029)\u0011QDH\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003?\u0001\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002C\u0005\u00191m\\7\n\u0005\rb\"!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0006d_:$(o\u001c7mKJ\u0004\"A\n\u0015\u000e\u0003\u001dR!\u0001\n\u0007\n\u0005%:#A\u0005*fG>\u0014H-\u001a:D_:$(o\u001c7mKJ\fa\u0001P5oSRtDC\u0001\u0017/!\ti\u0003!D\u0001\u000b\u0011\u0015!#\u00011\u0001&\u000391G._5oOJ+\u0017/^3tiN,\u0012!\r\t\u0005eeZ4)D\u00014\u0015\t!T'\u0001\u0006d_:\u001cWO\u001d:f]RT!AN\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u0005!!.\u0019<b\u0013\tQ4GA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000f\rD\u0017M\u001c8fY*\u0011\u0001\tE\u0001\u0006]\u0016$H/_\u0005\u0003\u0005v\u0012\u0011b\u00115b]:,G.\u00133\u0011\u0005\u0011;U\"A#\u000b\u0005\u0019c\u0011!B7pI\u0016d\u0017B\u0001%F\u0005-AE\u000f\u001e9SKF,Xm\u001d;\u0002\u001f\u0019d\u00170\u001b8h%\u0016\fX/Z:ug\u0002\nA\u0002\\8h\u000bb\u001cW\r\u001d;j_:$2\u0001T(X!\t)R*\u0003\u0002O-\t!QK\\5u\u0011\u0015\u0001V\u00011\u0001R\u0003\u0019\u0011X-\\8uKB\u0011!+V\u0007\u0002'*\u0011AKC\u0001\u0006M2|wo]\u0005\u0003-N\u0013aAU3n_R,\u0007\"\u0002-\u0006\u0001\u0004I\u0016!\u0003;ie><\u0018M\u00197f!\tQ&M\u0004\u0002\\A:\u0011AlX\u0007\u0002;*\u0011aLE\u0001\u0007yI|w\u000e\u001e \n\u0003]I!!\u0019\f\u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\n)\"\u0014xn^1cY\u0016T!!\u0019\f\u0002\u00151|wMU3rk\u0016\u001cH\u000f\u0006\u0004MO&$XO\u001f\u0005\u0006Q\u001a\u0001\raO\u0001\u0010g\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7JI\")!N\u0002a\u0001W\u00069!/Z9vKN$\bC\u00017s\u001b\u0005i'BA\u0006o\u0015\ty\u0007/A\u0003d_\u0012,7M\u0003\u0002r\u007f\u00059\u0001.\u00198eY\u0016\u0014\u0018BA:n\u0005=1U\u000f\u001c7IiR\u0004(+Z9vKN$\b\"\u0002)\u0007\u0001\u0004\t\u0006\"\u0002<\u0007\u0001\u00049\u0018!\u00025uiB\u001c\bCA\u000by\u0013\tIhCA\u0004C_>dW-\u00198\t\u000bm4\u0001\u0019\u0001?\u0002\u001bM,g\u000e\u001a+j[\u0016\u001cH/Y7q!\t)R0\u0003\u0002\u007f-\t!Aj\u001c8h\u0003-awn\u001a*fgB|gn]3\u0015\u000f1\u000b\u0019!!\u0002\u0002\u0010!)\u0001n\u0002a\u0001w!9\u0011qA\u0004A\u0002\u0005%\u0011\u0001\u0003:fgB|gn]3\u0011\u00071\fY!C\u0002\u0002\u000e5\u0014\u0001CR;mY\"#H\u000f\u001d*fgB|gn]3\t\r\u0005Eq\u00011\u0001}\u0003A\u0011XmY3jm\u0016$\u0016.\\3ti\u0006l\u0007/A\u0003dY\u0016\f'\u000fF\u0002M\u0003/AQ\u0001\u001b\u0005A\u0002m\u0002")
public class TrafficLogger
implements StrictLogging {
    private final RecorderController controller;
    private final ConcurrentHashMap<ChannelId, HttpRequest> flyingRequests;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<ChannelId, HttpRequest> flyingRequests() {
        return this.flyingRequests;
    }

    public void logException(Remote remote, Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof IOException) {
            BoxedUnit boxedUnit;
            Uri targetHostUri = Uri.create((String)new StringBuilder(9).append("https://").append(remote.host()).append(":").append(remote.port()).toString());
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("SslException, did you accept the certificate for {}?", new Object[]{targetHostUri});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.controller.secureConnection(targetHostUri);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logRequest(ChannelId serverChannelId, FullHttpRequest request, Remote remote, boolean https, long sendTimestamp) {
        block0: {
            HttpMethod httpMethod = request.method();
            HttpMethod httpMethod2 = HttpMethod.CONNECT;
            if (!(httpMethod == null ? httpMethod2 != null : !httpMethod.equals(httpMethod2)) || request.headers().contains((CharSequence)HttpHeaderValues.UPGRADE)) break block0;
            HttpRequest requestEvent = new HttpRequest(request.protocolVersion().text(), request.method().name(), remote.makeAbsoluteUri(request.uri(), https), new DefaultHttpHeaders().add(request.headers()).add(request.trailingHeaders()), ByteBufUtils.byteBuf2Bytes((ByteBuf)request.content()), sendTimestamp);
            this.flyingRequests().put(serverChannelId, requestEvent);
        }
    }

    public void logResponse(ChannelId serverChannelId, FullHttpResponse response, long receiveTimestamp) {
        Option$.MODULE$.apply((Object)this.flyingRequests().get(serverChannelId)).foreach((Function1 & Serializable & scala.Serializable)requestEvent -> {
            TrafficLogger.$anonfun$logResponse$1(this, serverChannelId, response, receiveTimestamp, requestEvent);
            return BoxedUnit.UNIT;
        });
    }

    public void clear(ChannelId serverChannelId) {
        this.flyingRequests().remove(serverChannelId);
    }

    public static final /* synthetic */ void $anonfun$logResponse$1(TrafficLogger $this, ChannelId serverChannelId$1, FullHttpResponse response$1, long receiveTimestamp$1, HttpRequest requestEvent) {
        $this.flyingRequests().remove(serverChannelId$1);
        HttpResponse responseEvent = new HttpResponse(response$1.status().code(), response$1.status().reasonPhrase(), new DefaultHttpHeaders().add(response$1.headers()).add(response$1.trailingHeaders()), ByteBufUtils.byteBuf2Bytes((ByteBuf)response$1.content()), receiveTimestamp$1);
        $this.controller.receiveResponse(requestEvent, responseEvent);
    }

    public TrafficLogger(RecorderController controller) {
        this.controller = controller;
        StrictLogging.$init$((StrictLogging)this);
        this.flyingRequests = new ConcurrentHashMap();
    }
}

