/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.utils.Shlex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);

    @Inject
    public CommandLineExecutor() {
    }

    public boolean execute(List<String> args) throws IOException {
        log.info("Calling protoc with the following command line:\n{}", (Object)Shlex.quoteShellArgs(args));
        ProcessBuilder procBuilder = new ProcessBuilder(args);
        procBuilder.environment().putAll(System.getenv());
        try {
            return this.run(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Compilation was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private boolean run(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        Process proc = procBuilder.start();
        Thread stdoutThread = this.redirectOutput(proc.getInputStream(), line -> log.info("[OUT] {}", line));
        Thread stderrThread = this.redirectOutput(proc.getErrorStream(), line -> log.warn("[ERR] {}", line));
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        stdoutThread.join();
        stderrThread.join();
        if (exitCode == 0) {
            log.info("Protoc returned exit code 0 (success) after {}ms", (Object)elapsedTimeMs);
            return true;
        }
        log.error("Protoc returned exit code {} (error) after {}ms", (Object)exitCode, (Object)elapsedTimeMs);
        return false;
    }

    private Thread redirectOutput(InputStream stream, Consumer<String> logger) {
        Thread thread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    logger.accept(line.stripTrailing());
                }
            }
            catch (IOException ex) {
                log.error("Stream error, output will be discarded", (Throwable)ex);
            }
        });
        thread.setDaemon(true);
        thread.setName("protoc output redirector thread for " + String.valueOf(stream));
        thread.start();
        return thread;
    }
}

