/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static Path normalize(Path path) {
        return path.normalize().toAbsolutePath();
    }

    public static String getFileNameWithoutExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex <= 0 ? fileName : fileName.substring(0, lastDotIndex);
    }

    public static Optional<String> getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        return lastDotIndex <= 0 ? Optional.empty() : Optional.of(fileName.substring(lastDotIndex));
    }

    public static FileSystemProvider getFileSystemProvider(String scheme) {
        return FileSystemProvider.installedProviders().stream().filter(provider -> provider.getScheme().equalsIgnoreCase(scheme)).peek(provider -> log.debug("Found {} file system provider {}", (Object)scheme, provider)).findFirst().orElseThrow(() -> new FileSystemNotFoundException("No file system provider for " + scheme + " was found"));
    }

    public static void makeExecutable(Path file) throws IOException {
        try {
            log.debug("Ensuring {} is executable", (Object)file);
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(file, new LinkOption[0]));
            perms.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(file, perms);
        }
        catch (UnsupportedOperationException ex) {
            log.debug("File system does not support setting POSIX file permissions");
        }
    }

    public static Path changeRelativePath(Path newRoot, Path existingRoot, Path existingPath) {
        Path path = newRoot;
        for (Path part : existingRoot.relativize(existingPath)) {
            path = path.resolve(part.toString());
        }
        return path;
    }
}

