/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.protoc.targets;

import io.github.ascopes.protobufmavenplugin.generation.Language;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link LanguageProtocTarget}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLanguageProtocTarget.builder()}.
 */
@Generated(from = "LanguageProtocTarget", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableLanguageProtocTarget
    implements LanguageProtocTarget {
  private final int order;
  private final @Nullable Language language;
  private final @Nullable Path outputPath;
  private final boolean lite;

  private ImmutableLanguageProtocTarget(ImmutableLanguageProtocTarget.Builder builder) {
    this.language = builder.language;
    this.outputPath = builder.outputPath;
    this.lite = builder.lite;
    this.order = builder.orderIsSet()
        ? builder.order
        : LanguageProtocTarget.super.getOrder();
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    return order;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @Override
  public @Nullable Language getLanguage() {
    return language;
  }

  /**
   * @return The value of the {@code outputPath} attribute
   */
  @Override
  public @Nullable Path getOutputPath() {
    return outputPath;
  }

  /**
   * @return The value of the {@code lite} attribute
   */
  @Override
  public boolean isLite() {
    return lite;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLanguageProtocTarget} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLanguageProtocTarget
        && equalsByValue((ImmutableLanguageProtocTarget) another);
  }

  private boolean equalsByValue(ImmutableLanguageProtocTarget another) {
    return order == another.order
        && Objects.equals(language, another.language)
        && Objects.equals(outputPath, another.outputPath)
        && lite == another.lite;
  }

  /**
   * Computes a hash code from attributes: {@code order}, {@code language}, {@code outputPath}, {@code lite}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + order;
    h += (h << 5) + Objects.hashCode(language);
    h += (h << 5) + Objects.hashCode(outputPath);
    h += (h << 5) + Boolean.hashCode(lite);
    return h;
  }

  /**
   * Prints the immutable value {@code LanguageProtocTarget} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LanguageProtocTarget{"
        + "order=" + order
        + ", language=" + language
        + ", outputPath=" + outputPath
        + ", lite=" + lite
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableLanguageProtocTarget ImmutableLanguageProtocTarget}.
   * <pre>
   * ImmutableLanguageProtocTarget.builder()
   *    .order(int) // optional {@link LanguageProtocTarget#getOrder() order}
   *    .language(io.github.ascopes.protobufmavenplugin.generation.Language | null) // nullable {@link LanguageProtocTarget#getLanguage() language}
   *    .outputPath(java.nio.file.Path | null) // nullable {@link LanguageProtocTarget#getOutputPath() outputPath}
   *    .lite(boolean) // required {@link LanguageProtocTarget#isLite() lite}
   *    .build();
   * </pre>
   * @return A new ImmutableLanguageProtocTarget builder
   */
  public static ImmutableLanguageProtocTarget.Builder builder() {
    return new ImmutableLanguageProtocTarget.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLanguageProtocTarget ImmutableLanguageProtocTarget}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LanguageProtocTarget", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_LANGUAGE = 0x1L;
    private static final long INIT_BIT_OUTPUT_PATH = 0x2L;
    private static final long INIT_BIT_LITE = 0x4L;
    private static final long OPT_BIT_ORDER = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private int order;
    private @Nullable Language language;
    private @Nullable Path outputPath;
    private boolean lite;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProtocTarget instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.protoc.targets.LanguageProtocTarget} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LanguageProtocTarget instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      long bits = 0;
      if (object instanceof ProtocTarget) {
        ProtocTarget instance = (ProtocTarget) object;
        if ((bits & 0x1L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x1L;
        }
      }
      if (object instanceof LanguageProtocTarget) {
        LanguageProtocTarget instance = (LanguageProtocTarget) object;
        Language languageValue = instance.getLanguage();
        if (languageValue != null) {
          language(languageValue);
        }
        this.lite(instance.isLite());
        Path outputPathValue = instance.getOutputPath();
        if (outputPathValue != null) {
          outputPath(outputPathValue);
        }
        if ((bits & 0x1L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link LanguageProtocTarget#getOrder() order} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link LanguageProtocTarget#getOrder() order}.</em>
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      optBits |= OPT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageProtocTarget#getLanguage() language} attribute.
     * @param language The value for language (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder language(Language language) {
      this.language = language;
      initBits &= ~INIT_BIT_LANGUAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageProtocTarget#getOutputPath() outputPath} attribute.
     * @param outputPath The value for outputPath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputPath(Path outputPath) {
      this.outputPath = outputPath;
      initBits &= ~INIT_BIT_OUTPUT_PATH;
      return this;
    }

    /**
     * Initializes the value for the {@link LanguageProtocTarget#isLite() lite} attribute.
     * @param lite The value for lite 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lite(boolean lite) {
      this.lite = lite;
      initBits &= ~INIT_BIT_LITE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLanguageProtocTarget ImmutableLanguageProtocTarget}.
     * @return An immutable instance of LanguageProtocTarget
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLanguageProtocTarget build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLanguageProtocTarget(this);
    }

    private boolean orderIsSet() {
      return (optBits & OPT_BIT_ORDER) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LANGUAGE) != 0) attributes.add("language");
      if ((initBits & INIT_BIT_OUTPUT_PATH) != 0) attributes.add("outputPath");
      if ((initBits & INIT_BIT_LITE) != 0) attributes.add("lite");
      return "Cannot build LanguageProtocTarget, some of required attributes are not set " + attributes;
    }
  }
}
