/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link MavenDependency}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMavenDependency.builder()}.
 */
@Generated(from = "MavenDependency", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMavenDependency
    implements MavenDependency {
  private final @Nullable String groupId;
  private final @Nullable String artifactId;
  private final @Nullable String version;
  private final @Nullable String type;
  private final @Nullable String classifier;
  private final @Nullable DependencyResolutionDepth dependencyResolutionDepth;
  private final Set<MavenExclusionBean> exclusions;

  private ImmutableMavenDependency(ImmutableMavenDependency.Builder builder) {
    this.groupId = builder.groupId;
    this.artifactId = builder.artifactId;
    this.version = builder.version;
    this.type = builder.type;
    this.classifier = builder.classifier;
    this.dependencyResolutionDepth = builder.dependencyResolutionDepth;
    this.exclusions = builder.exclusions == null ? Collections.<MavenExclusionBean>emptySet() : createUnmodifiableSet(builder.exclusions);
  }

  /**
   * Get the group ID.
   * @return the group ID.
   */
  @Override
  public @Nullable String getGroupId() {
    return groupId;
  }

  /**
   * Get the artifact ID.
   * @return the artifact ID.
   */
  @Override
  public @Nullable String getArtifactId() {
    return artifactId;
  }

  /**
   * Get the artifact version.
   * <p>May be {@code null} if we expect to discover the version from dependency management.
   * @return the version.
   */
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * Get the artifact type.
   * <p>May be {@code null} if the default should be used.
   * @return the artifact type.
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * Get the artifact classifier.
   * <p>May be {@code null} if no classifier is set.
   * @return the artifact classifier.
   */
  @Override
  public @Nullable String getClassifier() {
    return classifier;
  }

  /**
   * Get the preferences for the depth of dependency resolution.
   * <p>May be {@code null} if the default should be used.
   * @return the preference for the depth of dependency resolution.
   */
  @Override
  public @Nullable DependencyResolutionDepth getDependencyResolutionDepth() {
    return dependencyResolutionDepth;
  }

  /**
   * Get a set of dependency exclusions to apply when resolving dependencies.
   * @return the exclusions, which by default is empty if unspecified.
   */
  @Override
  public Set<MavenExclusionBean> getExclusions() {
    return exclusions;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMavenDependency} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMavenDependency
        && equalsByValue((ImmutableMavenDependency) another);
  }

  private boolean equalsByValue(ImmutableMavenDependency another) {
    return Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && Objects.equals(version, another.version)
        && Objects.equals(type, another.type)
        && Objects.equals(classifier, another.classifier)
        && Objects.equals(dependencyResolutionDepth, another.dependencyResolutionDepth)
        && exclusions.equals(another.exclusions);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code version}, {@code type}, {@code classifier}, {@code dependencyResolutionDepth}, {@code exclusions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(classifier);
    h += (h << 5) + Objects.hashCode(dependencyResolutionDepth);
    h += (h << 5) + exclusions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MavenDependency} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MavenDependency{"
        + "groupId=" + groupId
        + ", artifactId=" + artifactId
        + ", version=" + version
        + ", type=" + type
        + ", classifier=" + classifier
        + ", dependencyResolutionDepth=" + dependencyResolutionDepth
        + ", exclusions=" + exclusions
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableMavenDependency ImmutableMavenDependency}.
   * <pre>
   * ImmutableMavenDependency.builder()
   *    .groupId(String | null) // nullable {@link MavenDependency#getGroupId() groupId}
   *    .artifactId(String | null) // nullable {@link MavenDependency#getArtifactId() artifactId}
   *    .version(String | null) // nullable {@link MavenDependency#getVersion() version}
   *    .type(String | null) // nullable {@link MavenDependency#getType() type}
   *    .classifier(String | null) // nullable {@link MavenDependency#getClassifier() classifier}
   *    .dependencyResolutionDepth(io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth | null) // nullable {@link MavenDependency#getDependencyResolutionDepth() dependencyResolutionDepth}
   *    .addExclusions|addAllExclusions(MavenExclusionBean) // {@link MavenDependency#getExclusions() exclusions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMavenDependency builder
   */
  public static ImmutableMavenDependency.Builder builder() {
    return new ImmutableMavenDependency.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMavenDependency ImmutableMavenDependency}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MavenDependency", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String groupId;
    private @Nullable String artifactId;
    private @Nullable String version;
    private @Nullable String type;
    private @Nullable String classifier;
    private @Nullable DependencyResolutionDepth dependencyResolutionDepth;
    private @Nullable List<MavenExclusionBean> exclusions = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MavenDependencyBean} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenDependencyBean instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.groupIdIsSet()) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          groupId(groupIdValue);
        }
      }
      if (instance.artifactIdIsSet()) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          artifactId(artifactIdValue);
        }
      }
      @Nullable String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        classifier(classifierValue);
      }
      @Nullable DependencyResolutionDepth dependencyResolutionDepthValue = instance.getDependencyResolutionDepth();
      if (dependencyResolutionDepthValue != null) {
        dependencyResolutionDepth(dependencyResolutionDepthValue);
      }
      addAllExclusions(instance.getExclusions());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenArtifact instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.dependencies.MavenDependency} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenDependency instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      if (object instanceof MavenDependencyBean) {
        from((MavenDependencyBean) object);
        return;
      }
      long bits = 0;
      if (object instanceof MavenArtifact) {
        MavenArtifact instance = (MavenArtifact) object;
        if ((bits & 0x8L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof MavenDependency) {
        MavenDependency instance = (MavenDependency) object;
        @Nullable DependencyResolutionDepth dependencyResolutionDepthValue = instance.getDependencyResolutionDepth();
        if (dependencyResolutionDepthValue != null) {
          dependencyResolutionDepth(dependencyResolutionDepthValue);
        }
        if ((bits & 0x1L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x8L;
        }
        addAllExclusions(instance.getExclusions());
        if ((bits & 0x10L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MavenDependency#getGroupId() groupId} attribute.
     * @param groupId The value for groupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = groupId;
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenDependency#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder artifactId(String artifactId) {
      this.artifactId = artifactId;
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenDependency#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenDependency#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenDependency#getClassifier() classifier} attribute.
     * @param classifier The value for classifier (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classifier(@Nullable String classifier) {
      this.classifier = classifier;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenDependency#getDependencyResolutionDepth() dependencyResolutionDepth} attribute.
     * @param dependencyResolutionDepth The value for dependencyResolutionDepth (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dependencyResolutionDepth(@Nullable DependencyResolutionDepth dependencyResolutionDepth) {
      this.dependencyResolutionDepth = dependencyResolutionDepth;
      return this;
    }

    /**
     * Adds one element to {@link MavenDependency#getExclusions() exclusions} set.
     * @param element A exclusions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExclusions(@Nullable MavenExclusionBean element) {
      if (this.exclusions == null) {
        this.exclusions = new ArrayList<MavenExclusionBean>();
      }
      this.exclusions.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MavenDependency#getExclusions() exclusions} set.
     * @param elements An array of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExclusions(@Nullable MavenExclusionBean... elements) {
      if (this.exclusions == null) {
        this.exclusions = new ArrayList<MavenExclusionBean>();
      }
      for (MavenExclusionBean element : elements) {
        this.exclusions.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MavenDependency#getExclusions() exclusions} set.
     * @param elements An iterable of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exclusions(Iterable<? extends @Nullable MavenExclusionBean> elements) {
      this.exclusions = new ArrayList<MavenExclusionBean>();
      return addAllExclusions(elements);
    }

    /**
     * Adds elements to {@link MavenDependency#getExclusions() exclusions} set.
     * @param elements An iterable of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExclusions(Iterable<? extends @Nullable MavenExclusionBean> elements) {
      Objects.requireNonNull(elements, "exclusions element");
      if (this.exclusions == null) {
        this.exclusions = new ArrayList<MavenExclusionBean>();
      }
      for (MavenExclusionBean element : elements) {
        this.exclusions.add(element);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMavenDependency ImmutableMavenDependency}.
     * @return An immutable instance of MavenDependency
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMavenDependency build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMavenDependency(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      return "Cannot build MavenDependency, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
