/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link GenerationRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenerationRequest.builder()}.
 */
@Generated(from = "GenerationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableGenerationRequest
    implements GenerationRequest {
  private final List<String> arguments;
  private final @Nullable Collection<? extends MavenProtocPlugin> binaryMavenPlugins;
  private final @Nullable Collection<? extends PathProtocPlugin> binaryPathPlugins;
  private final @Nullable Collection<? extends UriProtocPlugin> binaryUrlPlugins;
  private final @Nullable DependencyResolutionDepth dependencyResolutionDepth;
  private final Set<String> dependencyScopes;
  private final @Nullable Collection<Language> enabledLanguages;
  private final List<String> excludes;
  private final Map<String, String> environmentVariables;
  private final @Nullable Collection<? extends MavenArtifact> importDependencies;
  private final @Nullable Collection<Path> importPaths;
  private final List<String> includes;
  private final @Nullable Collection<? extends MavenProtocPlugin> jvmMavenPlugins;
  private final @Nullable Path outputDirectory;
  private final @Nullable Path outputDescriptorFile;
  private final boolean outputDescriptorAttached;
  private final @Nullable String outputDescriptorAttachmentType;
  private final @Nullable String outputDescriptorAttachmentClassifier;
  private final @Nullable Digest protocDigest;
  private final @Nullable String protocVersion;
  private final @Nullable Path sanctionedExecutablePath;
  private final @Nullable Collection<? extends MavenArtifact> sourceDependencies;
  private final @Nullable Collection<? extends MavenArtifact> sourceDescriptorDependencies;
  private final @Nullable Collection<Path> sourceDescriptorPaths;
  private final @Nullable Collection<Path> sourceDirectories;
  private final @Nullable SourceRootRegistrar sourceRootRegistrar;
  private final @Nullable OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar;
  private final boolean cleanOutputDirectories;
  private final boolean embedSourcesInClassOutputs;
  private final boolean failOnInvalidDependencies;
  private final boolean failOnMissingSources;
  private final boolean failOnMissingTargets;
  private final boolean fatalWarnings;
  private final boolean ignoreProjectDependencies;
  private final boolean incrementalCompilationEnabled;
  private final boolean liteEnabled;
  private final boolean outputDescriptorIncludeImports;
  private final boolean outputDescriptorIncludeSourceInfo;
  private final boolean outputDescriptorRetainOptions;
  private final boolean registerAsCompilationRoot;

  private ImmutableGenerationRequest(ImmutableGenerationRequest.Builder builder) {
    this.arguments = builder.arguments == null ? Collections.<String>emptyList() : createUnmodifiableList(true, builder.arguments);
    this.binaryMavenPlugins = builder.binaryMavenPlugins;
    this.binaryPathPlugins = builder.binaryPathPlugins;
    this.binaryUrlPlugins = builder.binaryUrlPlugins;
    this.dependencyResolutionDepth = builder.dependencyResolutionDepth;
    this.dependencyScopes = builder.dependencyScopes == null ? Collections.<String>emptySet() : createUnmodifiableSet(builder.dependencyScopes);
    this.enabledLanguages = builder.enabledLanguages;
    this.excludes = builder.excludes == null ? Collections.<String>emptyList() : createUnmodifiableList(true, builder.excludes);
    this.environmentVariables = builder.environmentVariables == null ? Collections.<String, String>emptyMap() : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.importDependencies = builder.importDependencies;
    this.importPaths = builder.importPaths;
    this.includes = builder.includes == null ? Collections.<String>emptyList() : createUnmodifiableList(true, builder.includes);
    this.jvmMavenPlugins = builder.jvmMavenPlugins;
    this.outputDirectory = builder.outputDirectory;
    this.outputDescriptorFile = builder.outputDescriptorFile;
    this.outputDescriptorAttached = builder.outputDescriptorAttached;
    this.outputDescriptorAttachmentType = builder.outputDescriptorAttachmentType;
    this.outputDescriptorAttachmentClassifier = builder.outputDescriptorAttachmentClassifier;
    this.protocDigest = builder.protocDigest;
    this.protocVersion = builder.protocVersion;
    this.sanctionedExecutablePath = builder.sanctionedExecutablePath;
    this.sourceDependencies = builder.sourceDependencies;
    this.sourceDescriptorDependencies = builder.sourceDescriptorDependencies;
    this.sourceDescriptorPaths = builder.sourceDescriptorPaths;
    this.sourceDirectories = builder.sourceDirectories;
    this.sourceRootRegistrar = builder.sourceRootRegistrar;
    this.outputDescriptorAttachmentRegistrar = builder.outputDescriptorAttachmentRegistrar;
    this.cleanOutputDirectories = builder.cleanOutputDirectories;
    this.embedSourcesInClassOutputs = builder.embedSourcesInClassOutputs;
    this.failOnInvalidDependencies = builder.failOnInvalidDependencies;
    this.failOnMissingSources = builder.failOnMissingSources;
    this.failOnMissingTargets = builder.failOnMissingTargets;
    this.fatalWarnings = builder.fatalWarnings;
    this.ignoreProjectDependencies = builder.ignoreProjectDependencies;
    this.incrementalCompilationEnabled = builder.incrementalCompilationEnabled;
    this.liteEnabled = builder.liteEnabled;
    this.outputDescriptorIncludeImports = builder.outputDescriptorIncludeImports;
    this.outputDescriptorIncludeSourceInfo = builder.outputDescriptorIncludeSourceInfo;
    this.outputDescriptorRetainOptions = builder.outputDescriptorRetainOptions;
    this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
  }

  /**
   * Additional arguments to pass to {@code protoc}.
   * @return the arguments list.
   */
  @Override
  public List<String> getArguments() {
    return arguments;
  }

  /**
   * Binary {@code protoc} plugins that should be resolved from Maven
   * repositories.
   * @return the collection of plugins.
   */
  @Override
  public @Nullable Collection<? extends MavenProtocPlugin> getBinaryMavenPlugins() {
    return binaryMavenPlugins;
  }

  /**
   * Binary {@code protoc} plugins that should be resolved from the system
   * {@code $PATH}.
   * @return the collection of plugins.
   */
  @Override
  public @Nullable Collection<? extends PathProtocPlugin> getBinaryPathPlugins() {
    return binaryPathPlugins;
  }

  /**
   * Binary {@code protoc} plugins that should be resolved from URLs.
   * @return the collection of plugins.
   */
  @Override
  public @Nullable Collection<? extends UriProtocPlugin> getBinaryUrlPlugins() {
    return binaryUrlPlugins;
  }

  /**
   * The preference for how to resolve transitive dependencies by default.
   * @return the dependency resolution depth preference.
   */
  @Override
  public @Nullable DependencyResolutionDepth getDependencyResolutionDepth() {
    return dependencyResolutionDepth;
  }

  /**
   * The dependency scopes to allow when searching the Maven project
   * dependency list for {@code *.proto} files.
   * @return the set of scopes.
   */
  @Override
  public Set<String> getDependencyScopes() {
    return dependencyScopes;
  }

  /**
   * The collection of supported langagues to enable in {@code protoc}.
   * @return the languages.
   */
  @Override
  public @Nullable Collection<Language> getEnabledLanguages() {
    return enabledLanguages;
  }

  /**
   * The collection of {@code *.proto} path patterns to exclude from being
   * passed to {@code protoc}.
   * @return the collection of glob patterns.
   */
  @Override
  public List<String> getExcludes() {
    return excludes;
  }

  /**
   * Additional environment variables to set when calling {@code protoc}.
   */
  @Override
  public Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * Additional user-defined Maven dependencies to include in the {@code protoc}
   * import path.
   * @return the collection of dependencies.
   */
  @Override
  public @Nullable Collection<? extends MavenArtifact> getImportDependencies() {
    return importDependencies;
  }

  /**
   * Additional user-defined paths relative to the project root to include in the
   * {@code protoc} import path.
   * @return the collection of paths.
   */
  @Override
  public @Nullable Collection<Path> getImportPaths() {
    return importPaths;
  }

  /**
   * The collection of {@code *.proto} path patterns to include to be passed to
   * {@code protoc}.
   * @return the collection of glob patterns.
   */
  @Override
  public List<String> getIncludes() {
    return includes;
  }

  /**
   * Java executable projects that satisfy the {@code protoc} plugin interface
   * to wrap in bootstrapping scripts and pass to {@code protoc}.
   * @return the collection of plugins.
   */
  @Override
  public @Nullable Collection<? extends MavenProtocPlugin> getJvmMavenPlugins() {
    return jvmMavenPlugins;
  }

  /**
   * The path to write all output files to.
   * @return the output path.
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * The output {@code protobin} descriptor file to create, or {@code null} if
   * no descriptor file should be created.
   * @return the path to the descriptor file to output, or {@code null}.
   */
  @Override
  public @Nullable Path getOutputDescriptorFile() {
    return outputDescriptorFile;
  }

  /**
   * Whether to attach output {@code protobin} descriptor file to Maven project.
   * @return flag indicating if descriptor file should be attached.
   */
  @Override
  public boolean isOutputDescriptorAttached() {
    return outputDescriptorAttached;
  }

  /**
   * The Maven artifact type to use when attaching the {@code protobin} descriptor
   * file to the Maven project.
   * @return the artifact type, or {@code null}.
   */
  @Override
  public @Nullable String getOutputDescriptorAttachmentType() {
    return outputDescriptorAttachmentType;
  }

  /**
   * The Maven artifact classifier to use when attaching the {@code protobin}
   * descriptor file to the Maven project.
   * @return the artifact classifier, or {@code null}.
   */
  @Override
  public @Nullable String getOutputDescriptorAttachmentClassifier() {
    return outputDescriptorAttachmentClassifier;
  }

  /**
   * The digest of the {@code protoc} binary to verify, or {@code null} if
   * no verification should take place.
   * <p>This does not affect any verification performed by Aether.
   * @return the digest.
   * @since 3.5.0
   */
  @Override
  public @Nullable Digest getProtocDigest() {
    return protocDigest;
  }

  /**
   * The version of {@code protoc} to use.
   * <p>This will be one of:
   * <ul>
   *   <li>A Maven version string (such as {@code 4.29.3}), to indicate to
   *       pull from the Maven repositories;
   *   <li>The literal string {@code PATH}, to indicate to invoke the
   *       {@code protoc} binary on the system {@code $PATH};
   *   <li>A URL to a binary to execute.
   * </ul>
   * @return the version indicator.
   */
  @Override
  public @Nullable String getProtocVersion() {
    return protocVersion;
  }

  /**
   * Sanctioned path to place executables in.
   * <p>Used for corporate environments with overly locked-down policies on where native
   * executables can be placed.
   * @return the sanctioned path, or {@code null} if no movement of resources is desired.
   */
  @Override
  public @Nullable Path getSanctionedExecutablePath() {
    return sanctionedExecutablePath;
  }

  /**
   * Additional user-defined Maven dependencies to include in the {@code protoc}
   * import path, and to compile.
   * @return the collection of dependencies.
   */
  @Override
  public @Nullable Collection<? extends MavenArtifact> getSourceDependencies() {
    return sourceDependencies;
  }

  /**
   * Additional user-defined Maven dependencies pointing at protobuf descriptor files to compile.
   * @return the collection of dependencies pointing to protobuf descriptor files.
   * @since 3.1.0
   */
  @Override
  public @Nullable Collection<? extends MavenArtifact> getSourceDescriptorDependencies() {
    return sourceDescriptorDependencies;
  }

  /**
   * Paths relative to the project root that are protobuf descriptor files to compile from.
   * @return the source descriptor file paths.
   */
  @Override
  public @Nullable Collection<Path> getSourceDescriptorPaths() {
    return sourceDescriptorPaths;
  }

  /**
   * Paths relative to the project root that contain {@code *.proto} sources to
   * compile.
   * @return the source directory paths.
   */
  @Override
  public @Nullable Collection<Path> getSourceDirectories() {
    return sourceDirectories;
  }

  /**
   * The registrar strategy to use to notify Maven of generated sources.
   * @return the registrar strategy.
   */
  @Override
  public @Nullable SourceRootRegistrar getSourceRootRegistrar() {
    return sourceRootRegistrar;
  }

  /**
   * The registrar strategy to use to notify Maven of attached artifacts.
   * @return the registrar strategy.
   */
  @Override
  public @Nullable OutputDescriptorAttachmentRegistrar getOutputDescriptorAttachmentRegistrar() {
    return outputDescriptorAttachmentRegistrar;
  }

  /**
   * Whether to delete all output directories at the start of the build.
   * <p>Ignored if using incremental compilation.
   * @return the boolean preference.
   */
  @Override
  public boolean isCleanOutputDirectories() {
    return cleanOutputDirectories;
  }

  /**
   * Whether to include input {@code proto} sources in the output class
   * directory.
   * @return the boolean preference.
   */
  @Override
  public boolean isEmbedSourcesInClassOutputs() {
    return embedSourcesInClassOutputs;
  }

  /**
   * Whether to treat invalid dependencies as a build error.
   * @return the boolean preference.
   */
  @Override
  public boolean isFailOnInvalidDependencies() {
    return failOnInvalidDependencies;
  }

  /**
   * Whether to treat non-existent source roots as a build error.
   * @return the boolean preference.
   */
  @Override
  public boolean isFailOnMissingSources() {
    return failOnMissingSources;
  }

  /**
   * Whether to treat builds with no enabled languages, plugins, or descriptor
   * file outputs as a build error.
   * @return the boolean preference.
   */
  @Override
  public boolean isFailOnMissingTargets() {
    return failOnMissingTargets;
  }

  /**
   * Whether to treat {@code protoc} build warnings as errors.
   * @return the boolean preference.
   */
  @Override
  public boolean isFatalWarnings() {
    return fatalWarnings;
  }

  /**
   * Whether to skip discovering {@code *.proto} files to import from the Maven
   * project {@code <dependencies/>} block.
   * @return the boolean preference.
   */
  @Override
  public boolean isIgnoreProjectDependencies() {
    return ignoreProjectDependencies;
  }

  /**
   * Whether to enable incrementally compiling sources.
   * @return the boolean preference.
   */
  @Override
  public boolean isIncrementalCompilationEnabled() {
    return incrementalCompilationEnabled;
  }

  /**
   * Whether to request the generation of "lite" sources.
   * @return the boolean preference.
   */
  @Override
  public boolean isLiteEnabled() {
    return liteEnabled;
  }

  /**
   * Whether to include imports in the output {@code protobin} descriptor.
   * @return the boolean preference.
   */
  @Override
  public boolean isOutputDescriptorIncludeImports() {
    return outputDescriptorIncludeImports;
  }

  /**
   * Whether to include source information in the output {@code protobin}
   * descriptor.
   * @return the boolean preference.
   */
  @Override
  public boolean isOutputDescriptorIncludeSourceInfo() {
    return outputDescriptorIncludeSourceInfo;
  }

  /**
   * Whether to retain build option metadata in the output {@code protobin}
   * descriptor.
   * @return the boolean preference.
   */
  @Override
  public boolean isOutputDescriptorRetainOptions() {
    return outputDescriptorRetainOptions;
  }

  /**
   * Whether to mark generated sources as candidates for compilation with the
   * {@code maven-compiler-plugin} and similar plugins.
   * @return the boolean preference.
   */
  @Override
  public boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenerationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenerationRequest
        && equalsByValue((ImmutableGenerationRequest) another);
  }

  private boolean equalsByValue(ImmutableGenerationRequest another) {
    return arguments.equals(another.arguments)
        && Objects.equals(binaryMavenPlugins, another.binaryMavenPlugins)
        && Objects.equals(binaryPathPlugins, another.binaryPathPlugins)
        && Objects.equals(binaryUrlPlugins, another.binaryUrlPlugins)
        && Objects.equals(dependencyResolutionDepth, another.dependencyResolutionDepth)
        && dependencyScopes.equals(another.dependencyScopes)
        && Objects.equals(enabledLanguages, another.enabledLanguages)
        && excludes.equals(another.excludes)
        && environmentVariables.equals(another.environmentVariables)
        && Objects.equals(importDependencies, another.importDependencies)
        && Objects.equals(importPaths, another.importPaths)
        && includes.equals(another.includes)
        && Objects.equals(jvmMavenPlugins, another.jvmMavenPlugins)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(outputDescriptorFile, another.outputDescriptorFile)
        && outputDescriptorAttached == another.outputDescriptorAttached
        && Objects.equals(outputDescriptorAttachmentType, another.outputDescriptorAttachmentType)
        && Objects.equals(outputDescriptorAttachmentClassifier, another.outputDescriptorAttachmentClassifier)
        && Objects.equals(protocDigest, another.protocDigest)
        && Objects.equals(protocVersion, another.protocVersion)
        && Objects.equals(sanctionedExecutablePath, another.sanctionedExecutablePath)
        && Objects.equals(sourceDependencies, another.sourceDependencies)
        && Objects.equals(sourceDescriptorDependencies, another.sourceDescriptorDependencies)
        && Objects.equals(sourceDescriptorPaths, another.sourceDescriptorPaths)
        && Objects.equals(sourceDirectories, another.sourceDirectories)
        && Objects.equals(sourceRootRegistrar, another.sourceRootRegistrar)
        && Objects.equals(outputDescriptorAttachmentRegistrar, another.outputDescriptorAttachmentRegistrar)
        && cleanOutputDirectories == another.cleanOutputDirectories
        && embedSourcesInClassOutputs == another.embedSourcesInClassOutputs
        && failOnInvalidDependencies == another.failOnInvalidDependencies
        && failOnMissingSources == another.failOnMissingSources
        && failOnMissingTargets == another.failOnMissingTargets
        && fatalWarnings == another.fatalWarnings
        && ignoreProjectDependencies == another.ignoreProjectDependencies
        && incrementalCompilationEnabled == another.incrementalCompilationEnabled
        && liteEnabled == another.liteEnabled
        && outputDescriptorIncludeImports == another.outputDescriptorIncludeImports
        && outputDescriptorIncludeSourceInfo == another.outputDescriptorIncludeSourceInfo
        && outputDescriptorRetainOptions == another.outputDescriptorRetainOptions
        && registerAsCompilationRoot == another.registerAsCompilationRoot;
  }

  /**
   * Computes a hash code from attributes: {@code arguments}, {@code binaryMavenPlugins}, {@code binaryPathPlugins}, {@code binaryUrlPlugins}, {@code dependencyResolutionDepth}, {@code dependencyScopes}, {@code enabledLanguages}, {@code excludes}, {@code environmentVariables}, {@code importDependencies}, {@code importPaths}, {@code includes}, {@code jvmMavenPlugins}, {@code outputDirectory}, {@code outputDescriptorFile}, {@code outputDescriptorAttached}, {@code outputDescriptorAttachmentType}, {@code outputDescriptorAttachmentClassifier}, {@code protocDigest}, {@code protocVersion}, {@code sanctionedExecutablePath}, {@code sourceDependencies}, {@code sourceDescriptorDependencies}, {@code sourceDescriptorPaths}, {@code sourceDirectories}, {@code sourceRootRegistrar}, {@code outputDescriptorAttachmentRegistrar}, {@code cleanOutputDirectories}, {@code embedSourcesInClassOutputs}, {@code failOnInvalidDependencies}, {@code failOnMissingSources}, {@code failOnMissingTargets}, {@code fatalWarnings}, {@code ignoreProjectDependencies}, {@code incrementalCompilationEnabled}, {@code liteEnabled}, {@code outputDescriptorIncludeImports}, {@code outputDescriptorIncludeSourceInfo}, {@code outputDescriptorRetainOptions}, {@code registerAsCompilationRoot}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + arguments.hashCode();
    h += (h << 5) + Objects.hashCode(binaryMavenPlugins);
    h += (h << 5) + Objects.hashCode(binaryPathPlugins);
    h += (h << 5) + Objects.hashCode(binaryUrlPlugins);
    h += (h << 5) + Objects.hashCode(dependencyResolutionDepth);
    h += (h << 5) + dependencyScopes.hashCode();
    h += (h << 5) + Objects.hashCode(enabledLanguages);
    h += (h << 5) + excludes.hashCode();
    h += (h << 5) + environmentVariables.hashCode();
    h += (h << 5) + Objects.hashCode(importDependencies);
    h += (h << 5) + Objects.hashCode(importPaths);
    h += (h << 5) + includes.hashCode();
    h += (h << 5) + Objects.hashCode(jvmMavenPlugins);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(outputDescriptorFile);
    h += (h << 5) + Boolean.hashCode(outputDescriptorAttached);
    h += (h << 5) + Objects.hashCode(outputDescriptorAttachmentType);
    h += (h << 5) + Objects.hashCode(outputDescriptorAttachmentClassifier);
    h += (h << 5) + Objects.hashCode(protocDigest);
    h += (h << 5) + Objects.hashCode(protocVersion);
    h += (h << 5) + Objects.hashCode(sanctionedExecutablePath);
    h += (h << 5) + Objects.hashCode(sourceDependencies);
    h += (h << 5) + Objects.hashCode(sourceDescriptorDependencies);
    h += (h << 5) + Objects.hashCode(sourceDescriptorPaths);
    h += (h << 5) + Objects.hashCode(sourceDirectories);
    h += (h << 5) + Objects.hashCode(sourceRootRegistrar);
    h += (h << 5) + Objects.hashCode(outputDescriptorAttachmentRegistrar);
    h += (h << 5) + Boolean.hashCode(cleanOutputDirectories);
    h += (h << 5) + Boolean.hashCode(embedSourcesInClassOutputs);
    h += (h << 5) + Boolean.hashCode(failOnInvalidDependencies);
    h += (h << 5) + Boolean.hashCode(failOnMissingSources);
    h += (h << 5) + Boolean.hashCode(failOnMissingTargets);
    h += (h << 5) + Boolean.hashCode(fatalWarnings);
    h += (h << 5) + Boolean.hashCode(ignoreProjectDependencies);
    h += (h << 5) + Boolean.hashCode(incrementalCompilationEnabled);
    h += (h << 5) + Boolean.hashCode(liteEnabled);
    h += (h << 5) + Boolean.hashCode(outputDescriptorIncludeImports);
    h += (h << 5) + Boolean.hashCode(outputDescriptorIncludeSourceInfo);
    h += (h << 5) + Boolean.hashCode(outputDescriptorRetainOptions);
    h += (h << 5) + Boolean.hashCode(registerAsCompilationRoot);
    return h;
  }

  /**
   * Prints the immutable value {@code GenerationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GenerationRequest{"
        + "arguments=" + arguments
        + ", binaryMavenPlugins=" + binaryMavenPlugins
        + ", binaryPathPlugins=" + binaryPathPlugins
        + ", binaryUrlPlugins=" + binaryUrlPlugins
        + ", dependencyResolutionDepth=" + dependencyResolutionDepth
        + ", dependencyScopes=" + dependencyScopes
        + ", enabledLanguages=" + enabledLanguages
        + ", excludes=" + excludes
        + ", environmentVariables=" + environmentVariables
        + ", importDependencies=" + importDependencies
        + ", importPaths=" + importPaths
        + ", includes=" + includes
        + ", jvmMavenPlugins=" + jvmMavenPlugins
        + ", outputDirectory=" + outputDirectory
        + ", outputDescriptorFile=" + outputDescriptorFile
        + ", outputDescriptorAttached=" + outputDescriptorAttached
        + ", outputDescriptorAttachmentType=" + outputDescriptorAttachmentType
        + ", outputDescriptorAttachmentClassifier=" + outputDescriptorAttachmentClassifier
        + ", protocDigest=" + protocDigest
        + ", protocVersion=" + protocVersion
        + ", sanctionedExecutablePath=" + sanctionedExecutablePath
        + ", sourceDependencies=" + sourceDependencies
        + ", sourceDescriptorDependencies=" + sourceDescriptorDependencies
        + ", sourceDescriptorPaths=" + sourceDescriptorPaths
        + ", sourceDirectories=" + sourceDirectories
        + ", sourceRootRegistrar=" + sourceRootRegistrar
        + ", outputDescriptorAttachmentRegistrar=" + outputDescriptorAttachmentRegistrar
        + ", cleanOutputDirectories=" + cleanOutputDirectories
        + ", embedSourcesInClassOutputs=" + embedSourcesInClassOutputs
        + ", failOnInvalidDependencies=" + failOnInvalidDependencies
        + ", failOnMissingSources=" + failOnMissingSources
        + ", failOnMissingTargets=" + failOnMissingTargets
        + ", fatalWarnings=" + fatalWarnings
        + ", ignoreProjectDependencies=" + ignoreProjectDependencies
        + ", incrementalCompilationEnabled=" + incrementalCompilationEnabled
        + ", liteEnabled=" + liteEnabled
        + ", outputDescriptorIncludeImports=" + outputDescriptorIncludeImports
        + ", outputDescriptorIncludeSourceInfo=" + outputDescriptorIncludeSourceInfo
        + ", outputDescriptorRetainOptions=" + outputDescriptorRetainOptions
        + ", registerAsCompilationRoot=" + registerAsCompilationRoot
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableGenerationRequest ImmutableGenerationRequest}.
   * <pre>
   * ImmutableGenerationRequest.builder()
   *    .addArguments|addAllArguments(String) // {@link GenerationRequest#getArguments() arguments} elements
   *    .binaryMavenPlugins(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin&gt; | null) // nullable {@link GenerationRequest#getBinaryMavenPlugins() binaryMavenPlugins}
   *    .binaryPathPlugins(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin&gt; | null) // nullable {@link GenerationRequest#getBinaryPathPlugins() binaryPathPlugins}
   *    .binaryUrlPlugins(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin&gt; | null) // nullable {@link GenerationRequest#getBinaryUrlPlugins() binaryUrlPlugins}
   *    .dependencyResolutionDepth(io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth | null) // nullable {@link GenerationRequest#getDependencyResolutionDepth() dependencyResolutionDepth}
   *    .addDependencyScopes|addAllDependencyScopes(String) // {@link GenerationRequest#getDependencyScopes() dependencyScopes} elements
   *    .enabledLanguages(Collection&lt;io.github.ascopes.protobufmavenplugin.generation.Language&gt; | null) // nullable {@link GenerationRequest#getEnabledLanguages() enabledLanguages}
   *    .addExcludes|addAllExcludes(String) // {@link GenerationRequest#getExcludes() excludes} elements
   *    .putEnvironmentVariables|putAllEnvironmentVariables(String =&gt; String) // {@link GenerationRequest#getEnvironmentVariables() environmentVariables} mappings
   *    .importDependencies(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact&gt; | null) // nullable {@link GenerationRequest#getImportDependencies() importDependencies}
   *    .importPaths(Collection&lt;java.nio.file.Path&gt; | null) // nullable {@link GenerationRequest#getImportPaths() importPaths}
   *    .addIncludes|addAllIncludes(String) // {@link GenerationRequest#getIncludes() includes} elements
   *    .jvmMavenPlugins(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin&gt; | null) // nullable {@link GenerationRequest#getJvmMavenPlugins() jvmMavenPlugins}
   *    .outputDirectory(java.nio.file.Path | null) // nullable {@link GenerationRequest#getOutputDirectory() outputDirectory}
   *    .outputDescriptorFile(java.nio.file.Path | null) // nullable {@link GenerationRequest#getOutputDescriptorFile() outputDescriptorFile}
   *    .outputDescriptorAttached(boolean) // required {@link GenerationRequest#isOutputDescriptorAttached() outputDescriptorAttached}
   *    .outputDescriptorAttachmentType(String | null) // nullable {@link GenerationRequest#getOutputDescriptorAttachmentType() outputDescriptorAttachmentType}
   *    .outputDescriptorAttachmentClassifier(String | null) // nullable {@link GenerationRequest#getOutputDescriptorAttachmentClassifier() outputDescriptorAttachmentClassifier}
   *    .protocDigest(io.github.ascopes.protobufmavenplugin.digests.Digest | null) // nullable {@link GenerationRequest#getProtocDigest() protocDigest}
   *    .protocVersion(String | null) // nullable {@link GenerationRequest#getProtocVersion() protocVersion}
   *    .sanctionedExecutablePath(java.nio.file.Path | null) // nullable {@link GenerationRequest#getSanctionedExecutablePath() sanctionedExecutablePath}
   *    .sourceDependencies(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact&gt; | null) // nullable {@link GenerationRequest#getSourceDependencies() sourceDependencies}
   *    .sourceDescriptorDependencies(Collection&lt;? extends io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact&gt; | null) // nullable {@link GenerationRequest#getSourceDescriptorDependencies() sourceDescriptorDependencies}
   *    .sourceDescriptorPaths(Collection&lt;java.nio.file.Path&gt; | null) // nullable {@link GenerationRequest#getSourceDescriptorPaths() sourceDescriptorPaths}
   *    .sourceDirectories(Collection&lt;java.nio.file.Path&gt; | null) // nullable {@link GenerationRequest#getSourceDirectories() sourceDirectories}
   *    .sourceRootRegistrar(io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar | null) // nullable {@link GenerationRequest#getSourceRootRegistrar() sourceRootRegistrar}
   *    .outputDescriptorAttachmentRegistrar(io.github.ascopes.protobufmavenplugin.generation.OutputDescriptorAttachmentRegistrar | null) // nullable {@link GenerationRequest#getOutputDescriptorAttachmentRegistrar() outputDescriptorAttachmentRegistrar}
   *    .cleanOutputDirectories(boolean) // required {@link GenerationRequest#isCleanOutputDirectories() cleanOutputDirectories}
   *    .embedSourcesInClassOutputs(boolean) // required {@link GenerationRequest#isEmbedSourcesInClassOutputs() embedSourcesInClassOutputs}
   *    .failOnInvalidDependencies(boolean) // required {@link GenerationRequest#isFailOnInvalidDependencies() failOnInvalidDependencies}
   *    .failOnMissingSources(boolean) // required {@link GenerationRequest#isFailOnMissingSources() failOnMissingSources}
   *    .failOnMissingTargets(boolean) // required {@link GenerationRequest#isFailOnMissingTargets() failOnMissingTargets}
   *    .fatalWarnings(boolean) // required {@link GenerationRequest#isFatalWarnings() fatalWarnings}
   *    .ignoreProjectDependencies(boolean) // required {@link GenerationRequest#isIgnoreProjectDependencies() ignoreProjectDependencies}
   *    .incrementalCompilationEnabled(boolean) // required {@link GenerationRequest#isIncrementalCompilationEnabled() incrementalCompilationEnabled}
   *    .liteEnabled(boolean) // required {@link GenerationRequest#isLiteEnabled() liteEnabled}
   *    .outputDescriptorIncludeImports(boolean) // required {@link GenerationRequest#isOutputDescriptorIncludeImports() outputDescriptorIncludeImports}
   *    .outputDescriptorIncludeSourceInfo(boolean) // required {@link GenerationRequest#isOutputDescriptorIncludeSourceInfo() outputDescriptorIncludeSourceInfo}
   *    .outputDescriptorRetainOptions(boolean) // required {@link GenerationRequest#isOutputDescriptorRetainOptions() outputDescriptorRetainOptions}
   *    .registerAsCompilationRoot(boolean) // required {@link GenerationRequest#isRegisterAsCompilationRoot() registerAsCompilationRoot}
   *    .build();
   * </pre>
   * @return A new ImmutableGenerationRequest builder
   */
  public static ImmutableGenerationRequest.Builder builder() {
    return new ImmutableGenerationRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGenerationRequest ImmutableGenerationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenerationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_BINARY_MAVEN_PLUGINS = 0x1L;
    private static final long INIT_BIT_BINARY_PATH_PLUGINS = 0x2L;
    private static final long INIT_BIT_BINARY_URL_PLUGINS = 0x4L;
    private static final long INIT_BIT_DEPENDENCY_RESOLUTION_DEPTH = 0x8L;
    private static final long INIT_BIT_ENABLED_LANGUAGES = 0x10L;
    private static final long INIT_BIT_IMPORT_DEPENDENCIES = 0x20L;
    private static final long INIT_BIT_IMPORT_PATHS = 0x40L;
    private static final long INIT_BIT_JVM_MAVEN_PLUGINS = 0x80L;
    private static final long INIT_BIT_OUTPUT_DIRECTORY = 0x100L;
    private static final long INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHED = 0x200L;
    private static final long INIT_BIT_PROTOC_VERSION = 0x400L;
    private static final long INIT_BIT_SOURCE_DEPENDENCIES = 0x800L;
    private static final long INIT_BIT_SOURCE_DESCRIPTOR_DEPENDENCIES = 0x1000L;
    private static final long INIT_BIT_SOURCE_DESCRIPTOR_PATHS = 0x2000L;
    private static final long INIT_BIT_SOURCE_DIRECTORIES = 0x4000L;
    private static final long INIT_BIT_SOURCE_ROOT_REGISTRAR = 0x8000L;
    private static final long INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHMENT_REGISTRAR = 0x10000L;
    private static final long INIT_BIT_CLEAN_OUTPUT_DIRECTORIES = 0x20000L;
    private static final long INIT_BIT_EMBED_SOURCES_IN_CLASS_OUTPUTS = 0x40000L;
    private static final long INIT_BIT_FAIL_ON_INVALID_DEPENDENCIES = 0x80000L;
    private static final long INIT_BIT_FAIL_ON_MISSING_SOURCES = 0x100000L;
    private static final long INIT_BIT_FAIL_ON_MISSING_TARGETS = 0x200000L;
    private static final long INIT_BIT_FATAL_WARNINGS = 0x400000L;
    private static final long INIT_BIT_IGNORE_PROJECT_DEPENDENCIES = 0x800000L;
    private static final long INIT_BIT_INCREMENTAL_COMPILATION_ENABLED = 0x1000000L;
    private static final long INIT_BIT_LITE_ENABLED = 0x2000000L;
    private static final long INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_IMPORTS = 0x4000000L;
    private static final long INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_SOURCE_INFO = 0x8000000L;
    private static final long INIT_BIT_OUTPUT_DESCRIPTOR_RETAIN_OPTIONS = 0x10000000L;
    private static final long INIT_BIT_REGISTER_AS_COMPILATION_ROOT = 0x20000000L;
    private long initBits = 0x3fffffffL;

    private @Nullable List<String> arguments = null;
    private @Nullable Collection<? extends MavenProtocPlugin> binaryMavenPlugins;
    private @Nullable Collection<? extends PathProtocPlugin> binaryPathPlugins;
    private @Nullable Collection<? extends UriProtocPlugin> binaryUrlPlugins;
    private @Nullable DependencyResolutionDepth dependencyResolutionDepth;
    private @Nullable List<String> dependencyScopes = null;
    private @Nullable Collection<Language> enabledLanguages;
    private @Nullable List<String> excludes = null;
    private @Nullable Map<String, String> environmentVariables = null;
    private @Nullable Collection<? extends MavenArtifact> importDependencies;
    private @Nullable Collection<Path> importPaths;
    private @Nullable List<String> includes = null;
    private @Nullable Collection<? extends MavenProtocPlugin> jvmMavenPlugins;
    private @Nullable Path outputDirectory;
    private @Nullable Path outputDescriptorFile;
    private boolean outputDescriptorAttached;
    private @Nullable String outputDescriptorAttachmentType;
    private @Nullable String outputDescriptorAttachmentClassifier;
    private @Nullable Digest protocDigest;
    private @Nullable String protocVersion;
    private @Nullable Path sanctionedExecutablePath;
    private @Nullable Collection<? extends MavenArtifact> sourceDependencies;
    private @Nullable Collection<? extends MavenArtifact> sourceDescriptorDependencies;
    private @Nullable Collection<Path> sourceDescriptorPaths;
    private @Nullable Collection<Path> sourceDirectories;
    private @Nullable SourceRootRegistrar sourceRootRegistrar;
    private @Nullable OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar;
    private boolean cleanOutputDirectories;
    private boolean embedSourcesInClassOutputs;
    private boolean failOnInvalidDependencies;
    private boolean failOnMissingSources;
    private boolean failOnMissingTargets;
    private boolean fatalWarnings;
    private boolean ignoreProjectDependencies;
    private boolean incrementalCompilationEnabled;
    private boolean liteEnabled;
    private boolean outputDescriptorIncludeImports;
    private boolean outputDescriptorIncludeSourceInfo;
    private boolean outputDescriptorRetainOptions;
    private boolean registerAsCompilationRoot;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GenerationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GenerationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      addAllArguments(instance.getArguments());
      Collection<? extends MavenProtocPlugin> binaryMavenPluginsValue = instance.getBinaryMavenPlugins();
      if (binaryMavenPluginsValue != null) {
        binaryMavenPlugins(binaryMavenPluginsValue);
      }
      Collection<? extends PathProtocPlugin> binaryPathPluginsValue = instance.getBinaryPathPlugins();
      if (binaryPathPluginsValue != null) {
        binaryPathPlugins(binaryPathPluginsValue);
      }
      Collection<? extends UriProtocPlugin> binaryUrlPluginsValue = instance.getBinaryUrlPlugins();
      if (binaryUrlPluginsValue != null) {
        binaryUrlPlugins(binaryUrlPluginsValue);
      }
      DependencyResolutionDepth dependencyResolutionDepthValue = instance.getDependencyResolutionDepth();
      if (dependencyResolutionDepthValue != null) {
        dependencyResolutionDepth(dependencyResolutionDepthValue);
      }
      addAllDependencyScopes(instance.getDependencyScopes());
      Collection<Language> enabledLanguagesValue = instance.getEnabledLanguages();
      if (enabledLanguagesValue != null) {
        enabledLanguages(enabledLanguagesValue);
      }
      addAllExcludes(instance.getExcludes());
      putAllEnvironmentVariables(instance.getEnvironmentVariables());
      Collection<? extends MavenArtifact> importDependenciesValue = instance.getImportDependencies();
      if (importDependenciesValue != null) {
        importDependencies(importDependenciesValue);
      }
      Collection<Path> importPathsValue = instance.getImportPaths();
      if (importPathsValue != null) {
        importPaths(importPathsValue);
      }
      addAllIncludes(instance.getIncludes());
      Collection<? extends MavenProtocPlugin> jvmMavenPluginsValue = instance.getJvmMavenPlugins();
      if (jvmMavenPluginsValue != null) {
        jvmMavenPlugins(jvmMavenPluginsValue);
      }
      Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        outputDirectory(outputDirectoryValue);
      }
      @Nullable Path outputDescriptorFileValue = instance.getOutputDescriptorFile();
      if (outputDescriptorFileValue != null) {
        outputDescriptorFile(outputDescriptorFileValue);
      }
      this.outputDescriptorAttached(instance.isOutputDescriptorAttached());
      @Nullable String outputDescriptorAttachmentTypeValue = instance.getOutputDescriptorAttachmentType();
      if (outputDescriptorAttachmentTypeValue != null) {
        outputDescriptorAttachmentType(outputDescriptorAttachmentTypeValue);
      }
      @Nullable String outputDescriptorAttachmentClassifierValue = instance.getOutputDescriptorAttachmentClassifier();
      if (outputDescriptorAttachmentClassifierValue != null) {
        outputDescriptorAttachmentClassifier(outputDescriptorAttachmentClassifierValue);
      }
      @Nullable Digest protocDigestValue = instance.getProtocDigest();
      if (protocDigestValue != null) {
        protocDigest(protocDigestValue);
      }
      String protocVersionValue = instance.getProtocVersion();
      if (protocVersionValue != null) {
        protocVersion(protocVersionValue);
      }
      @Nullable Path sanctionedExecutablePathValue = instance.getSanctionedExecutablePath();
      if (sanctionedExecutablePathValue != null) {
        sanctionedExecutablePath(sanctionedExecutablePathValue);
      }
      Collection<? extends MavenArtifact> sourceDependenciesValue = instance.getSourceDependencies();
      if (sourceDependenciesValue != null) {
        sourceDependencies(sourceDependenciesValue);
      }
      Collection<? extends MavenArtifact> sourceDescriptorDependenciesValue = instance.getSourceDescriptorDependencies();
      if (sourceDescriptorDependenciesValue != null) {
        sourceDescriptorDependencies(sourceDescriptorDependenciesValue);
      }
      Collection<Path> sourceDescriptorPathsValue = instance.getSourceDescriptorPaths();
      if (sourceDescriptorPathsValue != null) {
        sourceDescriptorPaths(sourceDescriptorPathsValue);
      }
      Collection<Path> sourceDirectoriesValue = instance.getSourceDirectories();
      if (sourceDirectoriesValue != null) {
        sourceDirectories(sourceDirectoriesValue);
      }
      SourceRootRegistrar sourceRootRegistrarValue = instance.getSourceRootRegistrar();
      if (sourceRootRegistrarValue != null) {
        sourceRootRegistrar(sourceRootRegistrarValue);
      }
      OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrarValue = instance.getOutputDescriptorAttachmentRegistrar();
      if (outputDescriptorAttachmentRegistrarValue != null) {
        outputDescriptorAttachmentRegistrar(outputDescriptorAttachmentRegistrarValue);
      }
      this.cleanOutputDirectories(instance.isCleanOutputDirectories());
      this.embedSourcesInClassOutputs(instance.isEmbedSourcesInClassOutputs());
      this.failOnInvalidDependencies(instance.isFailOnInvalidDependencies());
      this.failOnMissingSources(instance.isFailOnMissingSources());
      this.failOnMissingTargets(instance.isFailOnMissingTargets());
      this.fatalWarnings(instance.isFatalWarnings());
      this.ignoreProjectDependencies(instance.isIgnoreProjectDependencies());
      this.incrementalCompilationEnabled(instance.isIncrementalCompilationEnabled());
      this.liteEnabled(instance.isLiteEnabled());
      this.outputDescriptorIncludeImports(instance.isOutputDescriptorIncludeImports());
      this.outputDescriptorIncludeSourceInfo(instance.isOutputDescriptorIncludeSourceInfo());
      this.outputDescriptorRetainOptions(instance.isOutputDescriptorRetainOptions());
      this.registerAsCompilationRoot(instance.isRegisterAsCompilationRoot());
      return this;
    }

    /**
     * Adds one element to {@link GenerationRequest#getArguments() arguments} list.
     * @param element A arguments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(@Nullable String element) {
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      this.arguments.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GenerationRequest#getArguments() arguments} list.
     * @param elements An array of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(@Nullable String... elements) {
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      for (String element : elements) {
        this.arguments.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenerationRequest#getArguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arguments(Iterable<@Nullable String> elements) {
      this.arguments = new ArrayList<String>();
      return addAllArguments(elements);
    }

    /**
     * Adds elements to {@link GenerationRequest#getArguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllArguments(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "arguments element");
      if (this.arguments == null) {
        this.arguments = new ArrayList<String>();
      }
      for (String element : elements) {
        this.arguments.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getBinaryMavenPlugins() binaryMavenPlugins} attribute.
     * @param binaryMavenPlugins The value for binaryMavenPlugins (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder binaryMavenPlugins(Collection<? extends MavenProtocPlugin> binaryMavenPlugins) {
      this.binaryMavenPlugins = binaryMavenPlugins;
      initBits &= ~INIT_BIT_BINARY_MAVEN_PLUGINS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getBinaryPathPlugins() binaryPathPlugins} attribute.
     * @param binaryPathPlugins The value for binaryPathPlugins (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder binaryPathPlugins(Collection<? extends PathProtocPlugin> binaryPathPlugins) {
      this.binaryPathPlugins = binaryPathPlugins;
      initBits &= ~INIT_BIT_BINARY_PATH_PLUGINS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getBinaryUrlPlugins() binaryUrlPlugins} attribute.
     * @param binaryUrlPlugins The value for binaryUrlPlugins (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder binaryUrlPlugins(Collection<? extends UriProtocPlugin> binaryUrlPlugins) {
      this.binaryUrlPlugins = binaryUrlPlugins;
      initBits &= ~INIT_BIT_BINARY_URL_PLUGINS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getDependencyResolutionDepth() dependencyResolutionDepth} attribute.
     * @param dependencyResolutionDepth The value for dependencyResolutionDepth (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dependencyResolutionDepth(DependencyResolutionDepth dependencyResolutionDepth) {
      this.dependencyResolutionDepth = dependencyResolutionDepth;
      initBits &= ~INIT_BIT_DEPENDENCY_RESOLUTION_DEPTH;
      return this;
    }

    /**
     * Adds one element to {@link GenerationRequest#getDependencyScopes() dependencyScopes} set.
     * @param element A dependencyScopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencyScopes(@Nullable String element) {
      if (this.dependencyScopes == null) {
        this.dependencyScopes = new ArrayList<String>();
      }
      this.dependencyScopes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GenerationRequest#getDependencyScopes() dependencyScopes} set.
     * @param elements An array of dependencyScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDependencyScopes(@Nullable String... elements) {
      if (this.dependencyScopes == null) {
        this.dependencyScopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dependencyScopes.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenerationRequest#getDependencyScopes() dependencyScopes} set.
     * @param elements An iterable of dependencyScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dependencyScopes(Iterable<@Nullable String> elements) {
      this.dependencyScopes = new ArrayList<String>();
      return addAllDependencyScopes(elements);
    }

    /**
     * Adds elements to {@link GenerationRequest#getDependencyScopes() dependencyScopes} set.
     * @param elements An iterable of dependencyScopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDependencyScopes(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "dependencyScopes element");
      if (this.dependencyScopes == null) {
        this.dependencyScopes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.dependencyScopes.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getEnabledLanguages() enabledLanguages} attribute.
     * @param enabledLanguages The value for enabledLanguages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabledLanguages(Collection<Language> enabledLanguages) {
      this.enabledLanguages = enabledLanguages;
      initBits &= ~INIT_BIT_ENABLED_LANGUAGES;
      return this;
    }

    /**
     * Adds one element to {@link GenerationRequest#getExcludes() excludes} list.
     * @param element A excludes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExcludes(@Nullable String element) {
      if (this.excludes == null) {
        this.excludes = new ArrayList<String>();
      }
      this.excludes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GenerationRequest#getExcludes() excludes} list.
     * @param elements An array of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addExcludes(@Nullable String... elements) {
      if (this.excludes == null) {
        this.excludes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.excludes.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenerationRequest#getExcludes() excludes} list.
     * @param elements An iterable of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder excludes(Iterable<@Nullable String> elements) {
      this.excludes = new ArrayList<String>();
      return addAllExcludes(elements);
    }

    /**
     * Adds elements to {@link GenerationRequest#getExcludes() excludes} list.
     * @param elements An iterable of excludes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExcludes(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "excludes element");
      if (this.excludes == null) {
        this.excludes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.excludes.add(element);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GenerationRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(@Nullable String key, @Nullable String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GenerationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(Map.Entry<@Nullable String, ? extends @Nullable String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      @Nullable String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GenerationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GenerationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<@Nullable String, ? extends @Nullable String> e : entries.entrySet()) {
        String k = e.getKey();
        @Nullable String v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getImportDependencies() importDependencies} attribute.
     * @param importDependencies The value for importDependencies (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder importDependencies(Collection<? extends MavenArtifact> importDependencies) {
      this.importDependencies = importDependencies;
      initBits &= ~INIT_BIT_IMPORT_DEPENDENCIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getImportPaths() importPaths} attribute.
     * @param importPaths The value for importPaths (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder importPaths(Collection<Path> importPaths) {
      this.importPaths = importPaths;
      initBits &= ~INIT_BIT_IMPORT_PATHS;
      return this;
    }

    /**
     * Adds one element to {@link GenerationRequest#getIncludes() includes} list.
     * @param element A includes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIncludes(@Nullable String element) {
      if (this.includes == null) {
        this.includes = new ArrayList<String>();
      }
      this.includes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GenerationRequest#getIncludes() includes} list.
     * @param elements An array of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addIncludes(@Nullable String... elements) {
      if (this.includes == null) {
        this.includes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.includes.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GenerationRequest#getIncludes() includes} list.
     * @param elements An iterable of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder includes(Iterable<@Nullable String> elements) {
      this.includes = new ArrayList<String>();
      return addAllIncludes(elements);
    }

    /**
     * Adds elements to {@link GenerationRequest#getIncludes() includes} list.
     * @param elements An iterable of includes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIncludes(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "includes element");
      if (this.includes == null) {
        this.includes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.includes.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getJvmMavenPlugins() jvmMavenPlugins} attribute.
     * @param jvmMavenPlugins The value for jvmMavenPlugins (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jvmMavenPlugins(Collection<? extends MavenProtocPlugin> jvmMavenPlugins) {
      this.jvmMavenPlugins = jvmMavenPlugins;
      initBits &= ~INIT_BIT_JVM_MAVEN_PLUGINS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getOutputDirectory() outputDirectory} attribute.
     * @param outputDirectory The value for outputDirectory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDirectory(Path outputDirectory) {
      this.outputDirectory = outputDirectory;
      initBits &= ~INIT_BIT_OUTPUT_DIRECTORY;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getOutputDescriptorFile() outputDescriptorFile} attribute.
     * @param outputDescriptorFile The value for outputDescriptorFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorFile(@Nullable Path outputDescriptorFile) {
      this.outputDescriptorFile = outputDescriptorFile;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isOutputDescriptorAttached() outputDescriptorAttached} attribute.
     * @param outputDescriptorAttached The value for outputDescriptorAttached 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorAttached(boolean outputDescriptorAttached) {
      this.outputDescriptorAttached = outputDescriptorAttached;
      initBits &= ~INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHED;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getOutputDescriptorAttachmentType() outputDescriptorAttachmentType} attribute.
     * @param outputDescriptorAttachmentType The value for outputDescriptorAttachmentType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorAttachmentType(@Nullable String outputDescriptorAttachmentType) {
      this.outputDescriptorAttachmentType = outputDescriptorAttachmentType;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getOutputDescriptorAttachmentClassifier() outputDescriptorAttachmentClassifier} attribute.
     * @param outputDescriptorAttachmentClassifier The value for outputDescriptorAttachmentClassifier (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorAttachmentClassifier(@Nullable String outputDescriptorAttachmentClassifier) {
      this.outputDescriptorAttachmentClassifier = outputDescriptorAttachmentClassifier;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getProtocDigest() protocDigest} attribute.
     * @param protocDigest The value for protocDigest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocDigest(@Nullable Digest protocDigest) {
      this.protocDigest = protocDigest;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getProtocVersion() protocVersion} attribute.
     * @param protocVersion The value for protocVersion (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protocVersion(String protocVersion) {
      this.protocVersion = protocVersion;
      initBits &= ~INIT_BIT_PROTOC_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSanctionedExecutablePath() sanctionedExecutablePath} attribute.
     * @param sanctionedExecutablePath The value for sanctionedExecutablePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sanctionedExecutablePath(@Nullable Path sanctionedExecutablePath) {
      this.sanctionedExecutablePath = sanctionedExecutablePath;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSourceDependencies() sourceDependencies} attribute.
     * @param sourceDependencies The value for sourceDependencies (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceDependencies(Collection<? extends MavenArtifact> sourceDependencies) {
      this.sourceDependencies = sourceDependencies;
      initBits &= ~INIT_BIT_SOURCE_DEPENDENCIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSourceDescriptorDependencies() sourceDescriptorDependencies} attribute.
     * @param sourceDescriptorDependencies The value for sourceDescriptorDependencies (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceDescriptorDependencies(Collection<? extends MavenArtifact> sourceDescriptorDependencies) {
      this.sourceDescriptorDependencies = sourceDescriptorDependencies;
      initBits &= ~INIT_BIT_SOURCE_DESCRIPTOR_DEPENDENCIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSourceDescriptorPaths() sourceDescriptorPaths} attribute.
     * @param sourceDescriptorPaths The value for sourceDescriptorPaths (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceDescriptorPaths(Collection<Path> sourceDescriptorPaths) {
      this.sourceDescriptorPaths = sourceDescriptorPaths;
      initBits &= ~INIT_BIT_SOURCE_DESCRIPTOR_PATHS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSourceDirectories() sourceDirectories} attribute.
     * @param sourceDirectories The value for sourceDirectories (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceDirectories(Collection<Path> sourceDirectories) {
      this.sourceDirectories = sourceDirectories;
      initBits &= ~INIT_BIT_SOURCE_DIRECTORIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getSourceRootRegistrar() sourceRootRegistrar} attribute.
     * @param sourceRootRegistrar The value for sourceRootRegistrar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceRootRegistrar(SourceRootRegistrar sourceRootRegistrar) {
      this.sourceRootRegistrar = sourceRootRegistrar;
      initBits &= ~INIT_BIT_SOURCE_ROOT_REGISTRAR;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#getOutputDescriptorAttachmentRegistrar() outputDescriptorAttachmentRegistrar} attribute.
     * @param outputDescriptorAttachmentRegistrar The value for outputDescriptorAttachmentRegistrar (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorAttachmentRegistrar(OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar) {
      this.outputDescriptorAttachmentRegistrar = outputDescriptorAttachmentRegistrar;
      initBits &= ~INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHMENT_REGISTRAR;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isCleanOutputDirectories() cleanOutputDirectories} attribute.
     * @param cleanOutputDirectories The value for cleanOutputDirectories 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cleanOutputDirectories(boolean cleanOutputDirectories) {
      this.cleanOutputDirectories = cleanOutputDirectories;
      initBits &= ~INIT_BIT_CLEAN_OUTPUT_DIRECTORIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isEmbedSourcesInClassOutputs() embedSourcesInClassOutputs} attribute.
     * @param embedSourcesInClassOutputs The value for embedSourcesInClassOutputs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder embedSourcesInClassOutputs(boolean embedSourcesInClassOutputs) {
      this.embedSourcesInClassOutputs = embedSourcesInClassOutputs;
      initBits &= ~INIT_BIT_EMBED_SOURCES_IN_CLASS_OUTPUTS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isFailOnInvalidDependencies() failOnInvalidDependencies} attribute.
     * @param failOnInvalidDependencies The value for failOnInvalidDependencies 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failOnInvalidDependencies(boolean failOnInvalidDependencies) {
      this.failOnInvalidDependencies = failOnInvalidDependencies;
      initBits &= ~INIT_BIT_FAIL_ON_INVALID_DEPENDENCIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isFailOnMissingSources() failOnMissingSources} attribute.
     * @param failOnMissingSources The value for failOnMissingSources 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failOnMissingSources(boolean failOnMissingSources) {
      this.failOnMissingSources = failOnMissingSources;
      initBits &= ~INIT_BIT_FAIL_ON_MISSING_SOURCES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isFailOnMissingTargets() failOnMissingTargets} attribute.
     * @param failOnMissingTargets The value for failOnMissingTargets 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder failOnMissingTargets(boolean failOnMissingTargets) {
      this.failOnMissingTargets = failOnMissingTargets;
      initBits &= ~INIT_BIT_FAIL_ON_MISSING_TARGETS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isFatalWarnings() fatalWarnings} attribute.
     * @param fatalWarnings The value for fatalWarnings 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fatalWarnings(boolean fatalWarnings) {
      this.fatalWarnings = fatalWarnings;
      initBits &= ~INIT_BIT_FATAL_WARNINGS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isIgnoreProjectDependencies() ignoreProjectDependencies} attribute.
     * @param ignoreProjectDependencies The value for ignoreProjectDependencies 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ignoreProjectDependencies(boolean ignoreProjectDependencies) {
      this.ignoreProjectDependencies = ignoreProjectDependencies;
      initBits &= ~INIT_BIT_IGNORE_PROJECT_DEPENDENCIES;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isIncrementalCompilationEnabled() incrementalCompilationEnabled} attribute.
     * @param incrementalCompilationEnabled The value for incrementalCompilationEnabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder incrementalCompilationEnabled(boolean incrementalCompilationEnabled) {
      this.incrementalCompilationEnabled = incrementalCompilationEnabled;
      initBits &= ~INIT_BIT_INCREMENTAL_COMPILATION_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isLiteEnabled() liteEnabled} attribute.
     * @param liteEnabled The value for liteEnabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder liteEnabled(boolean liteEnabled) {
      this.liteEnabled = liteEnabled;
      initBits &= ~INIT_BIT_LITE_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isOutputDescriptorIncludeImports() outputDescriptorIncludeImports} attribute.
     * @param outputDescriptorIncludeImports The value for outputDescriptorIncludeImports 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorIncludeImports(boolean outputDescriptorIncludeImports) {
      this.outputDescriptorIncludeImports = outputDescriptorIncludeImports;
      initBits &= ~INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_IMPORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isOutputDescriptorIncludeSourceInfo() outputDescriptorIncludeSourceInfo} attribute.
     * @param outputDescriptorIncludeSourceInfo The value for outputDescriptorIncludeSourceInfo 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorIncludeSourceInfo(boolean outputDescriptorIncludeSourceInfo) {
      this.outputDescriptorIncludeSourceInfo = outputDescriptorIncludeSourceInfo;
      initBits &= ~INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_SOURCE_INFO;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isOutputDescriptorRetainOptions() outputDescriptorRetainOptions} attribute.
     * @param outputDescriptorRetainOptions The value for outputDescriptorRetainOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDescriptorRetainOptions(boolean outputDescriptorRetainOptions) {
      this.outputDescriptorRetainOptions = outputDescriptorRetainOptions;
      initBits &= ~INIT_BIT_OUTPUT_DESCRIPTOR_RETAIN_OPTIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link GenerationRequest#isRegisterAsCompilationRoot() registerAsCompilationRoot} attribute.
     * @param registerAsCompilationRoot The value for registerAsCompilationRoot 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder registerAsCompilationRoot(boolean registerAsCompilationRoot) {
      this.registerAsCompilationRoot = registerAsCompilationRoot;
      initBits &= ~INIT_BIT_REGISTER_AS_COMPILATION_ROOT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenerationRequest ImmutableGenerationRequest}.
     * @return An immutable instance of GenerationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenerationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenerationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BINARY_MAVEN_PLUGINS) != 0) attributes.add("binaryMavenPlugins");
      if ((initBits & INIT_BIT_BINARY_PATH_PLUGINS) != 0) attributes.add("binaryPathPlugins");
      if ((initBits & INIT_BIT_BINARY_URL_PLUGINS) != 0) attributes.add("binaryUrlPlugins");
      if ((initBits & INIT_BIT_DEPENDENCY_RESOLUTION_DEPTH) != 0) attributes.add("dependencyResolutionDepth");
      if ((initBits & INIT_BIT_ENABLED_LANGUAGES) != 0) attributes.add("enabledLanguages");
      if ((initBits & INIT_BIT_IMPORT_DEPENDENCIES) != 0) attributes.add("importDependencies");
      if ((initBits & INIT_BIT_IMPORT_PATHS) != 0) attributes.add("importPaths");
      if ((initBits & INIT_BIT_JVM_MAVEN_PLUGINS) != 0) attributes.add("jvmMavenPlugins");
      if ((initBits & INIT_BIT_OUTPUT_DIRECTORY) != 0) attributes.add("outputDirectory");
      if ((initBits & INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHED) != 0) attributes.add("outputDescriptorAttached");
      if ((initBits & INIT_BIT_PROTOC_VERSION) != 0) attributes.add("protocVersion");
      if ((initBits & INIT_BIT_SOURCE_DEPENDENCIES) != 0) attributes.add("sourceDependencies");
      if ((initBits & INIT_BIT_SOURCE_DESCRIPTOR_DEPENDENCIES) != 0) attributes.add("sourceDescriptorDependencies");
      if ((initBits & INIT_BIT_SOURCE_DESCRIPTOR_PATHS) != 0) attributes.add("sourceDescriptorPaths");
      if ((initBits & INIT_BIT_SOURCE_DIRECTORIES) != 0) attributes.add("sourceDirectories");
      if ((initBits & INIT_BIT_SOURCE_ROOT_REGISTRAR) != 0) attributes.add("sourceRootRegistrar");
      if ((initBits & INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHMENT_REGISTRAR) != 0) attributes.add("outputDescriptorAttachmentRegistrar");
      if ((initBits & INIT_BIT_CLEAN_OUTPUT_DIRECTORIES) != 0) attributes.add("cleanOutputDirectories");
      if ((initBits & INIT_BIT_EMBED_SOURCES_IN_CLASS_OUTPUTS) != 0) attributes.add("embedSourcesInClassOutputs");
      if ((initBits & INIT_BIT_FAIL_ON_INVALID_DEPENDENCIES) != 0) attributes.add("failOnInvalidDependencies");
      if ((initBits & INIT_BIT_FAIL_ON_MISSING_SOURCES) != 0) attributes.add("failOnMissingSources");
      if ((initBits & INIT_BIT_FAIL_ON_MISSING_TARGETS) != 0) attributes.add("failOnMissingTargets");
      if ((initBits & INIT_BIT_FATAL_WARNINGS) != 0) attributes.add("fatalWarnings");
      if ((initBits & INIT_BIT_IGNORE_PROJECT_DEPENDENCIES) != 0) attributes.add("ignoreProjectDependencies");
      if ((initBits & INIT_BIT_INCREMENTAL_COMPILATION_ENABLED) != 0) attributes.add("incrementalCompilationEnabled");
      if ((initBits & INIT_BIT_LITE_ENABLED) != 0) attributes.add("liteEnabled");
      if ((initBits & INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_IMPORTS) != 0) attributes.add("outputDescriptorIncludeImports");
      if ((initBits & INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_SOURCE_INFO) != 0) attributes.add("outputDescriptorIncludeSourceInfo");
      if ((initBits & INIT_BIT_OUTPUT_DESCRIPTOR_RETAIN_OPTIONS) != 0) attributes.add("outputDescriptorRetainOptions");
      if ((initBits & INIT_BIT_REGISTER_AS_COMPILATION_ROOT) != 0) attributes.add("registerAsCompilationRoot");
      return "Cannot build GenerationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
