/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link MavenProtocPlugin}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMavenProtocPlugin.builder()}.
 */
@Generated(from = "MavenProtocPlugin", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMavenProtocPlugin
    implements MavenProtocPlugin {
  private final @Nullable String groupId;
  private final @Nullable String artifactId;
  private final @Nullable String type;
  private final @Nullable String classifier;
  private final @Nullable String options;
  private final @Nullable Path outputDirectory;
  private final @Nullable Boolean registerAsCompilationRoot;
  private final int order;
  private final boolean skip;
  private final @NonNull @Nullable String version;
  private final @Nullable List<String> jvmArgs;
  private final @Nullable List<String> jvmConfigArgs;
  private final @Nullable String mainClass;

  private ImmutableMavenProtocPlugin(ImmutableMavenProtocPlugin.Builder builder) {
    this.groupId = builder.groupId;
    this.artifactId = builder.artifactId;
    this.type = builder.type;
    this.classifier = builder.classifier;
    this.options = builder.options;
    this.outputDirectory = builder.outputDirectory;
    this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
    this.version = builder.version;
    this.jvmArgs = builder.jvmArgs == null ? null : createUnmodifiableList(true, builder.jvmArgs);
    this.jvmConfigArgs = builder.jvmConfigArgs == null ? null : createUnmodifiableList(true, builder.jvmConfigArgs);
    this.mainClass = builder.mainClass;
    if (builder.orderIsSet()) {
      initShim.order(builder.order);
    }
    if (builder.skipIsSet()) {
      initShim.skip(builder.skip);
    }
    this.order = initShim.getOrder();
    this.skip = initShim.isSkip();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MavenProtocPlugin", generator = "Immutables")
  private final class InitShim {
    private byte orderBuildStage = STAGE_UNINITIALIZED;
    private int order;

    int getOrder() {
      if (orderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orderBuildStage == STAGE_UNINITIALIZED) {
        orderBuildStage = STAGE_INITIALIZING;
        int computedValue = getOrderInitialize();
        this.order = computedValue;
        orderBuildStage = STAGE_INITIALIZED;
      }
      return this.order;
    }

    void order(int order) {
      this.order = order;
      orderBuildStage = STAGE_INITIALIZED;
    }

    private byte skipBuildStage = STAGE_UNINITIALIZED;
    private boolean skip;

    boolean isSkip() {
      if (skipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (skipBuildStage == STAGE_UNINITIALIZED) {
        skipBuildStage = STAGE_INITIALIZING;
        boolean computedValue = isSkipInitialize();
        this.skip = computedValue;
        skipBuildStage = STAGE_INITIALIZED;
      }
      return this.skip;
    }

    void skip(boolean skip) {
      this.skip = skip;
      skipBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (orderBuildStage == STAGE_INITIALIZING) attributes.add("order");
      if (skipBuildStage == STAGE_INITIALIZING) attributes.add("skip");
      return "Cannot build MavenProtocPlugin, attribute initializers form cycle " + attributes;
    }
  }

  private int getOrderInitialize() {
    return MavenProtocPlugin.super.getOrder();
  }

  private boolean isSkipInitialize() {
    return MavenProtocPlugin.super.isSkip();
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @Override
  public @Nullable String getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code artifactId} attribute
   */
  @Override
  public @Nullable String getArtifactId() {
    return artifactId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code classifier} attribute
   */
  @Override
  public @Nullable String getClassifier() {
    return classifier;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @Override
  public @Nullable String getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code outputDirectory} attribute
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return The value of the {@code registerAsCompilationRoot} attribute
   */
  @Override
  public @Nullable Boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrder()
        : this.order;
  }

  /**
   * @return The value of the {@code skip} attribute
   */
  @Override
  public boolean isSkip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSkip()
        : this.skip;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public @NonNull @Nullable String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code jvmArgs} attribute
   */
  @Override
  public @Nullable List<String> getJvmArgs() {
    return jvmArgs;
  }

  /**
   * @return The value of the {@code jvmConfigArgs} attribute
   */
  @Override
  public @Nullable List<String> getJvmConfigArgs() {
    return jvmConfigArgs;
  }

  /**
   * @return The value of the {@code mainClass} attribute
   */
  @Override
  public @Nullable String getMainClass() {
    return mainClass;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMavenProtocPlugin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMavenProtocPlugin
        && equalsByValue((ImmutableMavenProtocPlugin) another);
  }

  private boolean equalsByValue(ImmutableMavenProtocPlugin another) {
    return Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && Objects.equals(type, another.type)
        && Objects.equals(classifier, another.classifier)
        && Objects.equals(options, another.options)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && order == another.order
        && skip == another.skip
        && Objects.equals(version, another.version)
        && Objects.equals(jvmArgs, another.jvmArgs)
        && Objects.equals(jvmConfigArgs, another.jvmConfigArgs)
        && Objects.equals(mainClass, another.mainClass);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code type}, {@code classifier}, {@code options}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code order}, {@code skip}, {@code version}, {@code jvmArgs}, {@code jvmConfigArgs}, {@code mainClass}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(classifier);
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    h += (h << 5) + order;
    h += (h << 5) + Boolean.hashCode(skip);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(jvmArgs);
    h += (h << 5) + Objects.hashCode(jvmConfigArgs);
    h += (h << 5) + Objects.hashCode(mainClass);
    return h;
  }

  /**
   * Prints the immutable value {@code MavenProtocPlugin} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MavenProtocPlugin{"
        + "groupId=" + groupId
        + ", artifactId=" + artifactId
        + ", type=" + type
        + ", classifier=" + classifier
        + ", options=" + options
        + ", outputDirectory=" + outputDirectory
        + ", registerAsCompilationRoot=" + registerAsCompilationRoot
        + ", order=" + order
        + ", skip=" + skip
        + ", version=" + version
        + ", jvmArgs=" + jvmArgs
        + ", jvmConfigArgs=" + jvmConfigArgs
        + ", mainClass=" + mainClass
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableMavenProtocPlugin ImmutableMavenProtocPlugin}.
   * <pre>
   * ImmutableMavenProtocPlugin.builder()
   *    .groupId(String | null) // nullable {@link MavenProtocPlugin#getGroupId() groupId}
   *    .artifactId(String | null) // nullable {@link MavenProtocPlugin#getArtifactId() artifactId}
   *    .type(String | null) // nullable {@link MavenProtocPlugin#getType() type}
   *    .classifier(String | null) // nullable {@link MavenProtocPlugin#getClassifier() classifier}
   *    .options(String | null) // nullable {@link MavenProtocPlugin#getOptions() options}
   *    .outputDirectory(java.nio.file.Path | null) // nullable {@link MavenProtocPlugin#getOutputDirectory() outputDirectory}
   *    .registerAsCompilationRoot(Boolean | null) // nullable {@link MavenProtocPlugin#isRegisterAsCompilationRoot() registerAsCompilationRoot}
   *    .order(int) // optional {@link MavenProtocPlugin#getOrder() order}
   *    .skip(boolean) // optional {@link MavenProtocPlugin#isSkip() skip}
   *    .version(String | null) // nullable {@link MavenProtocPlugin#getVersion() version}
   *    .jvmArgs(List&lt;String&gt; | null) // nullable {@link MavenProtocPlugin#getJvmArgs() jvmArgs}
   *    .jvmConfigArgs(List&lt;String&gt; | null) // nullable {@link MavenProtocPlugin#getJvmConfigArgs() jvmConfigArgs}
   *    .mainClass(String | null) // nullable {@link MavenProtocPlugin#getMainClass() mainClass}
   *    .build();
   * </pre>
   * @return A new ImmutableMavenProtocPlugin builder
   */
  public static ImmutableMavenProtocPlugin.Builder builder() {
    return new ImmutableMavenProtocPlugin.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMavenProtocPlugin ImmutableMavenProtocPlugin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MavenProtocPlugin", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private static final long OPT_BIT_ORDER = 0x1L;
    private static final long OPT_BIT_SKIP = 0x2L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable String groupId;
    private @Nullable String artifactId;
    private @Nullable String type;
    private @Nullable String classifier;
    private @Nullable String options;
    private @Nullable Path outputDirectory;
    private @Nullable Boolean registerAsCompilationRoot;
    private int order;
    private boolean skip;
    private @NonNull @Nullable String version;
    private @Nullable List<String> jvmArgs = null;
    private @Nullable List<String> jvmConfigArgs = null;
    private @Nullable String mainClass;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MavenProtocPluginBean} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenProtocPluginBean instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.groupIdIsSet()) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          groupId(groupIdValue);
        }
      }
      if (instance.artifactIdIsSet()) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          artifactId(artifactIdValue);
        }
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        classifier(classifierValue);
      }
      @Nullable String optionsValue = instance.getOptions();
      if (optionsValue != null) {
        options(optionsValue);
      }
      @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        outputDirectory(outputDirectoryValue);
      }
      @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
      if (registerAsCompilationRootValue != null) {
        registerAsCompilationRoot(registerAsCompilationRootValue);
      }
      this.order(instance.getOrder());
      this.skip(instance.isSkip());
      if (instance.versionIsSet()) {
        @NonNull String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
      @Nullable List<String> jvmArgsValue = instance.getJvmArgs();
      if (jvmArgsValue != null) {
        addAllJvmArgs(jvmArgsValue);
      }
      @Nullable List<String> jvmConfigArgsValue = instance.getJvmConfigArgs();
      if (jvmConfigArgsValue != null) {
        addAllJvmConfigArgs(jvmConfigArgsValue);
      }
      @Nullable String mainClassValue = instance.getMainClass();
      if (mainClassValue != null) {
        mainClass(mainClassValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenProtocPlugin instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProtocPlugin instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenArtifact instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      if (object instanceof MavenProtocPluginBean) {
        from((MavenProtocPluginBean) object);
        return;
      }
      long bits = 0;
      if (object instanceof MavenProtocPlugin) {
        MavenProtocPlugin instance = (MavenProtocPlugin) object;
        @Nullable String mainClassValue = instance.getMainClass();
        if (mainClassValue != null) {
          mainClass(mainClassValue);
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
          if (registerAsCompilationRootValue != null) {
            registerAsCompilationRoot(registerAsCompilationRootValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          this.skip(instance.isSkip());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          @NonNull String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x10L;
        }
        @Nullable List<String> jvmArgsValue = instance.getJvmArgs();
        if (jvmArgsValue != null) {
          addAllJvmArgs(jvmArgsValue);
        }
        if ((bits & 0x20L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          @Nullable String optionsValue = instance.getOptions();
          if (optionsValue != null) {
            options(optionsValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
          if (outputDirectoryValue != null) {
            outputDirectory(outputDirectoryValue);
          }
          bits |= 0x100L;
        }
        @Nullable List<String> jvmConfigArgsValue = instance.getJvmConfigArgs();
        if (jvmConfigArgsValue != null) {
          addAllJvmConfigArgs(jvmConfigArgsValue);
        }
        if ((bits & 0x200L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x200L;
        }
      }
      if (object instanceof ProtocPlugin) {
        ProtocPlugin instance = (ProtocPlugin) object;
        if ((bits & 0x40L) == 0) {
          @Nullable String optionsValue = instance.getOptions();
          if (optionsValue != null) {
            options(optionsValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x4L) == 0) {
          this.skip(instance.isSkip());
          bits |= 0x4L;
        }
        if ((bits & 0x100L) == 0) {
          @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
          if (outputDirectoryValue != null) {
            outputDirectory(outputDirectoryValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
          if (registerAsCompilationRootValue != null) {
            registerAsCompilationRoot(registerAsCompilationRootValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x200L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x200L;
        }
      }
      if (object instanceof MavenArtifact) {
        MavenArtifact instance = (MavenArtifact) object;
        if ((bits & 0x20L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x20L;
        }
        if ((bits & 0x80L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          @NonNull String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getGroupId() groupId} attribute.
     * @param groupId The value for groupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = groupId;
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder artifactId(String artifactId) {
      this.artifactId = artifactId;
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getClassifier() classifier} attribute.
     * @param classifier The value for classifier (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classifier(@Nullable String classifier) {
      this.classifier = classifier;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getOptions() options} attribute.
     * @param options The value for options (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder options(@Nullable String options) {
      this.options = options;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getOutputDirectory() outputDirectory} attribute.
     * @param outputDirectory The value for outputDirectory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDirectory(@Nullable Path outputDirectory) {
      this.outputDirectory = outputDirectory;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#isRegisterAsCompilationRoot() registerAsCompilationRoot} attribute.
     * @param registerAsCompilationRoot The value for registerAsCompilationRoot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder registerAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
      this.registerAsCompilationRoot = registerAsCompilationRoot;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getOrder() order} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MavenProtocPlugin#getOrder() order}.</em>
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      optBits |= OPT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#isSkip() skip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MavenProtocPlugin#isSkip() skip}.</em>
     * @param skip The value for skip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skip(boolean skip) {
      this.skip = skip;
      optBits |= OPT_BIT_SKIP;
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@NonNull String version) {
      this.version = version;
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Adds one element to {@link MavenProtocPlugin#getJvmArgs() jvmArgs} list.
     * @param element A jvmArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmArgs(@Nullable String element) {
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      this.jvmArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MavenProtocPlugin#getJvmArgs() jvmArgs} list.
     * @param elements An array of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmArgs(@Nullable String... elements) {
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmArgs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MavenProtocPlugin#getJvmArgs() jvmArgs} list.
     * @param elements An iterable of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jvmArgs(@Nullable Iterable<@Nullable String> elements) {
      if (elements == null) {
        this.jvmArgs = null;
        return this;
      }
      this.jvmArgs = new ArrayList<String>();
      return addAllJvmArgs(elements);
    }

    /**
     * Adds elements to {@link MavenProtocPlugin#getJvmArgs() jvmArgs} list.
     * @param elements An iterable of jvmArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJvmArgs(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "jvmArgs element");
      if (this.jvmArgs == null) {
        this.jvmArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmArgs.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link MavenProtocPlugin#getJvmConfigArgs() jvmConfigArgs} list.
     * @param element A jvmConfigArgs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmConfigArgs(@Nullable String element) {
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      this.jvmConfigArgs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MavenProtocPlugin#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An array of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addJvmConfigArgs(@Nullable String... elements) {
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmConfigArgs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MavenProtocPlugin#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An iterable of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder jvmConfigArgs(@Nullable Iterable<@Nullable String> elements) {
      if (elements == null) {
        this.jvmConfigArgs = null;
        return this;
      }
      this.jvmConfigArgs = new ArrayList<String>();
      return addAllJvmConfigArgs(elements);
    }

    /**
     * Adds elements to {@link MavenProtocPlugin#getJvmConfigArgs() jvmConfigArgs} list.
     * @param elements An iterable of jvmConfigArgs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllJvmConfigArgs(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "jvmConfigArgs element");
      if (this.jvmConfigArgs == null) {
        this.jvmConfigArgs = new ArrayList<String>();
      }
      for (String element : elements) {
        this.jvmConfigArgs.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link MavenProtocPlugin#getMainClass() mainClass} attribute.
     * @param mainClass The value for mainClass (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mainClass(@Nullable String mainClass) {
      this.mainClass = mainClass;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMavenProtocPlugin ImmutableMavenProtocPlugin}.
     * @return An immutable instance of MavenProtocPlugin
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMavenProtocPlugin build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMavenProtocPlugin(this);
    }

    private boolean orderIsSet() {
      return (optBits & OPT_BIT_ORDER) != 0;
    }

    private boolean skipIsSet() {
      return (optBits & OPT_BIT_SKIP) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build MavenProtocPlugin, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
