/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.protoc.targets;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link DescriptorFileProtocTarget}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDescriptorFileProtocTarget.builder()}.
 */
@Generated(from = "DescriptorFileProtocTarget", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDescriptorFileProtocTarget
    implements DescriptorFileProtocTarget {
  private final int order;
  private final @Nullable Path outputFile;
  private final boolean includeImports;
  private final boolean includeSourceInfo;
  private final boolean retainOptions;

  private ImmutableDescriptorFileProtocTarget(ImmutableDescriptorFileProtocTarget.Builder builder) {
    this.outputFile = builder.outputFile;
    this.includeImports = builder.includeImports;
    this.includeSourceInfo = builder.includeSourceInfo;
    this.retainOptions = builder.retainOptions;
    this.order = builder.orderIsSet()
        ? builder.order
        : DescriptorFileProtocTarget.super.getOrder();
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    return order;
  }

  /**
   * @return The value of the {@code outputFile} attribute
   */
  @Override
  public @Nullable Path getOutputFile() {
    return outputFile;
  }

  /**
   * @return The value of the {@code includeImports} attribute
   */
  @Override
  public boolean isIncludeImports() {
    return includeImports;
  }

  /**
   * @return The value of the {@code includeSourceInfo} attribute
   */
  @Override
  public boolean isIncludeSourceInfo() {
    return includeSourceInfo;
  }

  /**
   * @return The value of the {@code retainOptions} attribute
   */
  @Override
  public boolean isRetainOptions() {
    return retainOptions;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDescriptorFileProtocTarget} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDescriptorFileProtocTarget
        && equalsByValue((ImmutableDescriptorFileProtocTarget) another);
  }

  private boolean equalsByValue(ImmutableDescriptorFileProtocTarget another) {
    return order == another.order
        && Objects.equals(outputFile, another.outputFile)
        && includeImports == another.includeImports
        && includeSourceInfo == another.includeSourceInfo
        && retainOptions == another.retainOptions;
  }

  /**
   * Computes a hash code from attributes: {@code order}, {@code outputFile}, {@code includeImports}, {@code includeSourceInfo}, {@code retainOptions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + order;
    h += (h << 5) + Objects.hashCode(outputFile);
    h += (h << 5) + Boolean.hashCode(includeImports);
    h += (h << 5) + Boolean.hashCode(includeSourceInfo);
    h += (h << 5) + Boolean.hashCode(retainOptions);
    return h;
  }

  /**
   * Prints the immutable value {@code DescriptorFileProtocTarget} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DescriptorFileProtocTarget{"
        + "order=" + order
        + ", outputFile=" + outputFile
        + ", includeImports=" + includeImports
        + ", includeSourceInfo=" + includeSourceInfo
        + ", retainOptions=" + retainOptions
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableDescriptorFileProtocTarget ImmutableDescriptorFileProtocTarget}.
   * <pre>
   * ImmutableDescriptorFileProtocTarget.builder()
   *    .order(int) // optional {@link DescriptorFileProtocTarget#getOrder() order}
   *    .outputFile(java.nio.file.Path | null) // nullable {@link DescriptorFileProtocTarget#getOutputFile() outputFile}
   *    .includeImports(boolean) // required {@link DescriptorFileProtocTarget#isIncludeImports() includeImports}
   *    .includeSourceInfo(boolean) // required {@link DescriptorFileProtocTarget#isIncludeSourceInfo() includeSourceInfo}
   *    .retainOptions(boolean) // required {@link DescriptorFileProtocTarget#isRetainOptions() retainOptions}
   *    .build();
   * </pre>
   * @return A new ImmutableDescriptorFileProtocTarget builder
   */
  public static ImmutableDescriptorFileProtocTarget.Builder builder() {
    return new ImmutableDescriptorFileProtocTarget.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDescriptorFileProtocTarget ImmutableDescriptorFileProtocTarget}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DescriptorFileProtocTarget", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_OUTPUT_FILE = 0x1L;
    private static final long INIT_BIT_INCLUDE_IMPORTS = 0x2L;
    private static final long INIT_BIT_INCLUDE_SOURCE_INFO = 0x4L;
    private static final long INIT_BIT_RETAIN_OPTIONS = 0x8L;
    private static final long OPT_BIT_ORDER = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private int order;
    private @Nullable Path outputFile;
    private boolean includeImports;
    private boolean includeSourceInfo;
    private boolean retainOptions;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProtocTarget instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.protoc.targets.DescriptorFileProtocTarget} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DescriptorFileProtocTarget instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      long bits = 0;
      if (object instanceof ProtocTarget) {
        ProtocTarget instance = (ProtocTarget) object;
        if ((bits & 0x1L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x1L;
        }
      }
      if (object instanceof DescriptorFileProtocTarget) {
        DescriptorFileProtocTarget instance = (DescriptorFileProtocTarget) object;
        Path outputFileValue = instance.getOutputFile();
        if (outputFileValue != null) {
          outputFile(outputFileValue);
        }
        this.includeSourceInfo(instance.isIncludeSourceInfo());
        this.retainOptions(instance.isRetainOptions());
        this.includeImports(instance.isIncludeImports());
        if ((bits & 0x1L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DescriptorFileProtocTarget#getOrder() order} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DescriptorFileProtocTarget#getOrder() order}.</em>
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      optBits |= OPT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link DescriptorFileProtocTarget#getOutputFile() outputFile} attribute.
     * @param outputFile The value for outputFile (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputFile(Path outputFile) {
      this.outputFile = outputFile;
      initBits &= ~INIT_BIT_OUTPUT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link DescriptorFileProtocTarget#isIncludeImports() includeImports} attribute.
     * @param includeImports The value for includeImports 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder includeImports(boolean includeImports) {
      this.includeImports = includeImports;
      initBits &= ~INIT_BIT_INCLUDE_IMPORTS;
      return this;
    }

    /**
     * Initializes the value for the {@link DescriptorFileProtocTarget#isIncludeSourceInfo() includeSourceInfo} attribute.
     * @param includeSourceInfo The value for includeSourceInfo 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder includeSourceInfo(boolean includeSourceInfo) {
      this.includeSourceInfo = includeSourceInfo;
      initBits &= ~INIT_BIT_INCLUDE_SOURCE_INFO;
      return this;
    }

    /**
     * Initializes the value for the {@link DescriptorFileProtocTarget#isRetainOptions() retainOptions} attribute.
     * @param retainOptions The value for retainOptions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder retainOptions(boolean retainOptions) {
      this.retainOptions = retainOptions;
      initBits &= ~INIT_BIT_RETAIN_OPTIONS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDescriptorFileProtocTarget ImmutableDescriptorFileProtocTarget}.
     * @return An immutable instance of DescriptorFileProtocTarget
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDescriptorFileProtocTarget build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDescriptorFileProtocTarget(this);
    }

    private boolean orderIsSet() {
      return (optBits & OPT_BIT_ORDER) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OUTPUT_FILE) != 0) attributes.add("outputFile");
      if ((initBits & INIT_BIT_INCLUDE_IMPORTS) != 0) attributes.add("includeImports");
      if ((initBits & INIT_BIT_INCLUDE_SOURCE_INFO) != 0) attributes.add("includeSourceInfo");
      if ((initBits & INIT_BIT_RETAIN_OPTIONS) != 0) attributes.add("retainOptions");
      return "Cannot build DescriptorFileProtocTarget, some of required attributes are not set " + attributes;
    }
  }
}
