/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link DescriptorListing}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDescriptorListing.builder()}.
 */
@Generated(from = "DescriptorListing", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDescriptorListing
    implements DescriptorListing {
  private final @Nullable Path descriptorFilePath;
  private final Set<String> sourceFiles;

  private ImmutableDescriptorListing(ImmutableDescriptorListing.Builder builder) {
    this.descriptorFilePath = builder.descriptorFilePath;
    this.sourceFiles = builder.sourceFiles == null ? Collections.<String>emptySet() : createUnmodifiableSet(builder.sourceFiles);
  }

  /**
   * @return The value of the {@code descriptorFilePath} attribute
   */
  @Override
  public @Nullable Path getDescriptorFilePath() {
    return descriptorFilePath;
  }

  /**
   * @return The value of the {@code sourceFiles} attribute
   */
  @Override
  public Set<String> getSourceFiles() {
    return sourceFiles;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDescriptorListing} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDescriptorListing
        && equalsByValue((ImmutableDescriptorListing) another);
  }

  private boolean equalsByValue(ImmutableDescriptorListing another) {
    return Objects.equals(descriptorFilePath, another.descriptorFilePath)
        && sourceFiles.equals(another.sourceFiles);
  }

  /**
   * Computes a hash code from attributes: {@code descriptorFilePath}, {@code sourceFiles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(descriptorFilePath);
    h += (h << 5) + sourceFiles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DescriptorListing} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DescriptorListing{"
        + "descriptorFilePath=" + descriptorFilePath
        + ", sourceFiles=" + sourceFiles
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableDescriptorListing ImmutableDescriptorListing}.
   * <pre>
   * ImmutableDescriptorListing.builder()
   *    .descriptorFilePath(java.nio.file.Path | null) // nullable {@link DescriptorListing#getDescriptorFilePath() descriptorFilePath}
   *    .addSourceFiles|addAllSourceFiles(String) // {@link DescriptorListing#getSourceFiles() sourceFiles} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDescriptorListing builder
   */
  public static ImmutableDescriptorListing.Builder builder() {
    return new ImmutableDescriptorListing.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDescriptorListing ImmutableDescriptorListing}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DescriptorListing", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_DESCRIPTOR_FILE_PATH = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Path descriptorFilePath;
    private @Nullable List<String> sourceFiles = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DescriptorListing} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DescriptorListing instance) {
      Objects.requireNonNull(instance, "instance");
      Path descriptorFilePathValue = instance.getDescriptorFilePath();
      if (descriptorFilePathValue != null) {
        descriptorFilePath(descriptorFilePathValue);
      }
      addAllSourceFiles(instance.getSourceFiles());
      return this;
    }

    /**
     * Initializes the value for the {@link DescriptorListing#getDescriptorFilePath() descriptorFilePath} attribute.
     * @param descriptorFilePath The value for descriptorFilePath (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descriptorFilePath(Path descriptorFilePath) {
      this.descriptorFilePath = descriptorFilePath;
      initBits &= ~INIT_BIT_DESCRIPTOR_FILE_PATH;
      return this;
    }

    /**
     * Adds one element to {@link DescriptorListing#getSourceFiles() sourceFiles} set.
     * @param element A sourceFiles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceFiles(@Nullable String element) {
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<String>();
      }
      this.sourceFiles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DescriptorListing#getSourceFiles() sourceFiles} set.
     * @param elements An array of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceFiles(@Nullable String... elements) {
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<String>();
      }
      for (String element : elements) {
        this.sourceFiles.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DescriptorListing#getSourceFiles() sourceFiles} set.
     * @param elements An iterable of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sourceFiles(Iterable<@Nullable String> elements) {
      this.sourceFiles = new ArrayList<String>();
      return addAllSourceFiles(elements);
    }

    /**
     * Adds elements to {@link DescriptorListing#getSourceFiles() sourceFiles} set.
     * @param elements An iterable of sourceFiles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSourceFiles(Iterable<@Nullable String> elements) {
      Objects.requireNonNull(elements, "sourceFiles element");
      if (this.sourceFiles == null) {
        this.sourceFiles = new ArrayList<String>();
      }
      for (String element : elements) {
        this.sourceFiles.add(element);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDescriptorListing ImmutableDescriptorListing}.
     * @return An immutable instance of DescriptorListing
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDescriptorListing build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDescriptorListing(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DESCRIPTOR_FILE_PATH) != 0) attributes.add("descriptorFilePath");
      return "Cannot build DescriptorListing, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
