/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.fs;

import io.github.ascopes.protobufmavenplugin.fs.AbstractTemporaryLocationProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.Description;

@Description(value="Manages build-scoped reusable temporary directories for processing")
@MojoExecutionScoped
@Named
public final class TemporarySpace
extends AbstractTemporaryLocationProvider {
    private final MavenProject mavenProject;

    @Inject
    public TemporarySpace(MavenProject mavenProject, MojoExecution mojoExecution) {
        super(mojoExecution);
        this.mavenProject = mavenProject;
    }

    public Path createTemporarySpace(String ... bits) {
        try {
            Path baseDir = Path.of(this.mavenProject.getBuild().getDirectory(), new String[0]);
            return this.resolveAndCreateDirectory(baseDir, bits);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to create temporary location!", ex);
        }
    }
}

