/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * A modifiable implementation of the {@link MavenDependency MavenDependency} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * <p><em>MavenDependencyBean is not thread-safe</em>
 * @see ImmutableMavenDependency
 */
@Generated(from = "MavenDependency", generator = "Modifiables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated({"Modifiables.generator", "MavenDependency"})
public class MavenDependencyBean
    extends MavenDependency {
  private static final long INIT_BIT_GROUP_ID = 0x1L;
  private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
  private long initBits = 0x3L;

  private String groupId;
  private String artifactId;
  private @Nullable String version;
  private @Nullable String type;
  private @Nullable String classifier;
  private @Nullable DependencyResolutionDepth dependencyResolutionDepth;
  private Set<MavenExclusionBean> exclusions = null;

  /**
   * @return value of {@code groupId} attribute, may be {@code null}
   */
  @Override
  public String getGroupId() {
    if (!groupIdIsSet()) checkRequiredAttributes();
    return groupId;
  }

  /**
   * @return value of {@code artifactId} attribute, may be {@code null}
   */
  @Override
  public String getArtifactId() {
    if (!artifactIdIsSet()) checkRequiredAttributes();
    return artifactId;
  }

  /**
   * @return value of {@code version} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * @return value of {@code type} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return value of {@code classifier} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getClassifier() {
    return classifier;
  }

  /**
   * @return value of {@code dependencyResolutionDepth} attribute, may be {@code null}
   */
  @Override
  public @Nullable DependencyResolutionDepth getDependencyResolutionDepth() {
    return dependencyResolutionDepth;
  }

  /**
   * @return modifiable set {@code exclusions}
   */
  @Override
  public Set<MavenExclusionBean> getExclusions() {
    if (exclusions == null) {
      exclusions = new LinkedHashSet<MavenExclusionBean>(0);
    }
    return exclusions;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x3L;
    groupId = null;
    artifactId = null;
    version = null;
    type = null;
    classifier = null;
    dependencyResolutionDepth = null;
    if (exclusions != null) {
      exclusions.clear();
    }
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact} instance.
   * @param instance The instance from which to copy values
   */
  public MavenDependencyBean from(MavenArtifact instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.dependencies.MavenDependency} instance.
   * @param instance The instance from which to copy values
   */
  public MavenDependencyBean from(MavenDependency instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link MavenDependency} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public MavenDependencyBean from(MavenDependencyBean instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof MavenDependencyBean) {
      MavenDependencyBean instance = (MavenDependencyBean) object;
      if (instance.groupIdIsSet()) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          setGroupId(groupIdValue);
        }
      }
      if (instance.artifactIdIsSet()) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          setArtifactId(artifactIdValue);
        }
      }
      @Nullable String versionValue = instance.getVersion();
      if (versionValue != null) {
        setVersion(versionValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        setType(typeValue);
      }
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        setClassifier(classifierValue);
      }
      @Nullable DependencyResolutionDepth dependencyResolutionDepthValue = instance.getDependencyResolutionDepth();
      if (dependencyResolutionDepthValue != null) {
        setDependencyResolutionDepth(dependencyResolutionDepthValue);
      }
      addAllExclusions(instance.getExclusions());
      return;
    }
    if (object instanceof MavenArtifact) {
      MavenArtifact instance = (MavenArtifact) object;
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        setClassifier(classifierValue);
      }
      String artifactIdValue = instance.getArtifactId();
      if (artifactIdValue != null) {
        setArtifactId(artifactIdValue);
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        setType(typeValue);
      }
      @Nullable String versionValue = instance.getVersion();
      if (versionValue != null) {
        setVersion(versionValue);
      }
      String groupIdValue = instance.getGroupId();
      if (groupIdValue != null) {
        setGroupId(groupIdValue);
      }
    }
    if (object instanceof MavenDependency) {
      MavenDependency instance = (MavenDependency) object;
      @Nullable DependencyResolutionDepth dependencyResolutionDepthValue = instance.getDependencyResolutionDepth();
      if (dependencyResolutionDepthValue != null) {
        setDependencyResolutionDepth(dependencyResolutionDepthValue);
      }
      addAllExclusions(instance.getExclusions());
    }
  }

  /**
   * Assigns a value to the {@link MavenDependency#getGroupId() groupId} attribute.
   * @param groupId The value for groupId, can be {@code null}
   */
  public void setGroupId(String groupId) {
    this.groupId = groupId;
    initBits &= ~INIT_BIT_GROUP_ID;
    return;
  }

  /**
   * Assigns a value to the {@link MavenDependency#getArtifactId() artifactId} attribute.
   * @param artifactId The value for artifactId, can be {@code null}
   */
  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
    initBits &= ~INIT_BIT_ARTIFACT_ID;
    return;
  }

  /**
   * Assigns a value to the {@link MavenDependency#getVersion() version} attribute.
   * @param version The value for version, can be {@code null}
   */
  public void setVersion(@Nullable String version) {
    this.version = version;
    return;
  }

  /**
   * Assigns a value to the {@link MavenDependency#getType() type} attribute.
   * @param type The value for type, can be {@code null}
   */
  public void setType(@Nullable String type) {
    this.type = type;
    return;
  }

  /**
   * Assigns a value to the {@link MavenDependency#getClassifier() classifier} attribute.
   * @param classifier The value for classifier, can be {@code null}
   */
  public void setClassifier(@Nullable String classifier) {
    this.classifier = classifier;
    return;
  }

  /**
   * Assigns a value to the {@link MavenDependency#getDependencyResolutionDepth() dependencyResolutionDepth} attribute.
   * @param dependencyResolutionDepth The value for dependencyResolutionDepth, can be {@code null}
   */
  public void setDependencyResolutionDepth(@Nullable DependencyResolutionDepth dependencyResolutionDepth) {
    this.dependencyResolutionDepth = dependencyResolutionDepth;
    return;
  }

  /**
   * Adds one element to {@link MavenDependency#getExclusions() exclusions} set.
   * @param element The exclusions element
   */
  public void addExclusions(MavenExclusionBean element) {
    if (this.exclusions == null) {
      this.exclusions = new LinkedHashSet<MavenExclusionBean>();
    }
    this.exclusions.add(element);
    return;
  }

  /**
   * Adds elements to {@link MavenDependency#getExclusions() exclusions} set.
   * @param elements An array of exclusions elements
   */
  public final void addExclusions(@Nullable MavenExclusionBean... elements) {
    for (MavenExclusionBean e : elements) {
      addExclusions(e);
    }
    return;
  }

  /**
   * Sets or replaces all elements for {@link MavenDependency#getExclusions() exclusions} set.
   * @param elements An iterable of exclusions elements
   */
  public void setExclusions(Set<MavenExclusionBean> elements) {
    this.exclusions = Objects.requireNonNull(elements, "elements");
    return;
  }

  /**
   * Adds elements to {@link MavenDependency#getExclusions() exclusions} set.
   * @param elements An iterable of exclusions elements
   */
  public void addAllExclusions(Iterable<? extends @Nullable MavenExclusionBean> elements) {
    if (elements == null) return;
    if (this.exclusions == null) {
      this.exclusions = new LinkedHashSet<MavenExclusionBean>();
    }
    for (MavenExclusionBean e : elements) {
      addExclusions(e);
    }
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@link MavenDependency#getGroupId() groupId} is set.
   * @return {@code true} if set
   */
  public final boolean groupIdIsSet() {
    return (initBits & INIT_BIT_GROUP_ID) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link MavenDependency#getArtifactId() artifactId} is set.
   * @return {@code true} if set
   */
  public final boolean artifactIdIsSet() {
    return (initBits & INIT_BIT_ARTIFACT_ID) == 0;
  }

  /**
   * Returns {@code true} if the {@link MavenDependency#getExclusions() exclusions} has not been initialized
   * and will default to an empty set.
   * @return {@code true} if set
   */
  public final boolean exclusionsIsSet() {
    return exclusions != null;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetGroupId() {
    initBits |= INIT_BIT_GROUP_ID;
    groupId = null;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetArtifactId() {
    initBits |= INIT_BIT_ARTIFACT_ID;
    artifactId = null;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!groupIdIsSet()) attributes.add("groupId");
    if (!artifactIdIsSet()) attributes.add("artifactId");
    return "MavenDependency is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableMavenDependency ImmutableMavenDependency}.
   * @return An immutable instance of MavenDependency
   */
  public final ImmutableMavenDependency toImmutable() {
    checkRequiredAttributes();
    return ImmutableMavenDependency.builder()
        .from(this)
        .build();
  }

  /**
   * This instance is equal to all instances of {@code MavenDependencyBean} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof MavenDependencyBean)) return false;
    MavenDependencyBean other = (MavenDependencyBean) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(MavenDependencyBean another) {
    Set<MavenExclusionBean> exclusions = this.exclusions != null
        ? this.exclusions
        : Collections.<MavenExclusionBean>emptySet();
    return Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && Objects.equals(version, another.version)
        && Objects.equals(type, another.type)
        && Objects.equals(classifier, another.classifier)
        && Objects.equals(dependencyResolutionDepth, another.dependencyResolutionDepth)
        && exclusions.equals(another.getExclusions());
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code version}, {@code type}, {@code classifier}, {@code dependencyResolutionDepth}, {@code exclusions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    h += (h << 5) + Objects.hashCode(version);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(classifier);
    h += (h << 5) + Objects.hashCode(dependencyResolutionDepth);
    h += (h << 5) + (exclusions == null ? 0 : exclusions.hashCode());
    return h;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
