/*
 * Copyright (C) 2023 - 2025, Ashley Scopes.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link BinaryMavenProtocPlugin}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBinaryMavenProtocPlugin.builder()}.
 */
@Generated(from = "BinaryMavenProtocPlugin", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableBinaryMavenProtocPlugin
    extends BinaryMavenProtocPlugin {
  private final @Nullable String options;
  private final @Nullable Path outputDirectory;
  private final @Nullable Boolean registerAsCompilationRoot;
  private final int order;
  private final boolean skip;
  private final @Nullable String groupId;
  private final @Nullable String artifactId;
  private final @Nullable String type;
  private final @Nullable String classifier;
  private final @NonNull @Nullable String version;

  private ImmutableBinaryMavenProtocPlugin(ImmutableBinaryMavenProtocPlugin.Builder builder) {
    this.options = builder.options;
    this.outputDirectory = builder.outputDirectory;
    this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
    this.groupId = builder.groupId;
    this.artifactId = builder.artifactId;
    this.type = builder.type;
    this.classifier = builder.classifier;
    this.version = builder.version;
    if (builder.orderIsSet()) {
      initShim.order(builder.order);
    }
    if (builder.skipIsSet()) {
      initShim.skip(builder.skip);
    }
    this.order = initShim.getOrder();
    this.skip = initShim.isSkip();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "BinaryMavenProtocPlugin", generator = "Immutables")
  private final class InitShim {
    private byte orderBuildStage = STAGE_UNINITIALIZED;
    private int order;

    int getOrder() {
      if (orderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (orderBuildStage == STAGE_UNINITIALIZED) {
        orderBuildStage = STAGE_INITIALIZING;
        int computedValue = ImmutableBinaryMavenProtocPlugin.super.getOrder();
        this.order = computedValue;
        orderBuildStage = STAGE_INITIALIZED;
      }
      return this.order;
    }

    void order(int order) {
      this.order = order;
      orderBuildStage = STAGE_INITIALIZED;
    }

    private byte skipBuildStage = STAGE_UNINITIALIZED;
    private boolean skip;

    boolean isSkip() {
      if (skipBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (skipBuildStage == STAGE_UNINITIALIZED) {
        skipBuildStage = STAGE_INITIALIZING;
        boolean computedValue = ImmutableBinaryMavenProtocPlugin.super.isSkip();
        this.skip = computedValue;
        skipBuildStage = STAGE_INITIALIZED;
      }
      return this.skip;
    }

    void skip(boolean skip) {
      this.skip = skip;
      skipBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (orderBuildStage == STAGE_INITIALIZING) attributes.add("order");
      if (skipBuildStage == STAGE_INITIALIZING) attributes.add("skip");
      return "Cannot build BinaryMavenProtocPlugin, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @Override
  public @Nullable String getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code outputDirectory} attribute
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return The value of the {@code registerAsCompilationRoot} attribute
   */
  @Override
  public @Nullable Boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrder()
        : this.order;
  }

  /**
   * @return The value of the {@code skip} attribute
   */
  @Override
  public boolean isSkip() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isSkip()
        : this.skip;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @Override
  public @Nullable String getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code artifactId} attribute
   */
  @Override
  public @Nullable String getArtifactId() {
    return artifactId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code classifier} attribute
   */
  @Override
  public @Nullable String getClassifier() {
    return classifier;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @Override
  public @NonNull @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBinaryMavenProtocPlugin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBinaryMavenProtocPlugin
        && equalsByValue((ImmutableBinaryMavenProtocPlugin) another);
  }

  private boolean equalsByValue(ImmutableBinaryMavenProtocPlugin another) {
    return Objects.equals(options, another.options)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && order == another.order
        && skip == another.skip
        && Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && Objects.equals(type, another.type)
        && Objects.equals(classifier, another.classifier)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code options}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code order}, {@code skip}, {@code groupId}, {@code artifactId}, {@code type}, {@code classifier}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    h += (h << 5) + order;
    h += (h << 5) + Boolean.hashCode(skip);
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(classifier);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Creates a builder for {@link ImmutableBinaryMavenProtocPlugin ImmutableBinaryMavenProtocPlugin}.
   * <pre>
   * ImmutableBinaryMavenProtocPlugin.builder()
   *    .options(String | null) // nullable {@link BinaryMavenProtocPlugin#getOptions() options}
   *    .outputDirectory(java.nio.file.Path | null) // nullable {@link BinaryMavenProtocPlugin#getOutputDirectory() outputDirectory}
   *    .registerAsCompilationRoot(Boolean | null) // nullable {@link BinaryMavenProtocPlugin#isRegisterAsCompilationRoot() registerAsCompilationRoot}
   *    .order(int) // optional {@link BinaryMavenProtocPlugin#getOrder() order}
   *    .skip(boolean) // optional {@link BinaryMavenProtocPlugin#isSkip() skip}
   *    .groupId(String | null) // nullable {@link BinaryMavenProtocPlugin#getGroupId() groupId}
   *    .artifactId(String | null) // nullable {@link BinaryMavenProtocPlugin#getArtifactId() artifactId}
   *    .type(String | null) // nullable {@link BinaryMavenProtocPlugin#getType() type}
   *    .classifier(String | null) // nullable {@link BinaryMavenProtocPlugin#getClassifier() classifier}
   *    .version(String | null) // nullable {@link BinaryMavenProtocPlugin#getVersion() version}
   *    .build();
   * </pre>
   * @return A new ImmutableBinaryMavenProtocPlugin builder
   */
  public static ImmutableBinaryMavenProtocPlugin.Builder builder() {
    return new ImmutableBinaryMavenProtocPlugin.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBinaryMavenProtocPlugin ImmutableBinaryMavenProtocPlugin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BinaryMavenProtocPlugin", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private static final long INIT_BIT_VERSION = 0x4L;
    private static final long OPT_BIT_ORDER = 0x1L;
    private static final long OPT_BIT_SKIP = 0x2L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable String options;
    private @Nullable Path outputDirectory;
    private @Nullable Boolean registerAsCompilationRoot;
    private int order;
    private boolean skip;
    private @Nullable String groupId;
    private @Nullable String artifactId;
    private @Nullable String type;
    private @Nullable String classifier;
    private @NonNull @Nullable String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BinaryMavenProtocPluginBean} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BinaryMavenProtocPluginBean instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String optionsValue = instance.getOptions();
      if (optionsValue != null) {
        options(optionsValue);
      }
      @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        outputDirectory(outputDirectoryValue);
      }
      @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
      if (registerAsCompilationRootValue != null) {
        registerAsCompilationRoot(registerAsCompilationRootValue);
      }
      this.order(instance.getOrder());
      this.skip(instance.isSkip());
      if (instance.groupIdIsSet()) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          groupId(groupIdValue);
        }
      }
      if (instance.artifactIdIsSet()) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          artifactId(artifactIdValue);
        }
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        classifier(classifierValue);
      }
      if (instance.versionIsSet()) {
        @NonNull String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MavenArtifact instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProtocPlugin instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.github.ascopes.protobufmavenplugin.plugins.BinaryMavenProtocPlugin} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BinaryMavenProtocPlugin instance) {
      Objects.requireNonNull(instance, "instance");
      mergeInternal(instance);
      return this;
    }

    private void mergeInternal(Object object) {
      if (object instanceof BinaryMavenProtocPluginBean) {
        from((BinaryMavenProtocPluginBean) object);
        return;
      }
      long bits = 0;
      if (object instanceof MavenArtifact) {
        MavenArtifact instance = (MavenArtifact) object;
        if ((bits & 0x8L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x40L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          @NonNull String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x2L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof ProtocPlugin) {
        ProtocPlugin instance = (ProtocPlugin) object;
        if ((bits & 0x4L) == 0) {
          @Nullable String optionsValue = instance.getOptions();
          if (optionsValue != null) {
            options(optionsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
          if (outputDirectoryValue != null) {
            outputDirectory(outputDirectoryValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.skip(instance.isSkip());
          bits |= 0x20L;
        }
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
          if (registerAsCompilationRootValue != null) {
            registerAsCompilationRoot(registerAsCompilationRootValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x200L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x200L;
        }
      }
      if (object instanceof BinaryMavenProtocPlugin) {
        BinaryMavenProtocPlugin instance = (BinaryMavenProtocPlugin) object;
        if ((bits & 0x1L) == 0) {
          @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
          if (registerAsCompilationRootValue != null) {
            registerAsCompilationRoot(registerAsCompilationRootValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String groupIdValue = instance.getGroupId();
          if (groupIdValue != null) {
            groupId(groupIdValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          @Nullable String optionsValue = instance.getOptions();
          if (optionsValue != null) {
            options(optionsValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          @Nullable String classifierValue = instance.getClassifier();
          if (classifierValue != null) {
            classifier(classifierValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
          if (outputDirectoryValue != null) {
            outputDirectory(outputDirectoryValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          this.skip(instance.isSkip());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          String artifactIdValue = instance.getArtifactId();
          if (artifactIdValue != null) {
            artifactId(artifactIdValue);
          }
          bits |= 0x40L;
        }
        if ((bits & 0x80L) == 0) {
          @Nullable String typeValue = instance.getType();
          if (typeValue != null) {
            type(typeValue);
          }
          bits |= 0x80L;
        }
        if ((bits & 0x100L) == 0) {
          @NonNull String versionValue = instance.getVersion();
          if (versionValue != null) {
            version(versionValue);
          }
          bits |= 0x100L;
        }
        if ((bits & 0x200L) == 0) {
          this.order(instance.getOrder());
          bits |= 0x200L;
        }
      }
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getOptions() options} attribute.
     * @param options The value for options (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder options(@Nullable String options) {
      this.options = options;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getOutputDirectory() outputDirectory} attribute.
     * @param outputDirectory The value for outputDirectory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDirectory(@Nullable Path outputDirectory) {
      this.outputDirectory = outputDirectory;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#isRegisterAsCompilationRoot() registerAsCompilationRoot} attribute.
     * @param registerAsCompilationRoot The value for registerAsCompilationRoot (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder registerAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
      this.registerAsCompilationRoot = registerAsCompilationRoot;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getOrder() order} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BinaryMavenProtocPlugin#getOrder() order}.</em>
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      optBits |= OPT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#isSkip() skip} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BinaryMavenProtocPlugin#isSkip() skip}.</em>
     * @param skip The value for skip 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skip(boolean skip) {
      this.skip = skip;
      optBits |= OPT_BIT_SKIP;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getGroupId() groupId} attribute.
     * @param groupId The value for groupId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = groupId;
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder artifactId(String artifactId) {
      this.artifactId = artifactId;
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getClassifier() classifier} attribute.
     * @param classifier The value for classifier (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder classifier(@Nullable String classifier) {
      this.classifier = classifier;
      return this;
    }

    /**
     * Initializes the value for the {@link BinaryMavenProtocPlugin#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@NonNull String version) {
      this.version = version;
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBinaryMavenProtocPlugin ImmutableBinaryMavenProtocPlugin}.
     * @return An immutable instance of BinaryMavenProtocPlugin
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBinaryMavenProtocPlugin build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBinaryMavenProtocPlugin(this);
    }

    private boolean orderIsSet() {
      return (optBits & OPT_BIT_ORDER) != 0;
    }

    private boolean skipIsSet() {
      return (optBits & OPT_BIT_SKIP) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build BinaryMavenProtocPlugin, some of required attributes are not set " + attributes;
    }
  }
}
