/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

/**
 * A modifiable implementation of the {@link BinaryMavenProtocPlugin BinaryMavenProtocPlugin} type.
 * <p>Use the constructor to create new modifiable instances. You may even extend this class to
 * add some convenience methods, however most of the methods in this class are final
 * to preserve safety and predictable invariants.
 * <p><em>BinaryMavenProtocPluginBean is not thread-safe</em>
 * @see ImmutableBinaryMavenProtocPlugin
 */
@Generated(from = "BinaryMavenProtocPlugin", generator = "Modifiables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated({"Modifiables.generator", "BinaryMavenProtocPlugin"})
public class BinaryMavenProtocPluginBean
    extends BinaryMavenProtocPlugin {
  private static final long INIT_BIT_GROUP_ID = 0x1L;
  private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
  private static final long INIT_BIT_VERSION = 0x4L;
  private static final long OPT_BIT_ORDER = 0x1L;
  private static final long OPT_BIT_SKIP = 0x2L;
  private long initBits = 0x7L;
  private long optBits;

  private @Nullable String options;
  private @Nullable Path outputDirectory;
  private @Nullable Boolean registerAsCompilationRoot;
  private int order;
  private boolean skip;
  private String groupId;
  private String artifactId;
  private @Nullable String type;
  private @Nullable String classifier;
  private @NonNull String version;

  /**
   * @return value of {@code options} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getOptions() {
    return options;
  }

  /**
   * @return value of {@code outputDirectory} attribute, may be {@code null}
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return value of {@code registerAsCompilationRoot} attribute, may be {@code null}
   */
  @Override
  public @Nullable Boolean isRegisterAsCompilationRoot() {
    return registerAsCompilationRoot;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code order} attribute
   */
  @Override
  public int getOrder() {
    if (orderIsSet()) {
      return order;
    } else {
      return super.getOrder();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code skip} attribute
   */
  @Override
  public boolean isSkip() {
    if (skipIsSet()) {
      return skip;
    } else {
      return super.isSkip();
    }
  }

  /**
   * @return value of {@code groupId} attribute, may be {@code null}
   */
  @Override
  public String getGroupId() {
    if (!groupIdIsSet()) checkRequiredAttributes();
    return groupId;
  }

  /**
   * @return value of {@code artifactId} attribute, may be {@code null}
   */
  @Override
  public String getArtifactId() {
    if (!artifactIdIsSet()) checkRequiredAttributes();
    return artifactId;
  }

  /**
   * @return value of {@code type} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return value of {@code classifier} attribute, may be {@code null}
   */
  @Override
  public @Nullable String getClassifier() {
    return classifier;
  }

  /**
   * @return value of {@code version} attribute, may be {@code null}
   */
  @Override
  public @NonNull String getVersion() {
    if (!versionIsSet()) checkRequiredAttributes();
    return version;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   */
  public void clear() {
    initBits = 0x7L;
    optBits = 0;
    options = null;
    outputDirectory = null;
    registerAsCompilationRoot = null;
    order = 0;
    skip = false;
    groupId = null;
    artifactId = null;
    type = null;
    classifier = null;
    version = null;
    return;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact} instance.
   * @param instance The instance from which to copy values
   */
  public BinaryMavenProtocPluginBean from(MavenArtifact instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.ProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public BinaryMavenProtocPluginBean from(ProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link io.github.ascopes.protobufmavenplugin.plugins.BinaryMavenProtocPlugin} instance.
   * @param instance The instance from which to copy values
   */
  public BinaryMavenProtocPluginBean from(BinaryMavenProtocPlugin instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link BinaryMavenProtocPlugin} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public BinaryMavenProtocPluginBean from(BinaryMavenProtocPluginBean instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof BinaryMavenProtocPluginBean) {
      BinaryMavenProtocPluginBean instance = (BinaryMavenProtocPluginBean) object;
      @Nullable String optionsValue = instance.getOptions();
      if (optionsValue != null) {
        setOptions(optionsValue);
      }
      @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        setOutputDirectory(outputDirectoryValue);
      }
      @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
      if (registerAsCompilationRootValue != null) {
        setRegisterAsCompilationRoot(registerAsCompilationRootValue);
      }
      setOrder(instance.getOrder());
      setSkip(instance.isSkip());
      if (instance.groupIdIsSet()) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          setGroupId(groupIdValue);
        }
      }
      if (instance.artifactIdIsSet()) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          setArtifactId(artifactIdValue);
        }
      }
      @Nullable String typeValue = instance.getType();
      if (typeValue != null) {
        setType(typeValue);
      }
      @Nullable String classifierValue = instance.getClassifier();
      if (classifierValue != null) {
        setClassifier(classifierValue);
      }
      if (instance.versionIsSet()) {
        @NonNull String versionValue = instance.getVersion();
        if (versionValue != null) {
          setVersion(versionValue);
        }
      }
      return;
    }
    long bits = 0;
    if (object instanceof MavenArtifact) {
      MavenArtifact instance = (MavenArtifact) object;
      if ((bits & 0x8L) == 0) {
        @Nullable String classifierValue = instance.getClassifier();
        if (classifierValue != null) {
          setClassifier(classifierValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x40L) == 0) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          setArtifactId(artifactIdValue);
        }
        bits |= 0x40L;
      }
      if ((bits & 0x80L) == 0) {
        @Nullable String typeValue = instance.getType();
        if (typeValue != null) {
          setType(typeValue);
        }
        bits |= 0x80L;
      }
      if ((bits & 0x100L) == 0) {
        @NonNull String versionValue = instance.getVersion();
        if (versionValue != null) {
          setVersion(versionValue);
        }
        bits |= 0x100L;
      }
      if ((bits & 0x2L) == 0) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          setGroupId(groupIdValue);
        }
        bits |= 0x2L;
      }
    }
    if (object instanceof ProtocPlugin) {
      ProtocPlugin instance = (ProtocPlugin) object;
      if ((bits & 0x4L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x10L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x10L;
      }
      if ((bits & 0x20L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x20L;
      }
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x200L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x200L;
      }
    }
    if (object instanceof BinaryMavenProtocPlugin) {
      BinaryMavenProtocPlugin instance = (BinaryMavenProtocPlugin) object;
      if ((bits & 0x1L) == 0) {
        @Nullable Boolean registerAsCompilationRootValue = instance.isRegisterAsCompilationRoot();
        if (registerAsCompilationRootValue != null) {
          setRegisterAsCompilationRoot(registerAsCompilationRootValue);
        }
        bits |= 0x1L;
      }
      if ((bits & 0x2L) == 0) {
        String groupIdValue = instance.getGroupId();
        if (groupIdValue != null) {
          setGroupId(groupIdValue);
        }
        bits |= 0x2L;
      }
      if ((bits & 0x4L) == 0) {
        @Nullable String optionsValue = instance.getOptions();
        if (optionsValue != null) {
          setOptions(optionsValue);
        }
        bits |= 0x4L;
      }
      if ((bits & 0x8L) == 0) {
        @Nullable String classifierValue = instance.getClassifier();
        if (classifierValue != null) {
          setClassifier(classifierValue);
        }
        bits |= 0x8L;
      }
      if ((bits & 0x10L) == 0) {
        @Nullable Path outputDirectoryValue = instance.getOutputDirectory();
        if (outputDirectoryValue != null) {
          setOutputDirectory(outputDirectoryValue);
        }
        bits |= 0x10L;
      }
      if ((bits & 0x20L) == 0) {
        setSkip(instance.isSkip());
        bits |= 0x20L;
      }
      if ((bits & 0x40L) == 0) {
        String artifactIdValue = instance.getArtifactId();
        if (artifactIdValue != null) {
          setArtifactId(artifactIdValue);
        }
        bits |= 0x40L;
      }
      if ((bits & 0x80L) == 0) {
        @Nullable String typeValue = instance.getType();
        if (typeValue != null) {
          setType(typeValue);
        }
        bits |= 0x80L;
      }
      if ((bits & 0x100L) == 0) {
        @NonNull String versionValue = instance.getVersion();
        if (versionValue != null) {
          setVersion(versionValue);
        }
        bits |= 0x100L;
      }
      if ((bits & 0x200L) == 0) {
        setOrder(instance.getOrder());
        bits |= 0x200L;
      }
    }
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getOptions() options} attribute.
   * @param options The value for options, can be {@code null}
   */
  public void setOptions(@Nullable String options) {
    this.options = options;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getOutputDirectory() outputDirectory} attribute.
   * @param outputDirectory The value for outputDirectory, can be {@code null}
   */
  public void setOutputDirectory(@Nullable Path outputDirectory) {
    this.outputDirectory = outputDirectory;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#isRegisterAsCompilationRoot() registerAsCompilationRoot} attribute.
   * @param registerAsCompilationRoot The value for registerAsCompilationRoot, can be {@code null}
   */
  public void setRegisterAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
    this.registerAsCompilationRoot = registerAsCompilationRoot;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getOrder() order} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link BinaryMavenProtocPlugin#getOrder() order}.</em>
   * @param order The value for order
   */
  public void setOrder(int order) {
    this.order = order;
    optBits |= OPT_BIT_ORDER;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#isSkip() skip} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link BinaryMavenProtocPlugin#isSkip() skip}.</em>
   * @param skip The value for skip
   */
  public void setSkip(boolean skip) {
    this.skip = skip;
    optBits |= OPT_BIT_SKIP;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getGroupId() groupId} attribute.
   * @param groupId The value for groupId, can be {@code null}
   */
  public void setGroupId(String groupId) {
    this.groupId = groupId;
    initBits &= ~INIT_BIT_GROUP_ID;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getArtifactId() artifactId} attribute.
   * @param artifactId The value for artifactId, can be {@code null}
   */
  public void setArtifactId(String artifactId) {
    this.artifactId = artifactId;
    initBits &= ~INIT_BIT_ARTIFACT_ID;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getType() type} attribute.
   * @param type The value for type, can be {@code null}
   */
  public void setType(@Nullable String type) {
    this.type = type;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getClassifier() classifier} attribute.
   * @param classifier The value for classifier, can be {@code null}
   */
  public void setClassifier(@Nullable String classifier) {
    this.classifier = classifier;
    return;
  }

  /**
   * Assigns a value to the {@link BinaryMavenProtocPlugin#getVersion() version} attribute.
   * @param version The value for version, can be {@code null}
   */
  public void setVersion(@NonNull String version) {
    this.version = version;
    initBits &= ~INIT_BIT_VERSION;
    return;
  }

  /**
   * Returns {@code true} if the required attribute {@link BinaryMavenProtocPlugin#getGroupId() groupId} is set.
   * @return {@code true} if set
   */
  public final boolean groupIdIsSet() {
    return (initBits & INIT_BIT_GROUP_ID) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link BinaryMavenProtocPlugin#getArtifactId() artifactId} is set.
   * @return {@code true} if set
   */
  public final boolean artifactIdIsSet() {
    return (initBits & INIT_BIT_ARTIFACT_ID) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link BinaryMavenProtocPlugin#getVersion() version} is set.
   * @return {@code true} if set
   */
  public final boolean versionIsSet() {
    return (initBits & INIT_BIT_VERSION) == 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link BinaryMavenProtocPlugin#getOrder() order} is set.
   * @return {@code true} if set
   */
  public final boolean orderIsSet() {
    return (optBits & OPT_BIT_ORDER) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link BinaryMavenProtocPlugin#isSkip() skip} is set.
   * @return {@code true} if set
   */
  public final boolean skipIsSet() {
    return (optBits & OPT_BIT_SKIP) != 0;
  }


  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetGroupId() {
    initBits |= INIT_BIT_GROUP_ID;
    groupId = null;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetArtifactId() {
    initBits |= INIT_BIT_ARTIFACT_ID;
    artifactId = null;
    return;
  }

  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetVersion() {
    initBits |= INIT_BIT_VERSION;
    version = null;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetOrder() {
    optBits &= ~OPT_BIT_ORDER;
    order = 0;
    return;
  }
  /**
   * Reset an attribute to its initial value.
   */
  public final void unsetSkip() {
    optBits &= ~OPT_BIT_SKIP;
    skip = false;
    return;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!groupIdIsSet()) attributes.add("groupId");
    if (!artifactIdIsSet()) attributes.add("artifactId");
    if (!versionIsSet()) attributes.add("version");
    return "BinaryMavenProtocPlugin is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableBinaryMavenProtocPlugin ImmutableBinaryMavenProtocPlugin}.
   * @return An immutable instance of BinaryMavenProtocPlugin
   */
  public final ImmutableBinaryMavenProtocPlugin toImmutable() {
    checkRequiredAttributes();
    return ImmutableBinaryMavenProtocPlugin.builder()
        .from(this)
        .build();
  }

  /**
   * This instance is equal to all instances of {@code BinaryMavenProtocPluginBean} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof BinaryMavenProtocPluginBean)) return false;
    BinaryMavenProtocPluginBean other = (BinaryMavenProtocPluginBean) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(BinaryMavenProtocPluginBean another) {
    int order = getOrder();
    boolean skip = isSkip();
    return Objects.equals(options, another.options)
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && order == another.getOrder()
        && skip == another.isSkip()
        && Objects.equals(groupId, another.groupId)
        && Objects.equals(artifactId, another.artifactId)
        && Objects.equals(type, another.type)
        && Objects.equals(classifier, another.classifier)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code options}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code order}, {@code skip}, {@code groupId}, {@code artifactId}, {@code type}, {@code classifier}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    int order = getOrder();
    h += (h << 5) + order;
    boolean skip = isSkip();
    h += (h << 5) + Boolean.hashCode(skip);
    h += (h << 5) + Objects.hashCode(groupId);
    h += (h << 5) + Objects.hashCode(artifactId);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(classifier);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }
}
