/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

/**
 * Immutable implementation of {@link ResolvedProtocPlugin}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResolvedProtocPlugin.builder()}.
 */
@Generated(from = "ResolvedProtocPlugin", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableResolvedProtocPlugin
    implements ResolvedProtocPlugin {
  private final @Nullable String id;
  private final @Nullable String options;
  private final int order;
  private final @Nullable Path outputDirectory;
  private final @Nullable Boolean registerAsCompilationRoot;
  private final @Nullable Path path;

  private ImmutableResolvedProtocPlugin(ImmutableResolvedProtocPlugin.Builder builder) {
    this.id = builder.id;
    this.options = builder.options;
    this.order = builder.order;
    this.outputDirectory = builder.outputDirectory;
    this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
    this.path = builder.path;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @Override
  public Optional<String> getOptions() {
    return Optional.ofNullable(options);
  }

  /**
   * @return The value of the {@code order} attribute
   */
  @Override
  public int getOrder() {
    return order;
  }

  /**
   * @return The value of the {@code outputDirectory} attribute
   */
  @Override
  public @Nullable Path getOutputDirectory() {
    return outputDirectory;
  }

  /**
   * @return The value of the {@code registerAsCompilationRoot} attribute
   */
  @Override
  public Optional<Boolean> getRegisterAsCompilationRoot() {
    return Optional.ofNullable(registerAsCompilationRoot);
  }

  /**
   * @return The value of the {@code path} attribute
   */
  @Override
  public @Nullable Path getPath() {
    return path;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResolvedProtocPlugin} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResolvedProtocPlugin
        && equalsByValue((ImmutableResolvedProtocPlugin) another);
  }

  private boolean equalsByValue(ImmutableResolvedProtocPlugin another) {
    return Objects.equals(id, another.id)
        && Objects.equals(options, another.options)
        && order == another.order
        && Objects.equals(outputDirectory, another.outputDirectory)
        && Objects.equals(registerAsCompilationRoot, another.registerAsCompilationRoot)
        && Objects.equals(path, another.path);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code options}, {@code order}, {@code outputDirectory}, {@code registerAsCompilationRoot}, {@code path}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + order;
    h += (h << 5) + Objects.hashCode(outputDirectory);
    h += (h << 5) + Objects.hashCode(registerAsCompilationRoot);
    h += (h << 5) + Objects.hashCode(path);
    return h;
  }

  /**
   * Prints the immutable value {@code ResolvedProtocPlugin} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ResolvedProtocPlugin{");
    if (id != null) {
      builder.append("id=").append(id);
    }
    if (options != null) {
      if (builder.length() > 21) builder.append(", ");
      builder.append("options=").append(options);
    }
    if (builder.length() > 21) builder.append(", ");
    builder.append("order=").append(order);
    if (outputDirectory != null) {
      builder.append(", ");
      builder.append("outputDirectory=").append(outputDirectory);
    }
    if (registerAsCompilationRoot != null) {
      builder.append(", ");
      builder.append("registerAsCompilationRoot=").append(registerAsCompilationRoot);
    }
    if (path != null) {
      builder.append(", ");
      builder.append("path=").append(path);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link ImmutableResolvedProtocPlugin ImmutableResolvedProtocPlugin}.
   * <pre>
   * ImmutableResolvedProtocPlugin.builder()
   *    .id(String | null) // nullable {@link ResolvedProtocPlugin#getId() id}
   *    .options(Optional&lt;String&gt;) // optional {@link ResolvedProtocPlugin#getOptions() options}
   *    .order(int) // required {@link ResolvedProtocPlugin#getOrder() order}
   *    .outputDirectory(java.nio.file.Path | null) // nullable {@link ResolvedProtocPlugin#getOutputDirectory() outputDirectory}
   *    .registerAsCompilationRoot(Optional&lt;Boolean&gt;) // optional {@link ResolvedProtocPlugin#getRegisterAsCompilationRoot() registerAsCompilationRoot}
   *    .path(java.nio.file.Path | null) // nullable {@link ResolvedProtocPlugin#getPath() path}
   *    .build();
   * </pre>
   * @return A new ImmutableResolvedProtocPlugin builder
   */
  public static ImmutableResolvedProtocPlugin.Builder builder() {
    return new ImmutableResolvedProtocPlugin.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResolvedProtocPlugin ImmutableResolvedProtocPlugin}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ResolvedProtocPlugin", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_ORDER = 0x2L;
    private static final long INIT_BIT_OUTPUT_DIRECTORY = 0x4L;
    private static final long INIT_BIT_PATH = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String options;
    private int order;
    private @Nullable Path outputDirectory;
    private @Nullable Boolean registerAsCompilationRoot;
    private @Nullable Path path;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ResolvedProtocPlugin} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResolvedProtocPlugin instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Optional<String> optionsOptional = instance.getOptions();
      if (optionsOptional.isPresent()) {
        options(optionsOptional);
      }
      this.order(instance.getOrder());
      Path outputDirectoryValue = instance.getOutputDirectory();
      if (outputDirectoryValue != null) {
        outputDirectory(outputDirectoryValue);
      }
      Optional<Boolean> registerAsCompilationRootOptional = instance.getRegisterAsCompilationRoot();
      if (registerAsCompilationRootOptional.isPresent()) {
        registerAsCompilationRoot(registerAsCompilationRootOptional);
      }
      Path pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ResolvedProtocPlugin#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ResolvedProtocPlugin#getOptions() options} to options.
     * @param options The value for options, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder options(@Nullable String options) {
      this.options = options;
      return this;
    }

    /**
     * Initializes the optional value {@link ResolvedProtocPlugin#getOptions() options} to options.
     * @param options The value for options
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder options(Optional<String> options) {
      this.options = options.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ResolvedProtocPlugin#getOrder() order} attribute.
     * @param order The value for order 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder order(int order) {
      this.order = order;
      initBits &= ~INIT_BIT_ORDER;
      return this;
    }

    /**
     * Initializes the value for the {@link ResolvedProtocPlugin#getOutputDirectory() outputDirectory} attribute.
     * @param outputDirectory The value for outputDirectory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder outputDirectory(Path outputDirectory) {
      this.outputDirectory = outputDirectory;
      initBits &= ~INIT_BIT_OUTPUT_DIRECTORY;
      return this;
    }

    /**
     * Initializes the optional value {@link ResolvedProtocPlugin#getRegisterAsCompilationRoot() registerAsCompilationRoot} to registerAsCompilationRoot.
     * @param registerAsCompilationRoot The value for registerAsCompilationRoot, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder registerAsCompilationRoot(@Nullable Boolean registerAsCompilationRoot) {
      this.registerAsCompilationRoot = registerAsCompilationRoot;
      return this;
    }

    /**
     * Initializes the optional value {@link ResolvedProtocPlugin#getRegisterAsCompilationRoot() registerAsCompilationRoot} to registerAsCompilationRoot.
     * @param registerAsCompilationRoot The value for registerAsCompilationRoot
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder registerAsCompilationRoot(Optional<Boolean> registerAsCompilationRoot) {
      this.registerAsCompilationRoot = registerAsCompilationRoot.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ResolvedProtocPlugin#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder path(Path path) {
      this.path = path;
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResolvedProtocPlugin ImmutableResolvedProtocPlugin}.
     * @return An immutable instance of ResolvedProtocPlugin
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResolvedProtocPlugin build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableResolvedProtocPlugin(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ORDER) != 0) attributes.add("order");
      if ((initBits & INIT_BIT_OUTPUT_DIRECTORY) != 0) attributes.add("outputDirectory");
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      return "Cannot build ResolvedProtocPlugin, some of required attributes are not set " + attributes;
    }
  }
}
