/*
 * Copyright (C) 2023 Ashley Scopes
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import org.immutables.value.Value.Immutable;

/**
 * Listing for a descriptor file.
 *
 * @author Ashley Scopes
 */
@Immutable
public interface DescriptorListing {

  Path getDescriptorFilePath();

  Set<String> getSourceFiles();

  static Collection<String> flatten(Collection<? extends DescriptorListing> listings) {
    return listings.stream()
        .map(DescriptorListing::getSourceFiles)
        .flatMap(Collection::stream)
        .toList();
  }
}
