/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.protoc.ProtocInvocation;
import io.github.ascopes.protobufmavenplugin.protoc.targets.ProtocTarget;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@Generated(from="ProtocInvocation", generator="Immutables")
public final class ImmutableProtocInvocation
implements ProtocInvocation {
    private final @Nullable Path protocPath;
    private final boolean fatalWarnings;
    private final List<String> arguments;
    private final Map<String, String> environmentVariables;
    private final List<Path> importPaths;
    private final List<Path> inputDescriptorFiles;
    private final List<String> descriptorSourceFiles;
    private final List<Path> sourcePaths;
    private final @Nullable SortedSet<ProtocTarget> targets;
    private final @Nullable Path sanctionedExecutablePath;

    private ImmutableProtocInvocation(Builder builder) {
        this.protocPath = builder.protocPath;
        this.fatalWarnings = builder.fatalWarnings;
        this.arguments = builder.arguments == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.arguments);
        this.environmentVariables = builder.environmentVariables == null ? Collections.emptyMap() : ImmutableProtocInvocation.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.importPaths = builder.importPaths == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.importPaths);
        this.inputDescriptorFiles = builder.inputDescriptorFiles == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.inputDescriptorFiles);
        this.descriptorSourceFiles = builder.descriptorSourceFiles == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.descriptorSourceFiles);
        this.sourcePaths = builder.sourcePaths == null ? Collections.emptyList() : ImmutableProtocInvocation.createUnmodifiableList(true, builder.sourcePaths);
        this.targets = builder.targets;
        this.sanctionedExecutablePath = builder.sanctionedExecutablePath;
    }

    @Override
    public @Nullable Path getProtocPath() {
        return this.protocPath;
    }

    @Override
    public boolean isFatalWarnings() {
        return this.fatalWarnings;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public List<Path> getImportPaths() {
        return this.importPaths;
    }

    @Override
    public List<Path> getInputDescriptorFiles() {
        return this.inputDescriptorFiles;
    }

    @Override
    public List<String> getDescriptorSourceFiles() {
        return this.descriptorSourceFiles;
    }

    @Override
    public List<Path> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public @Nullable SortedSet<ProtocTarget> getTargets() {
        return this.targets;
    }

    @Override
    public @Nullable Path getSanctionedExecutablePath() {
        return this.sanctionedExecutablePath;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProtocInvocation && this.equalsByValue((ImmutableProtocInvocation)another);
    }

    private boolean equalsByValue(ImmutableProtocInvocation another) {
        return Objects.equals(this.protocPath, another.protocPath) && this.fatalWarnings == another.fatalWarnings && this.arguments.equals(another.arguments) && this.environmentVariables.equals(another.environmentVariables) && this.importPaths.equals(another.importPaths) && this.inputDescriptorFiles.equals(another.inputDescriptorFiles) && this.descriptorSourceFiles.equals(another.descriptorSourceFiles) && this.sourcePaths.equals(another.sourcePaths) && Objects.equals(this.targets, another.targets) && Objects.equals(this.sanctionedExecutablePath, another.sanctionedExecutablePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.protocPath);
        h += (h << 5) + Boolean.hashCode(this.fatalWarnings);
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + this.environmentVariables.hashCode();
        h += (h << 5) + this.importPaths.hashCode();
        h += (h << 5) + this.inputDescriptorFiles.hashCode();
        h += (h << 5) + this.descriptorSourceFiles.hashCode();
        h += (h << 5) + this.sourcePaths.hashCode();
        h += (h << 5) + Objects.hashCode(this.targets);
        h += (h << 5) + Objects.hashCode(this.sanctionedExecutablePath);
        return h;
    }

    public String toString() {
        return "ProtocInvocation{protocPath=" + String.valueOf(this.protocPath) + ", fatalWarnings=" + this.fatalWarnings + ", arguments=" + String.valueOf(this.arguments) + ", environmentVariables=" + String.valueOf(this.environmentVariables) + ", importPaths=" + String.valueOf(this.importPaths) + ", inputDescriptorFiles=" + String.valueOf(this.inputDescriptorFiles) + ", descriptorSourceFiles=" + String.valueOf(this.descriptorSourceFiles) + ", sourcePaths=" + String.valueOf(this.sourcePaths) + ", targets=" + String.valueOf(this.targets) + ", sanctionedExecutablePath=" + String.valueOf(this.sanctionedExecutablePath) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ProtocInvocation", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PROTOC_PATH = 1L;
        private static final long INIT_BIT_FATAL_WARNINGS = 2L;
        private static final long INIT_BIT_TARGETS = 4L;
        private long initBits = 7L;
        private @Nullable Path protocPath;
        private boolean fatalWarnings;
        private @Nullable List<String> arguments = null;
        private @Nullable Map<String, String> environmentVariables = null;
        private @Nullable List<Path> importPaths = null;
        private @Nullable List<Path> inputDescriptorFiles = null;
        private @Nullable List<String> descriptorSourceFiles = null;
        private @Nullable List<Path> sourcePaths = null;
        private @Nullable SortedSet<ProtocTarget> targets;
        private @Nullable Path sanctionedExecutablePath;

        private Builder() {
        }

        public final Builder from(ProtocInvocation instance) {
            Path sanctionedExecutablePathValue;
            Objects.requireNonNull(instance, "instance");
            Path protocPathValue = instance.getProtocPath();
            if (protocPathValue != null) {
                this.protocPath(protocPathValue);
            }
            this.fatalWarnings(instance.isFatalWarnings());
            this.addAllArguments(instance.getArguments());
            this.putAllEnvironmentVariables(instance.getEnvironmentVariables());
            this.addAllImportPaths(instance.getImportPaths());
            this.addAllInputDescriptorFiles(instance.getInputDescriptorFiles());
            this.addAllDescriptorSourceFiles(instance.getDescriptorSourceFiles());
            this.addAllSourcePaths(instance.getSourcePaths());
            SortedSet<ProtocTarget> targetsValue = instance.getTargets();
            if (targetsValue != null) {
                this.targets(targetsValue);
            }
            if ((sanctionedExecutablePathValue = instance.getSanctionedExecutablePath()) != null) {
                this.sanctionedExecutablePath(sanctionedExecutablePathValue);
            }
            return this;
        }

        public final Builder protocPath(Path protocPath) {
            this.protocPath = protocPath;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder fatalWarnings(boolean fatalWarnings) {
            this.fatalWarnings = fatalWarnings;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addArguments(@Nullable String element) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            this.arguments.add(element);
            return this;
        }

        public final Builder addArguments(String ... elements) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            for (String element : elements) {
                this.arguments.add(element);
            }
            return this;
        }

        public final Builder arguments(Iterable<@Nullable String> elements) {
            this.arguments = new ArrayList<String>();
            return this.addAllArguments(elements);
        }

        public final Builder addAllArguments(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "arguments element");
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            for (String element : elements) {
                this.arguments.add(element);
            }
            return this;
        }

        public final Builder putEnvironmentVariables(@Nullable String key, @Nullable String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder putEnvironmentVariables(Map.Entry<@Nullable String, ? extends @Nullable String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            @Nullable String v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(entries);
        }

        public final Builder putAllEnvironmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                @Nullable String v = e.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public final Builder addImportPaths(@Nullable Path element) {
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            this.importPaths.add(element);
            return this;
        }

        public final Builder addImportPaths(Path ... elements) {
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.importPaths.add(element);
            }
            return this;
        }

        public final Builder importPaths(Iterable<? extends @Nullable Path> elements) {
            this.importPaths = new ArrayList<Path>();
            return this.addAllImportPaths(elements);
        }

        public final Builder addAllImportPaths(Iterable<? extends @Nullable Path> elements) {
            Objects.requireNonNull(elements, "importPaths element");
            if (this.importPaths == null) {
                this.importPaths = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.importPaths.add(path);
            }
            return this;
        }

        public final Builder addInputDescriptorFiles(@Nullable Path element) {
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            this.inputDescriptorFiles.add(element);
            return this;
        }

        public final Builder addInputDescriptorFiles(Path ... elements) {
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.inputDescriptorFiles.add(element);
            }
            return this;
        }

        public final Builder inputDescriptorFiles(Iterable<? extends @Nullable Path> elements) {
            this.inputDescriptorFiles = new ArrayList<Path>();
            return this.addAllInputDescriptorFiles(elements);
        }

        public final Builder addAllInputDescriptorFiles(Iterable<? extends @Nullable Path> elements) {
            Objects.requireNonNull(elements, "inputDescriptorFiles element");
            if (this.inputDescriptorFiles == null) {
                this.inputDescriptorFiles = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.inputDescriptorFiles.add(path);
            }
            return this;
        }

        public final Builder addDescriptorSourceFiles(@Nullable String element) {
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            this.descriptorSourceFiles.add(element);
            return this;
        }

        public final Builder addDescriptorSourceFiles(String ... elements) {
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.descriptorSourceFiles.add(element);
            }
            return this;
        }

        public final Builder descriptorSourceFiles(Iterable<@Nullable String> elements) {
            this.descriptorSourceFiles = new ArrayList<String>();
            return this.addAllDescriptorSourceFiles(elements);
        }

        public final Builder addAllDescriptorSourceFiles(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "descriptorSourceFiles element");
            if (this.descriptorSourceFiles == null) {
                this.descriptorSourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.descriptorSourceFiles.add(element);
            }
            return this;
        }

        public final Builder addSourcePaths(@Nullable Path element) {
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            this.sourcePaths.add(element);
            return this;
        }

        public final Builder addSourcePaths(Path ... elements) {
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            for (Path element : elements) {
                this.sourcePaths.add(element);
            }
            return this;
        }

        public final Builder sourcePaths(Iterable<? extends @Nullable Path> elements) {
            this.sourcePaths = new ArrayList<Path>();
            return this.addAllSourcePaths(elements);
        }

        public final Builder addAllSourcePaths(Iterable<? extends @Nullable Path> elements) {
            Objects.requireNonNull(elements, "sourcePaths element");
            if (this.sourcePaths == null) {
                this.sourcePaths = new ArrayList<Path>();
            }
            for (Path path : elements) {
                this.sourcePaths.add(path);
            }
            return this;
        }

        public final Builder targets(SortedSet<ProtocTarget> targets) {
            this.targets = targets;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sanctionedExecutablePath(@Nullable Path sanctionedExecutablePath) {
            this.sanctionedExecutablePath = sanctionedExecutablePath;
            return this;
        }

        public ImmutableProtocInvocation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProtocInvocation(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("protocPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fatalWarnings");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("targets");
            }
            return "Cannot build ProtocInvocation, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

