/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans;

import io.github.benas.randombeans.PriorityComparator;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class RandomizerProvider {
    private final List<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
    private final Comparator<Object> priorityComparator = new PriorityComparator();

    RandomizerProvider(Set<RandomizerRegistry> registries) {
        this.registries.addAll(registries);
        this.registries.sort(this.priorityComparator);
    }

    Randomizer<?> getRandomizerByField(Field field) {
        return this.getRandomizer(new ByFieldProvider(field));
    }

    Randomizer<?> getRandomizerByType(Class<?> type) {
        return this.getRandomizer(new ByTypeProvider(type));
    }

    private Randomizer<?> getRandomizer(Provider provider) {
        return this.registries.stream().map(provider::getRandomizer).filter(Objects::nonNull).sorted(this.priorityComparator).findFirst().orElse(null);
    }

    private static class ByFieldProvider
    implements Provider {
        private final Field field;

        public ByFieldProvider(Field field) {
            this.field = field;
        }

        @Override
        public Randomizer<?> getRandomizer(RandomizerRegistry registry) {
            return registry.getRandomizer(this.field);
        }
    }

    private static class ByTypeProvider
    implements Provider {
        private final Class<?> type;

        public ByTypeProvider(Class<?> type) {
            this.type = type;
        }

        @Override
        public Randomizer<?> getRandomizer(RandomizerRegistry registry) {
            return registry.getRandomizer(this.type);
        }
    }

    @FunctionalInterface
    private static interface Provider {
        public Randomizer<?> getRandomizer(RandomizerRegistry var1);
    }
}

