/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import io.github.benas.randombeans.util.Constants;
import java.time.Instant;
import java.time.OffsetDateTime;

public class OffsetDateTimeRangeRandomizer
extends AbstractRangeRandomizer<OffsetDateTime> {
    public OffsetDateTimeRangeRandomizer(OffsetDateTime min, OffsetDateTime max) {
        super(min, max);
    }

    public OffsetDateTimeRangeRandomizer(OffsetDateTime min, OffsetDateTime max, long seed) {
        super(min, max, seed);
    }

    public static OffsetDateTimeRangeRandomizer aNewOffsetDateTimeRangeRandomizer(OffsetDateTime min, OffsetDateTime max) {
        return new OffsetDateTimeRangeRandomizer(min, max);
    }

    public static OffsetDateTimeRangeRandomizer aNewOffsetDateTimeRangeRandomizer(OffsetDateTime min, OffsetDateTime max, long seed) {
        return new OffsetDateTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((OffsetDateTime)this.min).isAfter((OffsetDateTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected OffsetDateTime getDefaultMinValue() {
        return Constants.DEFAULT_DATES_RANGE.getMin().toOffsetDateTime();
    }

    @Override
    protected OffsetDateTime getDefaultMaxValue() {
        return Constants.DEFAULT_DATES_RANGE.getMax().toOffsetDateTime();
    }

    @Override
    public OffsetDateTime getRandomValue() {
        long minSeconds = ((OffsetDateTime)this.min).toEpochSecond();
        long maxSeconds = ((OffsetDateTime)this.max).toEpochSecond();
        long seconds = (long)this.nextDouble(minSeconds, maxSeconds);
        int minNanoSeconds = ((OffsetDateTime)this.min).getNano();
        int maxNanoSeconds = ((OffsetDateTime)this.max).getNano();
        long nanoSeconds = (long)this.nextDouble(minNanoSeconds, maxNanoSeconds);
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanoSeconds), Constants.DEFAULT_DATES_RANGE.getMin().getZone());
    }
}

