/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.range;

import io.github.benas.randombeans.randomizers.range.AbstractRangeRandomizer;
import io.github.benas.randombeans.util.Constants;
import java.time.Year;
import java.time.temporal.ChronoField;

public class YearRangeRandomizer
extends AbstractRangeRandomizer<Year> {
    public YearRangeRandomizer(Year min, Year max) {
        super(min, max);
    }

    public YearRangeRandomizer(Year min, Year max, long seed) {
        super(min, max, seed);
    }

    public static YearRangeRandomizer aNewYearRangeRandomizer(Year min, Year max) {
        return new YearRangeRandomizer(min, max);
    }

    public static YearRangeRandomizer aNewYearRangeRandomizer(Year min, Year max, long seed) {
        return new YearRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((Year)this.min).isAfter((Year)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected Year getDefaultMinValue() {
        return Year.of(Constants.DEFAULT_DATES_RANGE.getMin().getYear());
    }

    @Override
    protected Year getDefaultMaxValue() {
        return Year.of(Constants.DEFAULT_DATES_RANGE.getMax().getYear());
    }

    @Override
    public Year getRandomValue() {
        long minYear = ((Year)this.min).getLong(ChronoField.YEAR);
        long maxYear = ((Year)this.max).getLong(ChronoField.YEAR);
        long randomYear = (long)this.nextDouble(minYear, maxYear);
        return Year.of(Math.toIntExact(randomYear));
    }
}

