/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.randomizers.registry;

import io.github.benas.randombeans.FieldDefinition;
import io.github.benas.randombeans.FieldPredicates;
import io.github.benas.randombeans.TypePredicates;
import io.github.benas.randombeans.annotation.Exclude;
import io.github.benas.randombeans.annotation.Priority;
import io.github.benas.randombeans.api.EnhancedRandomParameters;
import io.github.benas.randombeans.api.Randomizer;
import io.github.benas.randombeans.api.RandomizerRegistry;
import io.github.benas.randombeans.randomizers.misc.SkipRandomizer;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;

@Priority(value=0)
public class ExclusionRandomizerRegistry
implements RandomizerRegistry {
    private Set<Predicate<Field>> fieldPredicates = new HashSet<Predicate<Field>>();
    private Set<Predicate<Class<?>>> typePredicates = new HashSet();

    @Override
    public void init(EnhancedRandomParameters parameters) {
        this.fieldPredicates.add(FieldPredicates.isAnnotatedWith(Exclude.class));
        this.typePredicates.add(TypePredicates.isAnnotatedWith(Exclude.class));
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        for (Predicate<Field> fieldPredicate : this.fieldPredicates) {
            if (!fieldPredicate.test(field)) continue;
            return new SkipRandomizer();
        }
        return null;
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> clazz) {
        for (Predicate<Class<?>> typePredicate : this.typePredicates) {
            if (!typePredicate.test(clazz)) continue;
            return new SkipRandomizer();
        }
        return null;
    }

    @Deprecated
    public void addFieldDefinition(FieldDefinition<?, ?> fieldDefinition) {
        this.fieldPredicates.add(this.toPredicate(fieldDefinition));
    }

    public void addFieldPredicate(Predicate<Field> predicate) {
        this.fieldPredicates.add(predicate);
    }

    public void addTypePredicate(Predicate<Class<?>> predicate) {
        this.typePredicates.add(predicate);
    }

    private Predicate<Field> toPredicate(FieldDefinition<?, ?> fieldDefinition) {
        Class[] annotations = new Class[fieldDefinition.getAnnotations().size()];
        return field -> FieldPredicates.named(fieldDefinition.getName()).and(FieldPredicates.ofType(fieldDefinition.getType())).and(FieldPredicates.inClass(fieldDefinition.getClazz())).and(FieldPredicates.hasModifiers(fieldDefinition.getModifiers())).and(FieldPredicates.isAnnotatedWith(fieldDefinition.getAnnotations().toArray(annotations))).test((Field)field);
    }
}

