/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Optional;

public class FirefoxDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.FIREFOX;
    }

    @Override
    protected String getDriverName() {
        return "geckodriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getFirefoxDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getFirefoxDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getFirefoxDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getFirefoxDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setFirefoxDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setFirefoxDriverUrl(url);
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        String currentVersion = url.getFile().substring(url.getFile().indexOf(45) + 1, url.getFile().lastIndexOf(45));
        if (currentVersion.startsWith("v")) {
            currentVersion = currentVersion.substring(1);
        }
        return currentVersion;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iSeparator = target.indexOf(version) - 1;
        int iDash = target.lastIndexOf(version) + version.length();
        int iPoint = target.lastIndexOf(".zip");
        int iPointTazGz = target.lastIndexOf(".tar.gz");
        int iPointGz = target.lastIndexOf(".gz");
        if (iPointTazGz != -1) {
            iPoint = iPointTazGz;
        } else if (iPointGz != -1) {
            iPoint = iPointGz;
        }
        target = target.substring(0, iSeparator + 1) + target.substring(iDash + 1, iPoint).toLowerCase() + target.substring(iSeparator);
        return target;
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        String[] programFilesEnvs = new String[]{this.getProgramFilesEnv()};
        return this.getDefaultBrowserVersion(programFilesEnvs, "\\\\Mozilla Firefox\\\\firefox.exe", "firefox", "/Applications/Firefox.app/Contents/MacOS/firefox", "-v", this.getDriverManagerType().toString());
    }
}

