/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client;

import io.github.coffeelibs.tinyoauth2client.TinyOAuth2Client;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Experimental
public class ClientCredentialsGrant {
    @VisibleForTesting
    final TinyOAuth2Client client;
    @VisibleForTesting
    final String basicAuthHeader;

    ClientCredentialsGrant(TinyOAuth2Client client, Charset charset, CharSequence clientSecret) {
        this.client = client;
        this.basicAuthHeader = ClientCredentialsGrant.buildBasicAuthHeader(charset, client.clientId, clientSecret);
    }

    @Blocking
    public HttpResponse<String> authorize(HttpClient httpClient, String ... scopes) throws IOException, InterruptedException {
        HttpRequest req = this.buildTokenRequest(Set.of(scopes));
        return httpClient.send(req, HttpResponse.BodyHandlers.ofString());
    }

    @NonBlocking
    public CompletableFuture<HttpResponse<String>> authorizeAsync(HttpClient httpClient, String ... scopes) {
        HttpRequest req = this.buildTokenRequest(Set.of(scopes));
        return httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String buildBasicAuthHeader(Charset charset, String clientId, CharSequence clientSecret) {
        CharBuffer userPassChars = CharBuffer.allocate(clientId.length() + 1 + clientSecret.length());
        userPassChars.put(clientId).put(':').put(CharBuffer.wrap(clientSecret)).flip();
        ByteBuffer userPassBytes = charset.encode(userPassChars);
        ByteBuffer base64Bytes = Base64.getEncoder().encode(userPassBytes);
        try {
            String string = "Basic " + String.valueOf(StandardCharsets.US_ASCII.decode(base64Bytes));
            return string;
        }
        finally {
            Arrays.fill(userPassChars.array(), ' ');
            Arrays.fill(userPassBytes.array(), (byte)0);
            Arrays.fill(base64Bytes.array(), (byte)0);
        }
    }

    @VisibleForTesting
    HttpRequest buildTokenRequest(Collection<String> scopes) {
        Map<String, String> params = scopes.isEmpty() ? Map.of("grant_type", "client_credentials") : Map.of("grant_type", "client_credentials", "scope", String.join((CharSequence)" ", scopes));
        HttpRequest.Builder req = this.client.createTokenRequest(params);
        req.setHeader("Authorization", this.basicAuthHeader);
        return req.build();
    }
}

