/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers;

import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.annotationTypes.GraphQLUnion;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.typeBuilders.EnumBuilder;
import graphql.annotations.processor.typeBuilders.InputObjectBuilder;
import graphql.annotations.processor.typeBuilders.InterfaceBuilder;
import graphql.annotations.processor.typeBuilders.OutputObjectBuilder;
import graphql.annotations.processor.typeBuilders.UnionBuilder;
import graphql.annotations.processor.util.GraphQLTypeNameResolver;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={GraphQLTypeRetriever.class}, immediate=true)
public class GraphQLTypeRetriever {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;
    private GraphQLInterfaceRetriever graphQLInterfaceRetriever;
    private GraphQLFieldRetriever graphQLFieldRetriever;
    private SearchAlgorithm fieldSearchAlgorithm;
    private SearchAlgorithm methodSearchAlgorithm;
    private GraphQLExtensionsHandler extensionsHandler;

    public GraphQLType getGraphQLType(Class<?> object, ProcessingElementsContainer container, boolean isInput) throws GraphQLAnnotationsException, CannotCastMemberException {
        Object typeName = this.graphQLObjectInfoRetriever.getTypeName(object);
        if (isInput) {
            typeName = container.getInputPrefix() + (String)typeName + container.getInputSuffix();
        }
        if (container.getProcessing().contains(typeName)) {
            return new GraphQLTypeReference((String)typeName);
        }
        Object type = container.getTypeRegistry().get(typeName);
        if (type != null) {
            return type;
        }
        container.getProcessing().push((String)typeName);
        type = object.getAnnotation(GraphQLUnion.class) != null ? new UnionBuilder(this.graphQLObjectInfoRetriever).getUnionBuilder(object, container).build() : (object.isAnnotationPresent(GraphQLTypeResolver.class) ? new InterfaceBuilder(this.graphQLObjectInfoRetriever, this.graphQLFieldRetriever, this.extensionsHandler).getInterfaceBuilder(object, container).build() : (Enum.class.isAssignableFrom(object) ? new EnumBuilder(this.graphQLObjectInfoRetriever).getEnumBuilder(object).build() : (isInput ? new InputObjectBuilder(this.graphQLObjectInfoRetriever, this.fieldSearchAlgorithm, this.methodSearchAlgorithm, this.graphQLFieldRetriever).getInputObjectBuilder(object, container).build() : new OutputObjectBuilder(this.graphQLObjectInfoRetriever, this.fieldSearchAlgorithm, this.methodSearchAlgorithm, this.graphQLFieldRetriever, this.graphQLInterfaceRetriever, this.extensionsHandler).getOutputObjectBuilder(object, container).build())));
        container.getTypeRegistry().put(GraphQLTypeNameResolver.getName((GraphQLSchemaElement)type), (GraphQLType)type);
        container.getProcessing().pop();
        return type;
    }

    public GraphQLObjectInfoRetriever getGraphQLObjectInfoRetriever() {
        return this.graphQLObjectInfoRetriever;
    }

    public GraphQLInterfaceRetriever getGraphQLInterfaceRetriever() {
        return this.graphQLInterfaceRetriever;
    }

    public GraphQLFieldRetriever getGraphQLFieldRetriever() {
        return this.graphQLFieldRetriever;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLObjectInfoRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    public void unsetGraphQLObjectInfoRetriever(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLInterfaceRetriever(GraphQLInterfaceRetriever graphQLInterfaceRetriever) {
        this.graphQLInterfaceRetriever = graphQLInterfaceRetriever;
    }

    public void unsetGraphQLInterfaceRetriever(GraphQLInterfaceRetriever graphQLInterfaceRetriever) {
        this.graphQLInterfaceRetriever = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setGraphQLFieldRetriever(GraphQLFieldRetriever graphQLFieldRetriever) {
        this.graphQLFieldRetriever = graphQLFieldRetriever;
    }

    public void unsetGraphQLFieldRetriever(GraphQLFieldRetriever graphQLFieldRetriever) {
        this.graphQLFieldRetriever = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, target="(type=field)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setFieldSearchAlgorithm(SearchAlgorithm fieldSearchAlgorithm) {
        this.fieldSearchAlgorithm = fieldSearchAlgorithm;
    }

    public void unsetFieldSearchAlgorithm(SearchAlgorithm fieldSearchAlgorithm) {
        this.fieldSearchAlgorithm = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, target="(type=method)", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setMethodSearchAlgorithm(SearchAlgorithm methodSearchAlgorithm) {
        this.methodSearchAlgorithm = methodSearchAlgorithm;
    }

    public void unsetMethodSearchAlgorithm(SearchAlgorithm methodSearchAlgorithm) {
        this.methodSearchAlgorithm = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExtensionsHandler(GraphQLExtensionsHandler extensionsHandler) {
        this.extensionsHandler = extensionsHandler;
    }

    public void unsetExtensionsHandler(GraphQLExtensionsHandler extensionsHandler) {
        this.extensionsHandler = null;
    }
}

