/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock;

import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.MojoRuntimeException;
import io.github.kbuntrock.TagLibrary;
import io.github.kbuntrock.TagLibraryHolder;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.CommonApiConfiguration;
import io.github.kbuntrock.configuration.library.Library;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;

public class ApiResourceScanner {
    private final Log logger = Logger.INSTANCE.getLogger();
    private final ApiConfiguration apiConfiguration;
    private final List<Pattern> whiteListPatterns = new ArrayList<Pattern>();
    private final List<Pattern> blackListPatterns = new ArrayList<Pattern>();

    public ApiResourceScanner(ApiConfiguration apiConfiguration) {
        this.apiConfiguration = apiConfiguration;
        if (apiConfiguration.getWhiteList() != null) {
            for (String whiteEntry : apiConfiguration.getWhiteList()) {
                String regex = whiteEntry.split(CommonApiConfiguration.SEPARATOR_CLASS_METHOD)[0];
                if (whiteEntry.startsWith(CommonApiConfiguration.SEPARATOR_CLASS_METHOD)) continue;
                this.whiteListPatterns.add(Pattern.compile(regex));
            }
        }
        if (apiConfiguration.getBlackList() != null) {
            for (String blackEntry : apiConfiguration.getBlackList()) {
                String[] regexArray = blackEntry.split(CommonApiConfiguration.SEPARATOR_CLASS_METHOD);
                if (regexArray.length != 1) continue;
                this.blackListPatterns.add(Pattern.compile(regexArray[0]));
            }
        }
    }

    public TagLibrary scanRestControllers() throws MojoFailureException {
        TagLibrary library = new TagLibrary();
        TagLibraryHolder.INSTANCE.setTagLibrary(library);
        Library framework = this.apiConfiguration.getLibrary();
        ArrayList<Class<? extends Annotation>> annotatedElementList = new ArrayList<Class<? extends Annotation>>();
        for (String annotationName : this.apiConfiguration.getTagAnnotations()) {
            annotatedElementList.add(framework.getByClassName(annotationName));
        }
        for (String apiLocation : this.apiConfiguration.getLocations()) {
            this.logger.info((CharSequence)("Scanning : " + apiLocation));
            ConfigurationBuilder configurationBuilder = ReflectionsUtils.createConfigurationBuilder();
            configurationBuilder.filterInputsBy((Predicate)new FilterBuilder().includePackage(apiLocation));
            configurationBuilder.setClassLoaders(new ClassLoader[]{ReflectionsUtils.getProjectClassLoader()});
            configurationBuilder.setScanners(new Scanner[]{Scanners.TypesAnnotated});
            Reflections reflections = new Reflections((Configuration)configurationBuilder);
            Set classes = reflections.get(Scanners.TypesAnnotated.with(annotatedElementList.toArray(new AnnotatedElement[0])).asClass(new ClassLoader[]{ReflectionsUtils.getProjectClassLoader()}));
            this.logger.info((CharSequence)("Found " + classes.size() + " annotated classes with [ " + annotatedElementList.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + " ]"));
            JavaClassAnalyser javaClassAnalyser = new JavaClassAnalyser(this.apiConfiguration);
            for (Class clazz : classes) {
                Optional<Tag> optTag;
                if (!this.validateWhiteList(clazz) || !this.validateBlackList(clazz) || !(optTag = javaClassAnalyser.getTagFromClass(clazz)).isPresent()) continue;
                library.addTag(optTag.get());
            }
            for (String className : this.apiConfiguration.getExtraSchemaClasses()) {
                try {
                    library.addExtraClass(ReflectionsUtils.getProjectClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw new MojoRuntimeException("Cannot load extra class " + className, e);
                }
            }
        }
        library.resolveSchemaReferenceNames();
        return library;
    }

    private boolean validateWhiteList(Class clazz) {
        if (!this.whiteListPatterns.isEmpty()) {
            for (Pattern whitePattern : this.whiteListPatterns) {
                if (!whitePattern.matcher(clazz.getCanonicalName()).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean validateBlackList(Class clazz) {
        if (!this.blackListPatterns.isEmpty()) {
            for (Pattern blackPattern : this.blackListPatterns) {
                if (!blackPattern.matcher(clazz.getCanonicalName()).matches()) continue;
                return false;
            }
        }
        return true;
    }
}

