/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration;

import io.github.kbuntrock.configuration.CommonApiConfiguration;
import java.util.ArrayList;
import java.util.List;

public class NullableConfigurationHolder {
    private static final String defaultJakartaNullable = "jakarta.annotation.Nullable";
    private static final String defaultJavaxNullable = "javax.annotation.Nullable";
    private static final String defaultJakartaNotNull = "jakarta.validation.constraints.NotNull";
    private static final String defaultJakartaNotBlank = "jakarta.validation.constraints.NotBlank";
    private static final String defaultJakartaNotEmpty = "jakarta.validation.constraints.NotEmpty";
    private static final String defaultJavaxNotNull = "javax.validation.constraints.NotNull";
    private static final String defaultJavaxNotBlank = "javax.validation.constraints.NotBlank";
    private static final String defaultJavaxNotEmpty = "javax.validation.constraints.NotEmpty";
    private static List<String> nullableAnnotations;
    private static List<String> nonNullAnnotations;
    private static boolean defaultNonNullableFields;

    public static void storeConfig(CommonApiConfiguration commonApiConfiguration) {
        defaultNonNullableFields = commonApiConfiguration.defaultNonNullableFields != null && commonApiConfiguration.defaultNonNullableFields != false;
        nullableAnnotations = new ArrayList<String>();
        if (commonApiConfiguration.nullableAnnotation != null) {
            nullableAnnotations.addAll(commonApiConfiguration.nullableAnnotation);
        } else {
            nullableAnnotations.add(defaultJakartaNullable);
            nullableAnnotations.add(defaultJavaxNullable);
        }
        nonNullAnnotations = new ArrayList<String>();
        if (commonApiConfiguration.nonNullableAnnotation != null) {
            nonNullAnnotations.addAll(commonApiConfiguration.nonNullableAnnotation);
        } else {
            nonNullAnnotations.add(defaultJakartaNotNull);
            nonNullAnnotations.add(defaultJakartaNotBlank);
            nonNullAnnotations.add(defaultJakartaNotEmpty);
            nonNullAnnotations.add(defaultJavaxNotNull);
            nonNullAnnotations.add(defaultJavaxNotBlank);
            nonNullAnnotations.add(defaultJavaxNotEmpty);
        }
    }

    public static List<String> getNullableAnnotations() {
        return nullableAnnotations;
    }

    public static List<String> getNonNullAnnotations() {
        return nonNullAnnotations;
    }

    public static boolean isDefaultNonNullableFields() {
        return defaultNonNullableFields;
    }
}

