/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.configuration.library.reader.ClassLoaderUtils;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.OperationType;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ClassGenericityResolver;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.ParameterLocation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class JakartaRsReader
extends AstractLibraryReader {
    private static final String PATH_CNAME = "jakarta.ws.rs.Path";
    public static final String NOT_NULL_CNAME = "jakarta.validation.constraints.NotNull";
    public static final String BEAN_PARAM_CNAME = "jakarta.ws.rs.BeanParam";
    public static final String HttpServletRequest_CNAME = "jakarta.servlet.http.HttpServletRequest";
    private Class jakartaPath;
    private Class jakartaNotNull;
    private Class jakartaBeanParam;
    private Class jakartaHttpServletRequest;
    private Class responseAnnotation;

    public JakartaRsReader(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
        this.initClasses();
    }

    private void initClasses() {
        this.jakartaPath = ClassLoaderUtils.getByNameRuntimeEx(PATH_CNAME);
        this.jakartaBeanParam = ClassLoaderUtils.getByNameRuntimeEx(BEAN_PARAM_CNAME);
        try {
            this.jakartaNotNull = ClassLoaderUtils.getByName(NOT_NULL_CNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.jakartaHttpServletRequest = ClassLoaderUtils.getByName(HttpServletRequest_CNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.initCustomResponseAnnotation(this.apiConfiguration);
    }

    private void initCustomResponseAnnotation(ApiConfiguration apiConfiguration) {
        if (apiConfiguration.getCustomResponseTypeAnnotation() != null) {
            String annotationName = apiConfiguration.getCustomResponseTypeAnnotation();
            try {
                this.responseAnnotation = ClassLoaderUtils.getByName(annotationName);
                try {
                    Method responseAnnotationMethod = this.responseAnnotation.getMethod("value", new Class[0]);
                    if (responseAnnotationMethod.getReturnType() != Class.class) {
                        throw new RuntimeException("Annotation " + annotationName + " does not declare a method called value()");
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Annotation " + annotationName + " does not declare a method value() returning a Class");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load annotation class " + annotationName);
            }
        }
    }

    @Override
    public List<String> readBasePaths(Class<?> clazz, MergedAnnotations mergedAnnotations) {
        String path;
        List<String> basePaths = Collections.singletonList("");
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(this.jakartaPath);
        if (requestMappingMergedAnnotation.isPresent() && !StringUtils.isEmpty((CharSequence)(path = requestMappingMergedAnnotation.getString("value")))) {
            basePaths = Collections.singletonList(path);
        }
        return basePaths;
    }

    @Override
    public void computeAnnotations(String basePath, Method method, MergedAnnotations mergedAnnotations, Tag tag, ClassGenericityResolver genericityResolver) throws MojoFailureException {
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(this.jakartaPath);
        if (requestMappingMergedAnnotation.isPresent()) {
            genericityResolver.initForMethod(method);
            for (JakartaRsHttpVerb verb : JakartaRsHttpVerb.values()) {
                MergedAnnotation m = mergedAnnotations.get(verb.getAnnotationClass());
                if (!m.isPresent()) continue;
                String methodIdentifier = JavaClassAnalyser.createIdentifier(method);
                List<ParameterObject> parameterObjects = this.readParameters(method, genericityResolver);
                DataObject responseObject = this.readResponseObject(method, genericityResolver, mergedAnnotations);
                int responseCode = this.readResponseCode(null);
                String path = this.readEndpointPaths(basePath, requestMappingMergedAnnotation).get(0);
                Endpoint endpoint = new Endpoint();
                endpoint.setType(OperationType.fromJakarta(verb.getAnnotationClass().getCanonicalName()));
                endpoint.setPath(path);
                endpoint.setName(method.getName());
                endpoint.setParameters(parameterObjects);
                endpoint.setResponseObject(responseObject);
                endpoint.setResponseCode(responseCode);
                this.setConsumeProduceProperties(endpoint, mergedAnnotations);
                endpoint.setIdentifier(methodIdentifier);
                endpoint.setDeprecated(this.isDeprecated(method));
                tag.addEndpoint(endpoint);
                this.logger.debug((CharSequence)("Finished parsing endpoint : " + endpoint.getName() + " - " + endpoint.getType().name()));
            }
        }
    }

    @Override
    protected List<ParameterObject> readParameters(Method originalMethod, ClassGenericityResolver genericityResolver) {
        this.logger.debug((CharSequence)("Reading parameters from " + originalMethod.getName()));
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        LinkedHashMap<String, ParameterObject> parameters = new LinkedHashMap<String, ParameterObject>();
        for (Method method : overridenMethods) {
            boolean bodyParameterDetected = false;
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation requestParamMA;
                if (HttpServletRequest.class.isAssignableFrom(parameter.getType()) || this.jakartaHttpServletRequest != null && this.jakartaHttpServletRequest.isAssignableFrom(parameter.getType())) continue;
                this.logger.debug((CharSequence)("Parameter : " + parameter.getName()));
                ParameterObject paramObj = new ParameterObject(parameter.getName(), genericityResolver.getContextualType(parameter.getParameterizedType(), method));
                paramObj = this.unwrapParameterObject(paramObj);
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)parameter, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                if (mergedAnnotations.get(this.jakartaBeanParam).isPresent()) continue;
                parameters.putIfAbsent(paramObj.getName(), paramObj);
                MergedAnnotation notnullMA = mergedAnnotations.get(NotNull.class);
                if (notnullMA.isPresent()) {
                    paramObj.setRequired(notnullMA.isPresent());
                } else if (this.jakartaNotNull != null) {
                    paramObj.setRequired(mergedAnnotations.get(this.jakartaNotNull).isPresent());
                }
                MergedAnnotation pathVariableMA = mergedAnnotations.get(ClassLoaderUtils.getByNameRuntimeEx("jakarta.ws.rs.PathParam"));
                if (pathVariableMA.isPresent()) {
                    paramObj.setLocation(ParameterLocation.PATH);
                    paramObj.setRequired(true);
                    String value = pathVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("PathParam annotation detected (" + paramObj.getName() + ")"));
                }
                if ((requestParamMA = mergedAnnotations.get(ClassLoaderUtils.getByNameRuntimeEx("jakarta.ws.rs.QueryParam"))).isPresent()) {
                    boolean isMultipartFile;
                    boolean bl = isMultipartFile = MultipartFile.class == paramObj.getJavaClass() || OpenApiDataType.ARRAY == paramObj.getOpenApiResolvedType().getType() && MultipartFile.class == paramObj.getArrayItemDataObject().getJavaClass();
                    if (isMultipartFile) {
                        paramObj.setLocation(ParameterLocation.BODY);
                    } else {
                        paramObj.setLocation(ParameterLocation.QUERY);
                    }
                    String value = requestParamMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("QueryParam annotation detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
                }
                if (paramObj.getLocation() != null) continue;
                if (bodyParameterDetected) {
                    bodyParameterDetected = true;
                    this.logger.error((CharSequence)("Cannot set multiple body parameters, (" + paramObj.getName() + ")"));
                    continue;
                }
                paramObj.setLocation(ParameterLocation.BODY);
                this.logger.debug((CharSequence)("Body parameter detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
            }
        }
        return parameters.values().stream().filter(x -> x.getLocation() != null).collect(Collectors.toList());
    }

    protected List<String> readEndpointPaths(String basePath, MergedAnnotation pathMergedAnnotation) {
        String path = pathMergedAnnotation.getString("value");
        if (path == null) {
            return Arrays.asList(JakartaRsReader.concatenateBasePathAndMethodPath(basePath, "", this.apiConfiguration.getPathEnhancement()));
        }
        return Arrays.asList(JakartaRsReader.concatenateBasePathAndMethodPath(basePath, path, this.apiConfiguration.getPathEnhancement()));
    }

    @Override
    protected void setConsumeProduceProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) throws MojoFailureException {
        String[] produces;
        String[] consumes;
        MergedAnnotation consumesMergedAnnotation = mergedAnnotations.get(ClassLoaderUtils.getByNameRuntimeEx("jakarta.ws.rs.Consumes"));
        MergedAnnotation producesMergedAnnotation = mergedAnnotations.get(ClassLoaderUtils.getByNameRuntimeEx("jakarta.ws.rs.Produces"));
        Optional<ParameterObject> body = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).findAny();
        if (body.isPresent() && consumesMergedAnnotation.isPresent() && (consumes = consumesMergedAnnotation.getStringArray("value")).length > 0) {
            body.get().setFormats(Arrays.asList(consumes));
        }
        if (endpoint.getResponseObject() != null && producesMergedAnnotation.isPresent() && (produces = producesMergedAnnotation.getStringArray("value")).length > 0) {
            endpoint.setResponseFormats(Arrays.asList(produces));
        }
    }

    @Override
    protected int readResponseCode(MergedAnnotations mergedAnnotations) {
        return HttpStatus.OK.value();
    }

    @Override
    protected Type readResponseMethodType(Method method, MergedAnnotations mergedAnnotations) {
        if (this.responseAnnotation != null && mergedAnnotations.isPresent(this.responseAnnotation)) {
            return (Class)mergedAnnotations.get(this.responseAnnotation).getValue("value").get();
        }
        return method.getGenericReturnType();
    }

    private static enum JakartaRsHttpVerb {
        GET("jakarta.ws.rs.GET"),
        PUT("jakarta.ws.rs.PUT"),
        POST("jakarta.ws.rs.POST"),
        DELETE("jakarta.ws.rs.DELETE"),
        PATCH("jakarta.ws.rs.PATCH"),
        OPTIONS("jakarta.ws.rs.OPTIONS"),
        HEAD("jakarta.ws.rs.HEAD");

        private final String annotationClassName;

        private JakartaRsHttpVerb(String annotationClassName) {
            this.annotationClassName = annotationClassName;
        }

        public Class getAnnotationClass() {
            return ClassLoaderUtils.getByNameRuntimeEx(this.annotationClassName);
        }
    }
}

