/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.configuration.library.reader.ClassLoaderUtils;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.OperationType;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ClassGenericityResolver;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.ParameterLocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;

public class JavaxRsReader
extends AstractLibraryReader {
    private Class jakartaNotNull;
    private Class jakartaHttpServletRequest;
    private Class responseAnnotation;

    public JavaxRsReader(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
        try {
            this.jakartaNotNull = ClassLoaderUtils.getByName("jakarta.validation.constraints.NotNull");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.jakartaHttpServletRequest = ClassLoaderUtils.getByName("jakarta.servlet.http.HttpServletRequest");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.initCustomResponseAnnotation(apiConfiguration);
    }

    private void initCustomResponseAnnotation(ApiConfiguration apiConfiguration) {
        if (apiConfiguration.getCustomResponseTypeAnnotation() != null) {
            String annotationName = apiConfiguration.getCustomResponseTypeAnnotation();
            try {
                this.responseAnnotation = ClassLoaderUtils.getByName(annotationName);
                try {
                    Method responseAnnotationMethod = this.responseAnnotation.getMethod("value", new Class[0]);
                    if (responseAnnotationMethod.getReturnType() != Class.class) {
                        throw new RuntimeException("Annotation " + annotationName + " does not declare a method called value()");
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Annotation " + annotationName + " does not declare a method value() returning a Class");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load annotation class " + annotationName);
            }
        }
    }

    @Override
    public List<String> readBasePaths(Class<?> clazz, MergedAnnotations mergedAnnotations) {
        String path;
        List<String> basePaths = Collections.singletonList("");
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(Path.class);
        if (requestMappingMergedAnnotation.isPresent() && !StringUtils.isEmpty((CharSequence)(path = requestMappingMergedAnnotation.getString("value")))) {
            basePaths = Collections.singletonList(path);
        }
        return basePaths;
    }

    @Override
    public void computeAnnotations(String basePath, Method method, MergedAnnotations mergedAnnotations, Tag tag, ClassGenericityResolver genericityResolver) throws MojoFailureException {
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(Path.class);
        if (requestMappingMergedAnnotation.isPresent()) {
            genericityResolver.initForMethod(method);
            for (JavaxRsHttpVerb verb : JavaxRsHttpVerb.values()) {
                MergedAnnotation m = mergedAnnotations.get(verb.getAnnotationClass());
                if (!m.isPresent()) continue;
                String methodIdentifier = JavaClassAnalyser.createIdentifier(method);
                List<ParameterObject> parameterObjects = this.readParameters(method, genericityResolver);
                DataObject responseObject = this.readResponseObject(method, genericityResolver, mergedAnnotations);
                int responseCode = this.readResponseCode(null);
                String path = this.readEndpointPaths(basePath, (MergedAnnotation<? extends Annotation>)requestMappingMergedAnnotation).get(0);
                Endpoint endpoint = new Endpoint();
                endpoint.setType(OperationType.fromJavax(verb.getAnnotationClass()));
                endpoint.setPath(path);
                endpoint.setName(method.getName());
                endpoint.setParameters(parameterObjects);
                endpoint.setResponseObject(responseObject);
                endpoint.setResponseCode(responseCode);
                this.setConsumeProduceProperties(endpoint, mergedAnnotations);
                endpoint.setIdentifier(methodIdentifier);
                endpoint.setDeprecated(this.isDeprecated(method));
                tag.addEndpoint(endpoint);
                this.logger.debug((CharSequence)("Finished parsing endpoint : " + endpoint.getName() + " - " + endpoint.getType().name()));
            }
        }
    }

    @Override
    protected List<ParameterObject> readParameters(Method originalMethod, ClassGenericityResolver genericityResolver) {
        this.logger.debug((CharSequence)("Reading parameters from " + originalMethod.getName()));
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        LinkedHashMap<String, ParameterObject> parameters = new LinkedHashMap<String, ParameterObject>();
        for (Method method : overridenMethods) {
            boolean bodyParameterDetected = false;
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation requestParamMA;
                if (HttpServletRequest.class.isAssignableFrom(parameter.getType()) || this.jakartaHttpServletRequest != null && this.jakartaHttpServletRequest.isAssignableFrom(parameter.getType())) continue;
                this.logger.debug((CharSequence)("Parameter : " + parameter.getName()));
                ParameterObject paramObj = new ParameterObject(parameter.getName(), genericityResolver.getContextualType(parameter.getParameterizedType(), method));
                paramObj = this.unwrapParameterObject(paramObj);
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)parameter, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                if (mergedAnnotations.get(BeanParam.class).isPresent()) continue;
                parameters.putIfAbsent(paramObj.getName(), paramObj);
                MergedAnnotation notnullMA = mergedAnnotations.get(NotNull.class);
                if (notnullMA.isPresent()) {
                    paramObj.setRequired(notnullMA.isPresent());
                } else if (this.jakartaNotNull != null) {
                    paramObj.setRequired(mergedAnnotations.get(this.jakartaNotNull).isPresent());
                }
                MergedAnnotation pathVariableMA = mergedAnnotations.get(PathParam.class);
                if (pathVariableMA.isPresent()) {
                    paramObj.setLocation(ParameterLocation.PATH);
                    paramObj.setRequired(true);
                    String value = pathVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("PathParam annotation detected (" + paramObj.getName() + ")"));
                }
                if ((requestParamMA = mergedAnnotations.get(QueryParam.class)).isPresent()) {
                    boolean isMultipartFile;
                    boolean bl = isMultipartFile = MultipartFile.class == paramObj.getJavaClass() || OpenApiDataType.ARRAY == paramObj.getOpenApiResolvedType().getType() && MultipartFile.class == paramObj.getArrayItemDataObject().getJavaClass();
                    if (isMultipartFile) {
                        paramObj.setLocation(ParameterLocation.BODY);
                    } else {
                        paramObj.setLocation(ParameterLocation.QUERY);
                    }
                    String value = requestParamMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("QueryParam annotation detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
                }
                if (paramObj.getLocation() != null) continue;
                if (bodyParameterDetected) {
                    bodyParameterDetected = true;
                    this.logger.error((CharSequence)("Cannot set multiple body parameters, (" + paramObj.getName() + ")"));
                    continue;
                }
                paramObj.setLocation(ParameterLocation.BODY);
                this.logger.debug((CharSequence)("Body parameter detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
            }
        }
        return parameters.values().stream().filter(x -> x.getLocation() != null).collect(Collectors.toList());
    }

    @Override
    protected List<String> readEndpointPaths(String basePath, MergedAnnotation<? extends Annotation> pathMergedAnnotation) {
        String path = pathMergedAnnotation.getString("value");
        if (path == null) {
            return Arrays.asList(JavaxRsReader.concatenateBasePathAndMethodPath(basePath, "", this.apiConfiguration.getPathEnhancement()));
        }
        return Arrays.asList(JavaxRsReader.concatenateBasePathAndMethodPath(basePath, path, this.apiConfiguration.getPathEnhancement()));
    }

    @Override
    protected void setConsumeProduceProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) throws MojoFailureException {
        String[] produces;
        String[] consumes;
        MergedAnnotation consumesMergedAnnotation = mergedAnnotations.get(Consumes.class);
        MergedAnnotation producesMergedAnnotation = mergedAnnotations.get(Produces.class);
        Optional<ParameterObject> body = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).findAny();
        if (body.isPresent() && consumesMergedAnnotation.isPresent() && (consumes = consumesMergedAnnotation.getStringArray("value")).length > 0) {
            body.get().setFormats(Arrays.asList(consumes));
        }
        if (endpoint.getResponseObject() != null && producesMergedAnnotation.isPresent() && (produces = producesMergedAnnotation.getStringArray("value")).length > 0) {
            endpoint.setResponseFormats(Arrays.asList(produces));
        }
    }

    @Override
    protected int readResponseCode(MergedAnnotations mergedAnnotations) {
        return HttpStatus.OK.value();
    }

    @Override
    protected Type readResponseMethodType(Method method, MergedAnnotations mergedAnnotations) {
        if (this.responseAnnotation != null && mergedAnnotations.isPresent(this.responseAnnotation)) {
            return (Class)mergedAnnotations.get(this.responseAnnotation).getValue("value").get();
        }
        return method.getGenericReturnType();
    }

    private static enum JavaxRsHttpVerb {
        GET(GET.class),
        PUT(PUT.class),
        POST(POST.class),
        DELETE(DELETE.class),
        PATCH(PATCH.class),
        OPTIONS(OPTIONS.class),
        HEAD(HEAD.class);

        private final Class annotationClass;

        private JavaxRsHttpVerb(Class annotationClass) {
            this.annotationClass = annotationClass;
        }

        public Class getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

