/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.configuration.library.reader;

import io.github.kbuntrock.JavaClassAnalyser;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.reader.AstractLibraryReader;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.model.Endpoint;
import io.github.kbuntrock.model.OperationType;
import io.github.kbuntrock.model.ParameterObject;
import io.github.kbuntrock.model.Tag;
import io.github.kbuntrock.reflection.ClassGenericityResolver;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.ParameterLocation;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

public class SpringMvcReader
extends AstractLibraryReader {
    public SpringMvcReader(ApiConfiguration apiConfiguration) {
        super(apiConfiguration);
    }

    @Override
    public List<String> readBasePaths(Class<?> clazz, MergedAnnotations mergedAnnotations) {
        String[] paths;
        List<String> basePaths = Collections.singletonList("");
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        if (requestMappingMergedAnnotation.isPresent() && (paths = requestMappingMergedAnnotation.getStringArray("value")).length > 0) {
            basePaths = Arrays.asList(paths);
        }
        return basePaths;
    }

    @Override
    public void computeAnnotations(String basePath, Method method, MergedAnnotations mergedAnnotations, Tag tag, ClassGenericityResolver genericityResolver) throws MojoFailureException {
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        if (requestMappingMergedAnnotation.isPresent() && !this.excludedByReturnType(method)) {
            genericityResolver.initForMethod(method);
            RequestMethod[] requestMethods = (RequestMethod[])requestMappingMergedAnnotation.getEnumArray("method", RequestMethod.class);
            if (requestMethods.length > 0) {
                this.logger.debug((CharSequence)("Parsing request method : " + method.getName()));
                String methodIdentifier = JavaClassAnalyser.createIdentifier(method);
                List<ParameterObject> parameterObjects = this.readParameters(method, genericityResolver);
                DataObject responseObject = this.readResponseObject(method, genericityResolver, mergedAnnotations);
                int responseCode = this.readResponseCode(mergedAnnotations);
                List<String> paths = this.readEndpointPaths(basePath, (MergedAnnotation<? extends Annotation>)requestMappingMergedAnnotation);
                for (RequestMethod requestMethod : requestMethods) {
                    for (String path : paths) {
                        Endpoint endpoint = new Endpoint();
                        endpoint.setType(OperationType.fromJavax(requestMethod));
                        endpoint.setPath(path);
                        endpoint.setName(method.getName());
                        endpoint.setParameters(parameterObjects);
                        endpoint.setResponseObject(responseObject);
                        endpoint.setResponseCode(responseCode);
                        this.setConsumeProduceProperties(endpoint, mergedAnnotations);
                        endpoint.setIdentifier(methodIdentifier);
                        endpoint.setDeprecated(this.isDeprecated(method));
                        tag.addEndpoint(endpoint);
                        this.logger.debug((CharSequence)("Finished parsing endpoint : " + endpoint.getName() + " - " + endpoint.getType().name()));
                    }
                }
            }
        }
    }

    private boolean excludedByReturnType(Method method) {
        return "org.springframework.web.servlet.ModelAndView".equals(method.getReturnType().getCanonicalName());
    }

    @Override
    protected List<ParameterObject> readParameters(Method originalMethod, ClassGenericityResolver genericityResolver) {
        this.logger.debug((CharSequence)("Reading parameters from " + originalMethod.getName()));
        Set overridenMethods = MethodUtils.getOverrideHierarchy((Method)originalMethod, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
        LinkedHashMap<String, ParameterObject> parameters = new LinkedHashMap<String, ParameterObject>();
        for (Method method : overridenMethods) {
            for (Parameter parameter : method.getParameters()) {
                MergedAnnotation requestBodyMA;
                MergedAnnotation requestParamMA;
                if (HttpServletRequest.class.isAssignableFrom(parameter.getType())) continue;
                this.logger.debug((CharSequence)("Parameter : " + parameter.getName()));
                ParameterObject paramObj = parameters.computeIfAbsent(parameter.getName(), name -> this.unwrapParameterObject(new ParameterObject((String)name, genericityResolver.getContextualType(parameter.getParameterizedType(), method))));
                MergedAnnotations mergedAnnotations = MergedAnnotations.from((AnnotatedElement)parameter, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                MergedAnnotation pathVariableMA = mergedAnnotations.get(PathVariable.class);
                if (pathVariableMA.isPresent()) {
                    paramObj.setLocation(ParameterLocation.PATH);
                    paramObj.setRequired(pathVariableMA.getBoolean("required"));
                    String value = pathVariableMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("PathVariable annotation detected (" + paramObj.getName() + ")"));
                }
                if ((requestParamMA = mergedAnnotations.get(RequestParam.class)).isPresent()) {
                    boolean isMultipartFile;
                    boolean bl = isMultipartFile = MultipartFile.class == paramObj.getJavaClass() || OpenApiDataType.ARRAY == paramObj.getOpenApiResolvedType().getType() && MultipartFile.class == paramObj.getArrayItemDataObject().getJavaClass();
                    if (isMultipartFile) {
                        paramObj.setLocation(ParameterLocation.BODY);
                    } else {
                        paramObj.setLocation(ParameterLocation.QUERY);
                    }
                    paramObj.setRequired(requestParamMA.getBoolean("required") && !SpringMvcReader.requestParamHasDefaultValue((MergedAnnotation<RequestParam>)requestParamMA));
                    String value = requestParamMA.getString("value");
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        paramObj.setName(value);
                    }
                    this.logger.debug((CharSequence)("RequestParam annotation detected (" + paramObj.getName() + "), location is " + paramObj.getLocation().toString()));
                }
                if ((requestBodyMA = mergedAnnotations.get(RequestBody.class)).isPresent()) {
                    paramObj.setLocation(ParameterLocation.BODY);
                    paramObj.setRequired(requestBodyMA.getBoolean("required"));
                    this.logger.debug((CharSequence)("RequestBody annotation detected, location is " + paramObj.getLocation().toString()));
                }
                if (paramObj.getClassRequired() == null) continue;
                paramObj.setRequired(paramObj.getClassRequired());
            }
        }
        return parameters.values().stream().filter(x -> x.getLocation() != null).collect(Collectors.toList());
    }

    private static boolean requestParamHasDefaultValue(MergedAnnotation<RequestParam> requestParam) {
        return !"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.getString("defaultValue"));
    }

    @Override
    protected List<String> readEndpointPaths(String basePath, MergedAnnotation<? extends Annotation> requestMappingMergedAnnotation) {
        String[] paths = requestMappingMergedAnnotation.getStringArray("path");
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        if (paths.length == 0) {
            resolvedPaths.add(SpringMvcReader.concatenateBasePathAndMethodPath(basePath, "", this.apiConfiguration.getPathEnhancement()));
        }
        for (String path : paths) {
            resolvedPaths.add(SpringMvcReader.concatenateBasePathAndMethodPath(basePath, path, this.apiConfiguration.getPathEnhancement()));
        }
        return resolvedPaths;
    }

    @Override
    protected void setConsumeProduceProperties(Endpoint endpoint, MergedAnnotations mergedAnnotations) throws MojoFailureException {
        String[] produces;
        String[] consumes;
        MergedAnnotation requestMappingMergedAnnotation = mergedAnnotations.get(RequestMapping.class);
        Optional<ParameterObject> body = endpoint.getParameters().stream().filter(x -> ParameterLocation.BODY == x.getLocation()).findAny();
        if (body.isPresent() && (consumes = requestMappingMergedAnnotation.getStringArray("consumes")).length > 0) {
            body.get().setFormats(Arrays.asList(consumes));
        }
        if (endpoint.getResponseObject() != null && (produces = requestMappingMergedAnnotation.getStringArray("produces")).length > 0) {
            endpoint.setResponseFormats(Arrays.asList(produces));
        }
    }

    @Override
    protected int readResponseCode(MergedAnnotations mergedAnnotations) {
        MergedAnnotation responseStatusMA = mergedAnnotations.get(ResponseStatus.class);
        if (!responseStatusMA.isPresent()) {
            return HttpStatus.OK.value();
        }
        return ((HttpStatus)responseStatusMA.getValue("value", HttpStatus.class).get()).value();
    }
}

