/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.utils;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.kbuntrock.configuration.ApiConfiguration;
import io.github.kbuntrock.configuration.library.Library;
import io.github.kbuntrock.configuration.parser.CommonParserUtils;
import io.github.kbuntrock.configuration.parser.JsonParserUtils;
import io.github.kbuntrock.configuration.parser.YamlParserUtils;
import io.github.kbuntrock.model.DataObject;
import io.github.kbuntrock.reflection.ReflectionsUtils;
import io.github.kbuntrock.utils.Logger;
import io.github.kbuntrock.utils.OpenApiDataType;
import io.github.kbuntrock.utils.OpenApiResolvedType;
import io.github.kbuntrock.utils.UnwrappingEntry;
import io.github.kbuntrock.utils.UnwrappingType;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.project.MavenProject;

public enum OpenApiTypeResolver {
    INSTANCE;

    public static final OpenApiResolvedType ANY_TYPE;
    public static final OpenApiResolvedType OBJECT_TYPE;
    private static final String EQUALITY = "equality";
    private static final String ASSIGNABILITY = "assignability";
    private static final String OBJECT = "object";
    private static final String ARRAY = "array";
    private static final String ENUM = "enum";
    public static final String JAVA_UTIL_COLLECTION = "java.util.Collection";
    private final Map<String, OpenApiResolvedType> modelMap = new HashMap<String, OpenApiResolvedType>();
    private final Map<String, OpenApiResolvedType> nonCompleteModelMap = new HashMap<String, OpenApiResolvedType>();
    private final Map<String, OpenApiResolvedType> equalityMap = new HashMap<String, OpenApiResolvedType>();
    private final Map<Class<?>, OpenApiResolvedType> assignabilityMap = new HashMap();
    private final Map<String, String> defaultEncodingMap = new HashMap<String, String>();
    private final Map<Class<?>, UnwrappingEntry> responseUnwrappingMap = new HashMap();
    private final Map<Class<?>, UnwrappingEntry> parametersUnwrappingMap = new HashMap();
    private final Map<Class<?>, UnwrappingEntry> schemaUnwrappingMap = new HashMap();
    private final Set<Class<?>> nonDocumentableParameters = new HashSet();

    public void init(MavenProject mavenProject, ApiConfiguration apiConfig) {
        this.initDefaultEncodingAssociations();
        this.initModel(mavenProject, apiConfig);
        this.initJavaClassAssociations(mavenProject, apiConfig);
        this.initUnwrappingDefinitions(mavenProject, apiConfig);
        this.initNonDocumentableParameters(apiConfig);
    }

    private void initModel(MavenProject mavenProject, ApiConfiguration apiConfig) {
        this.modelMap.clear();
        JsonNode root = YamlParserUtils.readResourceFile("/openapi-model.yml");
        this.initModelFromNode(root);
        if (apiConfig.getOpenapiModels() != null) {
            JsonNode customRoot = CommonParserUtils.parse(mavenProject, apiConfig.getOpenapiModels()).get();
            this.initModelFromNode(customRoot);
        }
    }

    private void initModelFromNode(JsonNode root) {
        root.fields().forEachRemaining(entry -> {
            JsonNode modelNode = (JsonNode)entry.getValue();
            String defaultEncoding = this.defaultEncodingMap.get(entry.getKey());
            OpenApiResolvedType type = new OpenApiResolvedType(OpenApiDataType.fromJsonNode(modelNode), modelNode, (String)entry.getKey(), defaultEncoding);
            this.modelMap.put((String)entry.getKey(), type);
        });
        this.modelMap.put("any", ANY_TYPE);
    }

    private void initJavaClassAssociations(MavenProject mavenProject, ApiConfiguration apiConfig) {
        this.equalityMap.clear();
        this.assignabilityMap.clear();
        JsonNode root = YamlParserUtils.readResourceFile("/java-class-assignability.yml");
        this.initJavaClassAssociationsByEquality(root);
        this.initJavaClassAssociationsByAssignability(root);
        if (apiConfig.getModelsAssociations() != null) {
            JsonNode customRoot = CommonParserUtils.parse(mavenProject, apiConfig.getModelsAssociations()).get();
            this.initJavaClassAssociationsByEquality(customRoot);
            this.initJavaClassAssociationsByAssignability(customRoot);
        }
    }

    private void initDefaultEncodingAssociations() {
        this.defaultEncodingMap.clear();
        JsonNode root = YamlParserUtils.readResourceFile("/openapi-model-associations.yml");
        root.fields().forEachRemaining(entry -> {
            JsonNode defaultEncoding = ((JsonNode)entry.getValue()).get("default-encoding");
            if (defaultEncoding != null) {
                this.defaultEncodingMap.put((String)entry.getKey(), defaultEncoding.asText());
            }
        });
    }

    private void initJavaClassAssociationsByEquality(JsonNode root) {
        JsonNode equalityNode = root.get(EQUALITY);
        if (equalityNode == null) {
            return;
        }
        equalityNode.fields().forEachRemaining(entry -> {
            if (entry.getValue() == null) {
                this.equalityMap.remove(entry.getKey());
            } else {
                OpenApiResolvedType resolvedType = this.modelMap.get(((JsonNode)entry.getValue()).asText());
                if (resolvedType == null) {
                    throw new RuntimeException("There is no model definition to honor association : " + (String)entry.getKey() + " -> " + ((JsonNode)entry.getValue()).asText());
                }
                this.equalityMap.put((String)entry.getKey(), resolvedType);
            }
        });
    }

    private void initJavaClassAssociationsByAssignability(JsonNode root) {
        JsonNode rootNode = root.get(ASSIGNABILITY);
        if (rootNode == null) {
            return;
        }
        ClassLoader classLoader = ReflectionsUtils.getProjectClassLoader();
        rootNode.fields().forEachRemaining(entry -> {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass((String)entry.getKey());
            }
            catch (ClassNotFoundException ex) {
                Logger.INSTANCE.getLogger().debug((CharSequence)("Model class " + ((JsonNode)entry.getValue()).asText() + " not found (could be normal)"));
            }
            if (clazz != null) {
                if (entry.getValue() == null) {
                    this.assignabilityMap.remove(clazz);
                } else {
                    OpenApiResolvedType resolvedType = this.modelMap.get(((JsonNode)entry.getValue()).asText());
                    if (resolvedType == null) {
                        throw new RuntimeException("There is no model definition to honor association : " + (String)entry.getKey() + " -> " + ((JsonNode)entry.getValue()).asText());
                    }
                    this.assignabilityMap.put(clazz, resolvedType);
                }
            }
        });
    }

    public OpenApiResolvedType resolveFromJavaClass(Class<?> clazz) {
        return this.resolveFromJavaClass(clazz, true);
    }

    public OpenApiResolvedType resolveFromJavaClass(Class<?> clazz, boolean completeVersion) {
        String canonicalName = this.resolveCanonicalName(clazz);
        OpenApiResolvedType resolvedType = this.equalityMap.get(canonicalName);
        if (resolvedType != null) {
            if (!completeVersion) {
                return this.nonCompleteModelMap.computeIfAbsent(canonicalName, k -> {
                    OpenApiResolvedType nonCompleteVersion = resolvedType.copy();
                    nonCompleteVersion.setCompleteNode(false);
                    return nonCompleteVersion;
                });
            }
            return resolvedType;
        }
        for (Class<?> c : this.assignabilityMap.keySet()) {
            if (!c.isAssignableFrom(clazz)) continue;
            OpenApiResolvedType resolvedAssignability = this.assignabilityMap.get(c);
            if (!completeVersion || JAVA_UTIL_COLLECTION.equals(c.getCanonicalName())) {
                return this.nonCompleteModelMap.computeIfAbsent(canonicalName, k -> {
                    OpenApiResolvedType nonCompleteVersion = resolvedAssignability.copy();
                    nonCompleteVersion.setCompleteNode(false);
                    return nonCompleteVersion;
                });
            }
            return resolvedAssignability;
        }
        if (clazz.isArray()) {
            return this.resolveNonCompleteModel(ARRAY);
        }
        if (clazz.isEnum()) {
            return this.resolveNonCompleteModel(ENUM);
        }
        return this.resolveNonCompleteModel(OBJECT);
    }

    private OpenApiResolvedType resolveNonCompleteModel(String key) {
        return this.nonCompleteModelMap.computeIfAbsent(key, k -> {
            OpenApiResolvedType completeVersion = this.modelMap.get(k).copy();
            completeVersion.setCompleteNode(false);
            return completeVersion;
        });
    }

    private String resolveCanonicalName(Class<?> clazz) {
        if (Boolean.TYPE == clazz) {
            return Boolean.class.getCanonicalName();
        }
        if (Integer.TYPE == clazz) {
            return Integer.class.getCanonicalName();
        }
        if (Long.TYPE == clazz) {
            return Long.class.getCanonicalName();
        }
        if (Float.TYPE == clazz) {
            return Float.class.getCanonicalName();
        }
        if (Double.TYPE == clazz) {
            return Double.class.getCanonicalName();
        }
        if (Short.TYPE == clazz) {
            return Short.class.getCanonicalName();
        }
        if (Character.TYPE == clazz) {
            return Character.class.getCanonicalName();
        }
        if (Byte.TYPE == clazz) {
            return Byte.class.getCanonicalName();
        }
        return clazz.getCanonicalName();
    }

    private void initUnwrappingDefinitions(MavenProject mavenProject, ApiConfiguration apiConfig) {
        this.responseUnwrappingMap.clear();
        this.parametersUnwrappingMap.clear();
        this.schemaUnwrappingMap.clear();
        ClassLoader classLoader = ReflectionsUtils.getProjectClassLoader();
        JsonNode root = YamlParserUtils.readResourceFile("/unwrapping-configuration.yml");
        root.get("response").fields().forEachRemaining(entry -> this.registerUnwrappingEntry(classLoader, (Map.Entry<String, JsonNode>)entry, this.responseUnwrappingMap, true));
        root.get("parameter").fields().forEachRemaining(entry -> this.registerUnwrappingEntry(classLoader, (Map.Entry<String, JsonNode>)entry, this.parametersUnwrappingMap, true));
        root.get("schema").fields().forEachRemaining(entry -> this.registerUnwrappingEntry(classLoader, (Map.Entry<String, JsonNode>)entry, this.schemaUnwrappingMap, true));
    }

    private void registerUnwrappingEntry(ClassLoader classLoader, Map.Entry<String, JsonNode> entry, Map<Class<?>, UnwrappingEntry> unwrappingMap, boolean debug) {
        try {
            Class<?> clazz = classLoader.loadClass(entry.getKey());
            UnwrappingEntry unwrappingEntry = new UnwrappingEntry(clazz);
            unwrappingEntry.setTypeName(entry.getValue().get("typeName").asText());
            JsonNode requiredNode = entry.getValue().get("required");
            if (requiredNode != null) {
                unwrappingEntry.setRequired(Boolean.valueOf(requiredNode.asText()));
            }
            unwrappingMap.put(clazz, unwrappingEntry);
        }
        catch (ClassNotFoundException e) {
            String message = "Cannot load unwrapping class " + entry.getKey() + "(normal if associated with a non used library)";
            if (debug) {
                Logger.INSTANCE.getLogger().debug((CharSequence)message);
            }
            throw new RuntimeException(message, e);
        }
    }

    public DataObject unwrapDataObject(DataObject dataObject, UnwrappingType type) {
        Map<Class<?>, UnwrappingEntry> unwrappingMap = this.schemaUnwrappingMap;
        if (UnwrappingType.RESPONSE == type) {
            unwrappingMap = this.responseUnwrappingMap;
        } else if (UnwrappingType.PARAMETER == type) {
            unwrappingMap = this.parametersUnwrappingMap;
        }
        return this.unwrapDataObject(dataObject, unwrappingMap);
    }

    private DataObject unwrapDataObject(DataObject dataObject, Map<Class<?>, UnwrappingEntry> unwrappingMap) {
        for (Map.Entry<Class<?>, UnwrappingEntry> entry : unwrappingMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(dataObject.getJavaClass())) continue;
            DataObject unwrapped = new DataObject(dataObject.getGenericNameToTypeMap().get(entry.getValue().getTypeName()));
            if (dataObject.getClassRequired() != null) {
                unwrapped.setClassRequired(dataObject.getClassRequired());
            } else if (entry.getValue().getRequired() != null) {
                unwrapped.setClassRequired(entry.getValue().getRequired());
            }
            return this.unwrapDataObject(unwrapped, unwrappingMap);
        }
        return dataObject;
    }

    private void initNonDocumentableParameters(ApiConfiguration apiConfig) {
        this.nonDocumentableParameters.clear();
        ClassLoader classLoader = ReflectionsUtils.getProjectClassLoader();
        JsonNode root = YamlParserUtils.readResourceFile("/non-documentable-parameters.yml");
        root.get("common").elements().forEachRemaining(entry -> this.registerNonDocumentableParameters(classLoader, entry.asText(), true));
        if (Library.SPRING_MVC == apiConfig.getLibrary()) {
            root.get("spring").elements().forEachRemaining(entry -> this.registerNonDocumentableParameters(classLoader, entry.asText(), true));
        }
        for (String nonDocumentableParameterClass : apiConfig.getNonDocumentableParameterClasses()) {
            this.registerNonDocumentableParameters(classLoader, nonDocumentableParameterClass, false);
        }
    }

    private void registerNonDocumentableParameters(ClassLoader classLoader, String canonicalClassName, boolean debug) {
        try {
            this.nonDocumentableParameters.add(classLoader.loadClass(canonicalClassName));
        }
        catch (ClassNotFoundException e) {
            String message = "Cannot load \"non documentable\" parameter class " + canonicalClassName + "(normal if associated with a non used library)";
            if (debug) {
                Logger.INSTANCE.getLogger().debug((CharSequence)message);
            }
            throw new RuntimeException(message, e);
        }
    }

    public boolean canBeDocumented(Parameter parameter) {
        for (Class<?> clazz : this.nonDocumentableParameters) {
            if (!clazz.isAssignableFrom(parameter.getType())) continue;
            return false;
        }
        return true;
    }

    static {
        ANY_TYPE = new OpenApiResolvedType(OpenApiDataType.ANY, null, "{}", null);
        OBJECT_TYPE = new OpenApiResolvedType(OpenApiDataType.OBJECT, JsonParserUtils.parse("{\"type\":\"object\"}").get(), null, null);
    }
}

