/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import io.grpc.Status;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.lognet.springboot.grpc.recovery.GRpcExceptionScope;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class HandlerMethod {
    private final Object target;
    private final Method method;
    private final Class<? extends Throwable> exceptionType;

    private HandlerMethod() {
        throw new UnsupportedOperationException();
    }

    private HandlerMethod(Object target, Method method) {
        this.target = target;
        this.method = method;
        this.exceptionType = HandlerMethod.getHandledException(method, true).get();
    }

    public static HandlerMethod create(Object target, Method method) {
        return new HandlerMethod(target, method);
    }

    public Status invoke(Throwable e, GRpcExceptionScope scope) throws InvocationTargetException, IllegalAccessException {
        ReflectionUtils.makeAccessible((Method)this.method);
        return (Status)ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])new Object[]{e, scope});
    }

    public static Optional<Class<? extends Throwable>> getHandledException(Method method, boolean throwsException) {
        try {
            Assert.state((2 == method.getParameterCount() ? 1 : 0) != 0, () -> "There should be exactly 2 parameters on method " + method);
            Class<?>[] parameterTypes = method.getParameterTypes();
            Assert.state((boolean)Throwable.class.isAssignableFrom(parameterTypes[0]), () -> "First parameter of method " + method + " has to be of type" + Throwable.class.getName());
            Assert.state((boolean)GRpcExceptionScope.class.isAssignableFrom(parameterTypes[1]), () -> "Second parameter of method " + method + " has to be of type" + GRpcExceptionScope.class.getName());
            Assert.state((boolean)Status.class.isAssignableFrom(method.getReturnType()), () -> "Return type of method " + method + " has to be " + Status.class.getName());
            return Optional.of(parameterTypes[0]);
        }
        catch (IllegalArgumentException e) {
            if (throwsException) {
                throw e;
            }
            return Optional.empty();
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<? extends Throwable> getExceptionType() {
        return this.exceptionType;
    }
}

