/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;

public class BearerTokenAuthSchemeSelector
implements AuthenticationSchemeSelector {
    private static final Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-._~+/]+)=*$", 2);
    private static final String PREFIX = "Bearer";

    @Override
    public Optional<Authentication> getAuthScheme(CharSequence authorization) {
        if (authorization.subSequence(0, PREFIX.length()).toString().equalsIgnoreCase(PREFIX)) {
            Matcher matcher = authorizationPattern.matcher(authorization);
            if (!matcher.matches()) {
                BearerTokenError error = BearerTokenErrors.invalidToken((String)"Bearer token is malformed");
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            String token = matcher.group("token");
            return Optional.of(new BearerTokenAuthenticationToken(token));
        }
        return Optional.empty();
    }
}

