/*
 * Decompiled with CFR 0.152.
 */
package io.github.mfoo.libyear;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.plexus.util.StringUtils;
import org.json.JSONObject;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.VERIFY)
public class LibYearMojo
extends AbstractMojo {
    private static final int INFO_PAD_SIZE = 72;
    static final Map<String, Map<String, LocalDate>> dependencyVersionReleaseDates = Maps.newHashMap();
    static final AtomicLong libWeeksOutDated = new AtomicLong();
    private final CloseableHttpClient httpClient;
    static final Map<String, Float> projectAges = new ConcurrentHashMap<String, Float>();
    static final Map<String, Float> dependencyAges = new ConcurrentHashMap<String, Float>();
    private static int MAVEN_API_HTTP_RETRY_COUNT = 5;
    private static int MAVEN_API_HTTP_TIMEOUT_SECONDS = 5;
    private static String SEARCH_URI = "https://search.maven.org";
    private final RepositorySystem repositorySystem;
    private final org.eclipse.aether.RepositorySystem aetherRepositorySystem;
    private VersionsHelper helper;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Parameter(property="maven.version.ignore", readonly=true)
    protected Set<String> ignoredVersions;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(property="maxLibYears", defaultValue="0.0")
    private float maxLibYears;
    @Parameter(property="pluginManagementDependencyIncludes", defaultValue="*")
    private List<String> pluginManagementDependencyIncludes;
    @Parameter(property="pluginManagementDependencyExcludes")
    private List<String> pluginManagementDependencyExcludes;
    private final boolean processDependencyManagementTransitive = false;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processDependencies", defaultValue="true")
    protected boolean processDependencies;
    private final boolean processPluginDependenciesInPluginManagement = true;
    private final boolean processPluginDependencies = true;
    @Parameter(property="pluginDependencyIncludes", defaultValue="*")
    private List<String> pluginDependencyIncludes;
    @Parameter(property="pluginDependencyExcludes")
    private List<String> pluginDependencyExcludes;
    @Parameter(property="dependencyIncludes", defaultValue="*")
    private List<String> dependencyIncludes;
    @Parameter(property="dependencyExcludes")
    private List<String> dependencyExcludes;
    @Parameter(property="dependencyManagementIncludes", defaultValue="*")
    private List<String> dependencyManagementIncludes;
    @Parameter(property="dependencyManagementExcludes")
    private List<String> dependencyManagementExcludes;

    @Inject
    public LibYearMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem) {
        this.repositorySystem = repositorySystem;
        this.aetherRepositorySystem = aetherRepositorySystem;
        this.httpClient = this.setupHTTPClient();
    }

    private CloseableHttpClient setupHTTPClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(MAVEN_API_HTTP_TIMEOUT_SECONDS * 1000).setConnectionRequestTimeout(MAVEN_API_HTTP_TIMEOUT_SECONDS * 1000).setSocketTimeout(MAVEN_API_HTTP_TIMEOUT_SECONDS * 1000).build();
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setMaxConnPerRoute(20).setMaxConnTotal(20).setDefaultRequestConfig(config).addInterceptorLast((response, context) -> {
            if (response.getStatusLine().getStatusCode() >= 500) {
                throw new IOException(response.getStatusLine().getReasonPhrase());
            }
        }).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(MAVEN_API_HTTP_RETRY_COUNT, true)).build();
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }

    protected void setSession(MavenSession session) {
        this.session = session;
    }

    protected void setSearchUri(String uri) {
        SEARCH_URI = uri;
    }

    protected void setHttpTimeout(int seconds) {
        MAVEN_API_HTTP_TIMEOUT_SECONDS = seconds;
    }

    protected void setFetchRetryCount(int count) {
        MAVEN_API_HTTP_RETRY_COUNT = count;
    }

    private static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        return managedDependency.getGroupId().equals(dependency.getGroupId()) && managedDependency.getArtifactId().equals(dependency.getArtifactId());
    }

    public void execute() throws MojoExecutionException {
        Set dependencyManagement = Collections.emptySet();
        float thisProjectLibYearsOutdated = 0.0f;
        try {
            if (this.processDependencyManagement) {
                Set dependenciesFromDependencyManagement = MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)this.project, (boolean)false, (Log)this.getLog());
                dependencyManagement = DependencyFilter.filterDependencies((Collection)dependenciesFromDependencyManagement, this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependency Management", (Log)this.getLog());
                thisProjectLibYearsOutdated += this.processDependencyUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement.stream(), false, false), "Dependency Management");
            }
            if (this.processDependencies) {
                Set finalDependencyManagement = dependencyManagement;
                Set dependenciesExcludingOverridden = this.project.getDependencies().parallelStream().filter(dep -> finalDependencyManagement.parallelStream().noneMatch(depMan -> LibYearMojo.dependenciesMatch(dep, depMan))).collect(() -> new TreeSet(DependencyComparator.INSTANCE), Set::add, Set::addAll);
                Set dependencies = DependencyFilter.filterDependencies((Collection)dependenciesExcludingOverridden, this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)this.getLog());
                thisProjectLibYearsOutdated += this.processDependencyUpdates(this.getHelper().lookupDependenciesUpdates(dependencies.stream(), false, false), "Dependencies");
            }
            Set pluginDependenciesFromDepManagement = MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)this.project);
            Set filteredPluginDependenciesFromDepManagement = DependencyFilter.filterDependencies((Collection)pluginDependenciesFromDepManagement, this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)this.getLog());
            thisProjectLibYearsOutdated += this.processDependencyUpdates(this.getHelper().lookupDependenciesUpdates(filteredPluginDependenciesFromDepManagement.stream(), false, false), "pluginManagement of plugins");
            Set pluginDependencies = MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)this.project);
            Set filteredPluginDependencies = DependencyFilter.filterDependencies((Collection)pluginDependencies, this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)this.getLog());
            if ((thisProjectLibYearsOutdated += this.processDependencyUpdates(this.getHelper().lookupDependenciesUpdates(filteredPluginDependencies.stream(), false, false), "Plugin Dependencies")) != 0.0f) {
                this.getLog().info((CharSequence)String.format("This module is %.2f libyears behind", Float.valueOf(thisProjectLibYearsOutdated)));
            }
            if (this.maxLibYears != 0.0f && thisProjectLibYearsOutdated >= this.maxLibYears) {
                this.getLog().info((CharSequence)"");
                this.getLog().error((CharSequence)("This module exceeds the maximum dependency age of " + this.maxLibYears + " libyears"));
                throw new MojoExecutionException("Dependencies exceed maximum specified age in libyears");
            }
            projectAges.put(this.project.getName(), Float.valueOf(thisProjectLibYearsOutdated));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper.Builder().withRepositorySystem(this.repositorySystem).withAetherRepositorySystem(this.aetherRepositorySystem).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).withMavenSession(this.session).build();
        }
        return this.helper;
    }

    private float processDependencyUpdates(Map<Dependency, ArtifactVersions> updates, String section) {
        HashMap dependencyVersionUpdates = Maps.newHashMap();
        for (ArtifactVersions versions : updates.values()) {
            if (versions.getCurrentVersion() == null) continue;
            String current = versions.getCurrentVersion().toString();
            ArtifactVersion latest = versions.getNewestUpdateWithinSegment(Optional.empty(), false);
            if (latest == null || current.equals(latest.toString())) continue;
            Artifact artifact = versions.getArtifact();
            Optional<LocalDate> latestVersionReleaseDate = this.getReleaseDate(artifact.getGroupId(), artifact.getArtifactId(), latest.toString());
            Optional<LocalDate> currentVersionReleaseDate = this.getReleaseDate(artifact.getGroupId(), artifact.getArtifactId(), current);
            if (latestVersionReleaseDate.isEmpty() || currentVersionReleaseDate.isEmpty()) continue;
            String ga = String.format("%s:%s", artifact.getGroupId(), artifact.getArtifactId());
            dependencyVersionUpdates.put(ga, Pair.of((Object)currentVersionReleaseDate.get(), (Object)latestVersionReleaseDate.get()));
        }
        if (dependencyVersionUpdates.isEmpty()) {
            return 0.0f;
        }
        return this.logDependencyUpdates(section, dependencyVersionUpdates);
    }

    private float logDependencyUpdates(String pomSection, Map<String, Pair<LocalDate, LocalDate>> outdatedDependencies) {
        if (outdatedDependencies.isEmpty()) {
            return 0.0f;
        }
        Map<String, Pair> validOutdatedDependencies = outdatedDependencies.entrySet().stream().filter(dep -> {
            LocalDate latestReleaseDate;
            LocalDate currentReleaseDate = (LocalDate)((Pair)dep.getValue()).getLeft();
            return !currentReleaseDate.isAfter(latestReleaseDate = (LocalDate)((Pair)dep.getValue()).getRight());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (validOutdatedDependencies.isEmpty()) {
            return 0.0f;
        }
        float[] yearsOutdated = new float[]{0.0f};
        this.getLog().info((CharSequence)String.format("The following dependencies in %s have newer versions:", pomSection));
        validOutdatedDependencies.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(dep -> {
            LocalDate currentReleaseDate = (LocalDate)((Pair)dep.getValue()).getLeft();
            LocalDate latestReleaseDate = (LocalDate)((Pair)dep.getValue()).getRight();
            long libWeeksOutdated = ChronoUnit.WEEKS.between(currentReleaseDate, latestReleaseDate);
            float libYearsOutdated = (float)libWeeksOutdated / 52.0f;
            this.logDependencyAge((Map.Entry<String, Pair<LocalDate, LocalDate>>)dep, libYearsOutdated);
            yearsOutdated[0] = yearsOutdated[0] + libYearsOutdated;
            libWeeksOutDated.getAndAdd(libWeeksOutdated);
            if (!dependencyAges.containsKey(dep.getKey()) || dependencyAges.get(dep.getKey()).floatValue() < libYearsOutdated) {
                dependencyAges.put((String)dep.getKey(), Float.valueOf(libYearsOutdated));
            }
        });
        this.getLog().info((CharSequence)"");
        return yearsOutdated[0];
    }

    private void logDependencyAge(Map.Entry<String, Pair<LocalDate, LocalDate>> dep, float libYearsOutdated) {
        String right = String.format(" %.2f libyears", Float.valueOf(libYearsOutdated));
        String left = "  " + dep.getKey() + " ";
        if (left.length() + right.length() > 72) {
            this.getLog().info((CharSequence)left);
            String versionWithDots = StringUtils.rightPad((String)"  ", (int)(72 - right.length()), (String)".");
            this.getLog().info((CharSequence)(versionWithDots + right));
        } else {
            String versionWithDots = StringUtils.rightPad((String)left, (int)(72 - right.length()), (String)".");
            this.getLog().info((CharSequence)(versionWithDots + right));
        }
    }

    private Optional<LocalDate> getReleaseDate(String groupId, String artifactId, String version) {
        String ga = String.format("%s:%s", groupId, artifactId);
        Map<String, LocalDate> versionReleaseDates = dependencyVersionReleaseDates.getOrDefault(ga, Maps.newHashMap());
        if (versionReleaseDates.containsKey(version)) {
            return Optional.of(versionReleaseDates.get(version));
        }
        try {
            Optional<String> response = this.fetchReleaseDate(groupId, artifactId, version);
            if (response.isEmpty()) {
                return Optional.empty();
            }
            JSONObject json = new JSONObject(response.get());
            JSONObject queryResponse = json.getJSONObject("response");
            if (queryResponse.getLong("numFound") != 0L) {
                long epochTime = queryResponse.getJSONArray("docs").getJSONObject(0).getLong("timestamp");
                this.getLog().debug((CharSequence)String.format("Found release time %d for %s:%s", epochTime, ga, version));
                LocalDate releaseDate = Instant.ofEpochMilli(epochTime).atZone(ZoneId.systemDefault()).toLocalDate();
                versionReleaseDates.put(version, releaseDate);
                dependencyVersionReleaseDates.put(ga, versionReleaseDates);
                return Optional.of(releaseDate);
            }
            this.getLog().debug((CharSequence)String.format("Could not find artifact for %s %s", ga, version));
            return Optional.empty();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Failed to fetch release date for %s %s: %s", ga, version, e.getMessage()));
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> fetchReleaseDate(String groupId, String artifactId, String version) throws IOException {
        URI artifactUri = URI.create(String.format("%s/solrsearch/select?q=g:%s+AND+a:%s+AND+v:%s&wt=json", SEARCH_URI, groupId, artifactId, version));
        this.getLog().debug((CharSequence)("Fetching " + artifactUri));
        HttpGet httpGet = new HttpGet(artifactUri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);){
            if (response.getStatusLine().getStatusCode() != 200) {
                this.getLog().error((CharSequence)String.format("Failed to fetch release date for %s:%s %s (%s)", groupId, artifactId, version, response.getStatusLine().getReasonPhrase()));
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            Optional<String> optional = Optional.of(responseBody);
            return optional;
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            this.getLog().error((CharSequence)String.format("Failed to fetch release date for %s:%s %s (%s)", groupId, artifactId, version, "request timed out"));
            return Optional.empty();
        }
    }
}

