/*
 * Decompiled with CFR 0.152.
 */
package feign.hc5;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.URLEncodedUtils;

public final class ApacheHttp5Client
implements Client {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private final HttpClient client;

    public ApacheHttp5Client() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public ApacheHttp5Client(HttpClient client) {
        this.client = client;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        ClassicHttpRequest httpUriRequest;
        try {
            httpUriRequest = this.toClassicHttpRequest(request, options);
        }
        catch (URISyntaxException e) {
            throw new IOException("URL '" + request.url() + "' couldn't be parsed into a URI", e);
        }
        HttpHost target = HttpHost.create((URI)URI.create(request.url()));
        HttpClientContext context = this.configureTimeouts(options);
        ClassicHttpResponse httpResponse = (ClassicHttpResponse)this.client.execute(target, httpUriRequest, (HttpContext)context);
        return this.toFeignResponse(httpResponse, request);
    }

    protected HttpClientContext configureTimeouts(Request.Options options) {
        HttpClientContext context = new HttpClientContext();
        RequestConfig requestConfig = (this.client instanceof Configurable ? RequestConfig.copy((RequestConfig)((Configurable)this.client).getConfig()) : RequestConfig.custom()).setConnectTimeout(options.connectTimeout(), options.connectTimeoutUnit()).setResponseTimeout(options.readTimeout(), options.readTimeoutUnit()).build();
        context.setRequestConfig(requestConfig);
        return context;
    }

    /*
     * WARNING - void declaration
     */
    ClassicHttpRequest toClassicHttpRequest(Request request, Request.Options options) throws URISyntaxException {
        byte[] data;
        ClassicRequestBuilder requestBuilder = ClassicRequestBuilder.create((String)request.httpMethod().name());
        URI uri = new URIBuilder(request.url()).build();
        requestBuilder.setUri(uri.getScheme() + "://" + uri.getAuthority() + uri.getRawPath());
        List queryParams = URLEncodedUtils.parse((URI)uri, (Charset)requestBuilder.getCharset());
        for (Object queryParam : queryParams) {
            requestBuilder.addParameter((NameValuePair)queryParam);
        }
        boolean hasAcceptHeader = false;
        for (Map.Entry entry : request.headers().entrySet()) {
            String headerName = (String)entry.getKey();
            if (headerName.equalsIgnoreCase(ACCEPT_HEADER_NAME)) {
                hasAcceptHeader = true;
            }
            if (headerName.equalsIgnoreCase("Content-Length")) continue;
            for (String headerValue : (Collection)entry.getValue()) {
                requestBuilder.addHeader(headerName, headerValue);
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader(ACCEPT_HEADER_NAME, "*/*");
        }
        if ((data = request.body()) != null) {
            void var8_12;
            if (request.isBinary()) {
                ByteArrayEntity byteArrayEntity = new ByteArrayEntity(data, null);
            } else {
                ContentType contentType = this.getContentType(request);
                StringEntity stringEntity = new StringEntity(new String(data), contentType);
            }
            requestBuilder.setEntity((HttpEntity)var8_12);
        } else {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(new byte[0], null));
        }
        return requestBuilder.build();
    }

    private ContentType getContentType(Request request) {
        ContentType contentType = null;
        for (Map.Entry entry : request.headers().entrySet()) {
            Collection values;
            if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type") || (values = (Collection)entry.getValue()) == null || values.isEmpty()) continue;
            contentType = ContentType.parse((CharSequence)((CharSequence)values.iterator().next()));
            if (contentType.getCharset() != null) break;
            contentType = contentType.withCharset(request.charset());
            break;
        }
        return contentType;
    }

    Response toFeignResponse(ClassicHttpResponse httpResponse, Request request) throws IOException {
        int statusCode = httpResponse.getCode();
        String reason = httpResponse.getReasonPhrase();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (Header header : httpResponse.getHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        return Response.builder().protocolVersion((Request.ProtocolVersion)Util.enumForName(Request.ProtocolVersion.class, (Object)httpResponse.getVersion().format())).status(statusCode).reason(reason).headers(headers).request(request).body(this.toFeignBody(httpResponse)).build();
    }

    Response.Body toFeignBody(ClassicHttpResponse httpResponse) {
        final HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return new Response.Body(){

            public Integer length() {
                return entity.getContentLength() >= 0L && entity.getContentLength() <= Integer.MAX_VALUE ? Integer.valueOf((int)entity.getContentLength()) : null;
            }

            public boolean isRepeatable() {
                return entity.isRepeatable();
            }

            public InputStream asInputStream() throws IOException {
                return entity.getContent();
            }

            public Reader asReader() throws IOException {
                return new InputStreamReader(this.asInputStream(), Util.UTF_8);
            }

            public Reader asReader(Charset charset) throws IOException {
                Util.checkNotNull((Object)charset, (String)"charset should not be null", (Object[])new Object[0]);
                return new InputStreamReader(this.asInputStream(), charset);
            }

            public void close() throws IOException {
                EntityUtils.consume((HttpEntity)entity);
            }
        };
    }
}

