/*
 * Decompiled with CFR 0.152.
 */
package io.github.oshai.kotlinlogging.slf4j.internal;

import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KLoggingEventBuilder;
import io.github.oshai.kotlinlogging.KMarkerFactory;
import io.github.oshai.kotlinlogging.Level;
import io.github.oshai.kotlinlogging.Marker;
import io.github.oshai.kotlinlogging.internal.MessageInvokerKt;
import io.github.oshai.kotlinlogging.slf4j.Slf4jExtensionsKt;
import io.github.oshai.kotlinlogging.slf4j.internal.LocationAwareKLogger;
import io.github.oshai.kotlinlogging.slf4j.internal.Slf4jLogger;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.CallerBoundaryAware;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventBuilder;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J+\u0010\u001f\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J+\u0010 \u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J+\u0010!\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J+\u0010\"\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J+\u0010#\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001c\u00a2\u0006\u0002\b\u001eH\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0002J\u001f\u0010'\u001a\u00020\u0016\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020\u00162\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\"\u0010,\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J,\u0010,\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J%\u00100\u001a\u00020\u00162\u0016\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010/02\"\u0004\u0018\u00010/H\u0016\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u00162\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\"\u00104\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J,\u00104\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\b\u00105\u001a\u00020\u0016H\u0016J\u001b\u00105\u001a\u0002H(\"\u0004\b\u0000\u0010(2\u0006\u00106\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u00020\u00162\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\"\u00108\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J,\u00108\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\u0012\u00109\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010;\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010<\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001a\u0010=\u001a\u00020:2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010>\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010?\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010@\u001a\u00020:2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\"\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010C\u001a\u00020\u00162\u0006\u0010B\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u001f\u0010D\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u0002H(H\u0016\u00a2\u0006\u0002\u0010EJ\u0018\u0010F\u001a\u00020\u00162\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\"\u0010F\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J,\u0010F\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\u0018\u0010G\u001a\u00020\u00162\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J\"\u0010G\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016J,\u0010G\u001a\u00020\u00162\b\u0010*\u001a\u0004\u0018\u00010)2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010/0.H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006H"}, d2={"Lio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger;", "Lio/github/oshai/kotlinlogging/KLogger;", "Lio/github/oshai/kotlinlogging/DelegatingKLogger;", "Lorg/slf4j/spi/LocationAwareLogger;", "Lio/github/oshai/kotlinlogging/slf4j/internal/Slf4jLogger;", "underlyingLogger", "(Lorg/slf4j/spi/LocationAwareLogger;)V", "CATCHING", "Lorg/slf4j/Marker;", "ENTRY", "EXIT", "EXITMESSAGE", "", "EXITONLY", "THROWING", "fqcn", "name", "getName", "()Ljava/lang/String;", "getUnderlyingLogger", "()Lorg/slf4j/spi/LocationAwareLogger;", "at", "", "level", "Lio/github/oshai/kotlinlogging/Level;", "marker", "Lio/github/oshai/kotlinlogging/Marker;", "block", "Lkotlin/Function1;", "Lio/github/oshai/kotlinlogging/KLoggingEventBuilder;", "Lkotlin/ExtensionFunctionType;", "atDebug", "atError", "atInfo", "atTrace", "atWarn", "buildMessagePattern", "len", "", "catching", "T", "", "throwable", "(Ljava/lang/Throwable;)V", "debug", "message", "Lkotlin/Function0;", "", "entry", "arguments", "", "([Ljava/lang/Object;)V", "error", "exit", "result", "(Ljava/lang/Object;)Ljava/lang/Object;", "info", "isDebugEnabled", "", "isErrorEnabled", "isInfoEnabled", "isLoggingEnabledFor", "isLoggingOff", "isTraceEnabled", "isWarnEnabled", "logWithPayload", "kLoggingEventBuilder", "logWithoutPayload", "throwing", "(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "trace", "warn", "kotlin-logging"})
@SourceDebugExtension(value={"SMAP\nLocationAwareKLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationAwareKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,286:1\n1#2:287\n215#3,2:288\n*E\n*S KotlinDebug\n*F\n+ 1 LocationAwareKLogger.kt\nio/github/oshai/kotlinlogging/slf4j/internal/LocationAwareKLogger\n*L\n59#1,2:288\n*E\n"})
public final class LocationAwareKLogger
extends Slf4jLogger<LocationAwareLogger>
implements KLogger,
DelegatingKLogger<LocationAwareLogger> {
    private final String fqcn;
    private final org.slf4j.Marker ENTRY;
    private final org.slf4j.Marker EXIT;
    private final org.slf4j.Marker THROWING;
    private final org.slf4j.Marker CATCHING;
    private final String EXITONLY;
    private final String EXITMESSAGE;
    @NotNull
    private final LocationAwareLogger underlyingLogger;

    @Override
    @NotNull
    public String getName() {
        String string = this.getUnderlyingLogger().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"underlyingLogger.name");
        return string;
    }

    @Override
    public boolean isLoggingEnabledFor(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.isLoggingEnabledFor((Logger)this.getUnderlyingLogger(), level, marker);
    }

    @Override
    public void at(@NotNull Level level, @Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.isLoggingEnabledFor(level, marker)) {
            KLoggingEventBuilder kLoggingEventBuilder = new KLoggingEventBuilder();
            block.invoke((Object)kLoggingEventBuilder);
            KLoggingEventBuilder $this$run = kLoggingEventBuilder;
            boolean bl = false;
            if ($this$run.getPayload() != null) {
                this.logWithPayload($this$run, level, marker);
            } else {
                this.logWithoutPayload($this$run, level, marker);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logWithPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        LoggingEventBuilder builder = this.getUnderlyingLogger().atLevel(Slf4jExtensionsKt.toSlf4j(level));
        Marker marker2 = marker;
        if (marker2 != null && (marker2 = Slf4jExtensionsKt.toSlf4j(marker2)) != null) {
            Marker marker3;
            Marker it = marker3 = marker2;
            boolean bl = false;
            builder.addMarker((org.slf4j.Marker)it);
        }
        Map<String, Object> map = kLoggingEventBuilder.getPayload();
        if (map != null) {
            Map<String, Object> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> $dstr$key$value = element$iv = iterator.next();
                boolean bl = false;
                Map.Entry<String, Object> entry2 = $dstr$key$value;
                String string = entry2.getKey();
                entry2 = $dstr$key$value;
                Object value = entry2.getValue();
                builder.addKeyValue((String)key, value);
            }
        }
        builder.setCause(kLoggingEventBuilder.getCause());
        if (builder instanceof CallerBoundaryAware) {
            ((CallerBoundaryAware)builder).setCallerBoundary(this.fqcn);
        }
        builder.log(kLoggingEventBuilder.getMessage());
    }

    private final void logWithoutPayload(KLoggingEventBuilder kLoggingEventBuilder, Level level, Marker marker) {
        Marker marker2 = marker;
        this.getUnderlyingLogger().log((org.slf4j.Marker)(marker2 != null ? Slf4jExtensionsKt.toSlf4j(marker2) : null), this.fqcn, Slf4jExtensionsKt.toSlf4j(level).toInt(), kLoggingEventBuilder.getMessage(), null, kLoggingEventBuilder.getCause());
    }

    @Override
    public <T extends Throwable> void catching(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        if (this.getUnderlyingLogger().isErrorEnabled()) {
            this.getUnderlyingLogger().log(this.CATCHING, this.fqcn, 40, "catching", null, throwable);
        }
    }

    @Override
    public boolean isTraceEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.TRACE, marker);
    }

    @Override
    public boolean isDebugEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.DEBUG, marker);
    }

    @Override
    public boolean isInfoEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.INFO, marker);
    }

    @Override
    public boolean isWarnEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.WARN, marker);
    }

    @Override
    public boolean isErrorEnabled(@Nullable Marker marker) {
        return this.isLoggingEnabledFor(Level.ERROR, marker);
    }

    @Override
    public boolean isLoggingOff(@Nullable Marker marker) {
        return !this.isLoggingEnabledFor(Level.ERROR, marker);
    }

    @Override
    public void entry(Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        if (this.getUnderlyingLogger().isTraceEnabled(this.ENTRY)) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)this.buildMessagePattern(arguments.length), (Object[])arguments);
            LocationAwareLogger locationAwareLogger = this.getUnderlyingLogger();
            FormattingTuple formattingTuple = tp;
            Intrinsics.checkNotNullExpressionValue((Object)formattingTuple, (String)"tp");
            locationAwareLogger.log(this.ENTRY, this.fqcn, 0, formattingTuple.getMessage(), null, null);
        }
    }

    @Override
    public void exit() {
        if (this.getUnderlyingLogger().isTraceEnabled(this.EXIT)) {
            this.getUnderlyingLogger().log(this.EXIT, this.fqcn, 0, this.EXITONLY, null, null);
        }
    }

    @Override
    public <T> T exit(T result) {
        if (this.getUnderlyingLogger().isTraceEnabled(this.EXIT)) {
            FormattingTuple tp = MessageFormatter.format((String)this.EXITMESSAGE, result);
            LocationAwareLogger locationAwareLogger = this.getUnderlyingLogger();
            FormattingTuple formattingTuple = tp;
            Intrinsics.checkNotNullExpressionValue((Object)formattingTuple, (String)"tp");
            locationAwareLogger.log(this.EXIT, this.fqcn, 0, formattingTuple.getMessage(), new Object[]{result}, tp.getThrowable());
        }
        return result;
    }

    @Override
    @NotNull
    public <T extends Throwable> T throwing(@NotNull T throwable) {
        Intrinsics.checkNotNullParameter(throwable, (String)"throwable");
        this.getUnderlyingLogger().log(this.THROWING, this.fqcn, 40, "throwing", null, throwable);
        return throwable;
    }

    private final String buildMessagePattern(int len) {
        int n = 1;
        return CollectionsKt.joinToString$default((Iterable)((Iterable)new IntRange(n, len)), (CharSequence)", ", (CharSequence)"entry with (", (CharSequence)")", (int)0, null, (Function1)buildMessagePattern.1.INSTANCE, (int)24, null);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.TRACE, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message){
            final /* synthetic */ Function0 $message;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
            }
            {
                this.$message = function0;
                super(1);
            }
        }));
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message){
            final /* synthetic */ Function0 $message;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
            }
            {
                this.$message = function0;
                super(1);
            }
        }));
    }

    @Override
    public void info(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message){
            final /* synthetic */ Function0 $message;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
            }
            {
                this.$message = function0;
                super(1);
            }
        }));
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message){
            final /* synthetic */ Function0 $message;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
            }
            {
                this.$message = function0;
                super(1);
            }
        }));
    }

    @Override
    public void error(@NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message){
            final /* synthetic */ Function0 $message;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
            }
            {
                this.$message = function0;
                super(1);
            }
        }));
    }

    @Override
    public void trace(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KLogger.DefaultImpls.at$default(this, Level.TRACE, null, (Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }, 2, null);
    }

    @Override
    public void debug(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void info(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void warn(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void error(@Nullable Throwable throwable, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, null, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void trace(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.TRACE, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void debug(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.DEBUG, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void info(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.INFO, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void warn(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.WARN, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void error(@Nullable Throwable throwable, @Nullable Marker marker, @NotNull Function0<? extends Object> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.at(Level.ERROR, marker, (Function1<? super KLoggingEventBuilder, Unit>)((Function1)new Function1<KLoggingEventBuilder, Unit>(message, throwable){
            final /* synthetic */ Function0 $message;
            final /* synthetic */ Throwable $throwable;

            public final void invoke(@NotNull KLoggingEventBuilder $this$at) {
                Intrinsics.checkNotNullParameter((Object)$this$at, (String)"$receiver");
                $this$at.setMessage(MessageInvokerKt.toStringSafe((Function0<? extends Object>)this.$message));
                $this$at.setCause(this.$throwable);
            }
            {
                this.$message = function0;
                this.$throwable = throwable;
                super(1);
            }
        }));
    }

    @Override
    public void atTrace(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.TRACE, marker, block);
    }

    @Override
    public void atDebug(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.DEBUG, marker, block);
    }

    @Override
    public void atInfo(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.INFO, marker, block);
    }

    @Override
    public void atWarn(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.WARN, marker, block);
    }

    @Override
    public void atError(@Nullable Marker marker, @NotNull Function1<? super KLoggingEventBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.at(Level.ERROR, marker, block);
    }

    @Override
    @NotNull
    public LocationAwareLogger getUnderlyingLogger() {
        return this.underlyingLogger;
    }

    public LocationAwareKLogger(@NotNull LocationAwareLogger underlyingLogger) {
        Intrinsics.checkNotNullParameter((Object)underlyingLogger, (String)"underlyingLogger");
        this.underlyingLogger = underlyingLogger;
        String string = LocationAwareKLogger.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LocationAwareKLogger::class.java.name");
        this.fqcn = string;
        this.ENTRY = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("ENTRY"));
        this.EXIT = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("EXIT"));
        this.THROWING = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("THROWING"));
        this.CATCHING = Slf4jExtensionsKt.toSlf4j(KMarkerFactory.INSTANCE.getMarker("CATCHING"));
        this.EXITONLY = "exit";
        this.EXITMESSAGE = "exit with ({})";
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(imports={}, expression="trace(null, marker, msg)"))
    public void trace(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use trace instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t, marker, msg)"))
    public void trace(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.trace((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace { \"$msg\"}"))
    public void trace(@Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t) { \"$msg\"}"))
    public void trace(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(marker) { \"$msg\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use trace {} instead", replaceWith=@ReplaceWith(imports={}, expression="trace(t, marker) { \"$msg\"}"))
    public void trace(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.trace((KLogger)this, marker, msg, t);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(imports={}, expression="debug(null, marker, msg)"))
    public void debug(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use debug instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t, marker, msg)"))
    public void debug(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.debug((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug { msg }"))
    public void debug(@Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t) { \"$msg\"}"))
    public void debug(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(marker) { \"$msg\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use debug {} instead", replaceWith=@ReplaceWith(imports={}, expression="debug(t, marker) { \"$msg\"}"))
    public void debug(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.debug((KLogger)this, marker, msg, t);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(imports={}, expression="info(null, marker, msg)"))
    public void info(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use info instead", replaceWith=@ReplaceWith(imports={}, expression="info(t, marker, msg)"))
    public void info(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.info((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info { msg }"))
    public void info(@Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(t) { \"$msg\"}"))
    public void info(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(marker) { \"$msg\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use info {} instead", replaceWith=@ReplaceWith(imports={}, expression="info(t, marker) { \"$msg\"}"))
    public void info(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.info((KLogger)this, marker, msg, t);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(imports={}, expression="warn(null, marker, msg)"))
    public void warn(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use warn instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t, marker, msg)"))
    public void warn(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.warn((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn { msg }"))
    public void warn(@Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t) { \"$msg\"}"))
    public void warn(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(marker) { \"$msg\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use warn {} instead", replaceWith=@ReplaceWith(imports={}, expression="warn(t, marker) { \"$msg\"}"))
    public void warn(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.warn((KLogger)this, marker, msg, t);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(null, marker, msg)"))
    public void error(@Nullable Marker marker, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(t, marker, msg)"))
    public void error(@Nullable Marker marker, @Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        KLogger.DefaultImpls.error((KLogger)this, marker, t, msg);
    }

    @Override
    @Deprecated(message="Use error {} instead", replaceWith=@ReplaceWith(imports={}, expression="error { msg }"))
    public void error(@Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, msg);
    }

    @Override
    @Deprecated(message="Use error(t){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(t) { \"$msg\"}"))
    public void error(@Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, msg, t);
    }

    @Override
    @Deprecated(message="Use error(marker){} instead", replaceWith=@ReplaceWith(imports={}, expression="error(marker) { \"$msg\"}"))
    public void error(@Nullable Marker marker, @Nullable String msg) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg);
    }

    @Override
    @Deprecated(message="Use error instead", replaceWith=@ReplaceWith(imports={}, expression="error(t, marker, msg)"))
    public void error(@Nullable Marker marker, @Nullable String msg, @Nullable Throwable t) {
        KLogger.DefaultImpls.error((KLogger)this, marker, msg, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return KLogger.DefaultImpls.isTraceEnabled(this);
    }

    @Override
    public boolean isDebugEnabled() {
        return KLogger.DefaultImpls.isDebugEnabled(this);
    }

    @Override
    public boolean isInfoEnabled() {
        return KLogger.DefaultImpls.isInfoEnabled(this);
    }

    @Override
    public boolean isWarnEnabled() {
        return KLogger.DefaultImpls.isWarnEnabled(this);
    }

    @Override
    public boolean isErrorEnabled() {
        return KLogger.DefaultImpls.isErrorEnabled(this);
    }

    @Override
    public boolean isLoggingOff() {
        return KLogger.DefaultImpls.isLoggingOff(this);
    }
}

