/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.security_scheme.oauth2.flows;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.model.security_scheme.oauth2.flows.OAuthFlow;
import jakarta.validation.constraints.NotNull;
import java.util.Map;

public class ClientCredentialsOAuthFlow
extends OAuthFlow {
    @NotNull
    @JsonProperty(value="tokenUrl")
    private String tokenUrl;

    public ClientCredentialsOAuthFlow(String refreshUrl, @NotNull Map<String, String> availableScopes, @NotNull String tokenUrl) {
        super(refreshUrl, availableScopes);
        this.tokenUrl = tokenUrl;
    }

    public static ClientCredentialsOAuthFlowBuilder clientCredentialsBuilder() {
        return new ClientCredentialsOAuthFlowBuilder();
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @JsonProperty(value="tokenUrl")
    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @Override
    public String toString() {
        return "ClientCredentialsOAuthFlow(tokenUrl=" + this.getTokenUrl() + ")";
    }

    public ClientCredentialsOAuthFlow() {
    }

    public ClientCredentialsOAuthFlow(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientCredentialsOAuthFlow)) {
            return false;
        }
        ClientCredentialsOAuthFlow other = (ClientCredentialsOAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tokenUrl = this.getTokenUrl();
        String other$tokenUrl = other.getTokenUrl();
        return !(this$tokenUrl == null ? other$tokenUrl != null : !this$tokenUrl.equals(other$tokenUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClientCredentialsOAuthFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tokenUrl = this.getTokenUrl();
        result = result * 59 + ($tokenUrl == null ? 43 : $tokenUrl.hashCode());
        return result;
    }

    public static class ClientCredentialsOAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> availableScopes;
        private String tokenUrl;

        ClientCredentialsOAuthFlowBuilder() {
        }

        public ClientCredentialsOAuthFlowBuilder refreshUrl(String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public ClientCredentialsOAuthFlowBuilder availableScopes(Map<String, String> availableScopes) {
            this.availableScopes = availableScopes;
            return this;
        }

        public ClientCredentialsOAuthFlowBuilder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public ClientCredentialsOAuthFlow build() {
            return new ClientCredentialsOAuthFlow(this.refreshUrl, this.availableScopes, this.tokenUrl);
        }

        public String toString() {
            return "ClientCredentialsOAuthFlow.ClientCredentialsOAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", availableScopes=" + this.availableScopes + ", tokenUrl=" + this.tokenUrl + ")";
        }
    }
}

