/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.github.stavshamir.springwolf.asyncapi.AsyncApiSerializerService;
import io.github.stavshamir.springwolf.asyncapi.types.AsyncAPI;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import jakarta.annotation.PostConstruct;

public class DefaultAsyncApiSerializerService
implements AsyncApiSerializerService {
    private ObjectMapper jsonMapper = Json.mapper();
    private ObjectMapper yamlMapper = Yaml.mapper();
    private PrettyPrinter printer = new CustomPrettyPrinter();

    @PostConstruct
    void postConstruct() {
        this.jsonMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        this.yamlMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        ((YAMLFactory)this.yamlMapper.getFactory()).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
    }

    @Override
    public String toJsonString(AsyncAPI asyncAPI) throws JsonProcessingException {
        return this.jsonMapper.writer(this.printer).writeValueAsString((Object)asyncAPI);
    }

    @Override
    public String toYaml(AsyncAPI asyncAPI) throws JsonProcessingException {
        return this.yamlMapper.writer(this.printer).writeValueAsString((Object)asyncAPI);
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonMapper;
    }

    public ObjectMapper getYamlObjectMapper() {
        return this.yamlMapper;
    }

    public void setJsonObjectMapper(ObjectMapper mapper) {
        this.jsonMapper = mapper;
    }

    public void setYamlObjectMapper(ObjectMapper mapper) {
        this.yamlMapper = mapper;
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.printer = prettyPrinter;
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        public CustomPrettyPrinter() {
            this._arrayIndenter = new DefaultIndenter();
            this._objectFieldValueSeparatorWithSpaces = this._separators.getObjectFieldValueSeparator() + " ";
        }

        public CustomPrettyPrinter createInstance() {
            return new CustomPrettyPrinter();
        }
    }
}

