/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels;

import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import io.github.stavshamir.springwolf.asyncapi.MessageHelper;
import io.github.stavshamir.springwolf.asyncapi.types.channel.operation.message.Message;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ChannelMerger {
    public static Map<String, ChannelItem> merge(List<Map.Entry<String, ChannelItem>> channelEntries) {
        HashMap<String, ChannelItem> mergedChannels = new HashMap<String, ChannelItem>();
        for (Map.Entry<String, ChannelItem> entry : channelEntries) {
            if (!mergedChannels.containsKey(entry.getKey())) {
                mergedChannels.put(entry.getKey(), entry.getValue());
                continue;
            }
            ChannelItem channelItem = (ChannelItem)mergedChannels.get(entry.getKey());
            channelItem.setPublish(ChannelMerger.mergeOperation(channelItem.getPublish(), entry.getValue().getPublish()));
            channelItem.setSubscribe(ChannelMerger.mergeOperation(channelItem.getSubscribe(), entry.getValue().getSubscribe()));
        }
        return mergedChannels;
    }

    private static Operation mergeOperation(Operation operation, Operation otherOperation) {
        Operation mergedOperation = operation != null ? operation : otherOperation;
        Set<Message> mergedMessages = ChannelMerger.mergeMessages(ChannelMerger.getMessages(operation), ChannelMerger.getMessages(otherOperation));
        if (!mergedMessages.isEmpty()) {
            mergedOperation.setMessage(MessageHelper.toMessageObjectOrComposition(mergedMessages));
        }
        return mergedOperation;
    }

    private static Set<Message> mergeMessages(Set<Message> messages, Set<Message> otherMessages) {
        Map nameToMessage = messages.stream().collect(Collectors.toMap(Message::getName, Function.identity()));
        for (Message otherMessage : otherMessages) {
            nameToMessage.putIfAbsent(otherMessage.getName(), otherMessage);
        }
        return new HashSet<Message>(nameToMessage.values());
    }

    private static Set<Message> getMessages(Operation operation) {
        return Optional.ofNullable(operation).map(Operation::getMessage).map(MessageHelper::messageObjectToSet).orElseGet(HashSet::new);
    }
}

