/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.configuration;

import com.asyncapi.v2._6_0.model.info.Info;
import com.asyncapi.v2._6_0.model.server.Server;
import io.github.stavshamir.springwolf.asyncapi.types.ConsumerData;
import io.github.stavshamir.springwolf.asyncapi.types.ProducerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class AsyncApiDocket {
    private final String basePackage;
    @NonNull
    private final Info info;
    private final Map<String, Server> servers;
    @Deprecated(forRemoval=true)
    private final List<ProducerData> producers;
    @Deprecated(forRemoval=true)
    private final List<ConsumerData> consumers;
    private final String defaultContentType;
    private final String id;

    private static String $default$defaultContentType() {
        return "application/json";
    }

    AsyncApiDocket(String basePackage, @NonNull Info info, Map<String, Server> servers, List<ProducerData> producers, List<ConsumerData> consumers, String defaultContentType, String id) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.basePackage = basePackage;
        this.info = info;
        this.servers = servers;
        this.producers = producers;
        this.consumers = consumers;
        this.defaultContentType = defaultContentType;
        this.id = id;
    }

    public static AsyncApiDocketBuilder builder() {
        return new AsyncApiDocketBuilder();
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    @NonNull
    public Info getInfo() {
        return this.info;
    }

    public Map<String, Server> getServers() {
        return this.servers;
    }

    @Deprecated
    public List<ProducerData> getProducers() {
        return this.producers;
    }

    @Deprecated
    public List<ConsumerData> getConsumers() {
        return this.consumers;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncApiDocket)) {
            return false;
        }
        AsyncApiDocket other = (AsyncApiDocket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        Info this$info = this.getInfo();
        Info other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        Map<String, Server> this$servers = this.getServers();
        Map<String, Server> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        List<ProducerData> this$producers = this.getProducers();
        List<ProducerData> other$producers = other.getProducers();
        if (this$producers == null ? other$producers != null : !((Object)this$producers).equals(other$producers)) {
            return false;
        }
        List<ConsumerData> this$consumers = this.getConsumers();
        List<ConsumerData> other$consumers = other.getConsumers();
        if (this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers)) {
            return false;
        }
        String this$defaultContentType = this.getDefaultContentType();
        String other$defaultContentType = other.getDefaultContentType();
        if (this$defaultContentType == null ? other$defaultContentType != null : !this$defaultContentType.equals(other$defaultContentType)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncApiDocket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        Info $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        Map<String, Server> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        List<ProducerData> $producers = this.getProducers();
        result = result * 59 + ($producers == null ? 43 : ((Object)$producers).hashCode());
        List<ConsumerData> $consumers = this.getConsumers();
        result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
        String $defaultContentType = this.getDefaultContentType();
        result = result * 59 + ($defaultContentType == null ? 43 : $defaultContentType.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncApiDocket(basePackage=" + this.getBasePackage() + ", info=" + this.getInfo() + ", servers=" + this.getServers() + ", producers=" + this.getProducers() + ", consumers=" + this.getConsumers() + ", defaultContentType=" + this.getDefaultContentType() + ", id=" + this.getId() + ")";
    }

    public static class AsyncApiDocketBuilder {
        private String basePackage;
        private Info info;
        private ArrayList<String> servers$key;
        private ArrayList<Server> servers$value;
        private ArrayList<ProducerData> producers;
        private ArrayList<ConsumerData> consumers;
        private boolean defaultContentType$set;
        private String defaultContentType$value;
        private String id;

        AsyncApiDocketBuilder() {
        }

        public AsyncApiDocketBuilder basePackage(String basePackage) {
            this.basePackage = basePackage;
            return this;
        }

        public AsyncApiDocketBuilder info(@NonNull Info info) {
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.info = info;
            return this;
        }

        public AsyncApiDocketBuilder server(String serverKey, Server serverValue) {
            if (this.servers$key == null) {
                this.servers$key = new ArrayList();
                this.servers$value = new ArrayList();
            }
            this.servers$key.add(serverKey);
            this.servers$value.add(serverValue);
            return this;
        }

        public AsyncApiDocketBuilder servers(Map<? extends String, ? extends Server> servers) {
            if (servers == null) {
                throw new NullPointerException("servers cannot be null");
            }
            if (this.servers$key == null) {
                this.servers$key = new ArrayList();
                this.servers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Server> $lombokEntry : servers.entrySet()) {
                this.servers$key.add($lombokEntry.getKey());
                this.servers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public AsyncApiDocketBuilder clearServers() {
            if (this.servers$key != null) {
                this.servers$key.clear();
                this.servers$value.clear();
            }
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder producer(ProducerData producer) {
            if (this.producers == null) {
                this.producers = new ArrayList();
            }
            this.producers.add(producer);
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder producers(Collection<? extends ProducerData> producers) {
            if (producers == null) {
                throw new NullPointerException("producers cannot be null");
            }
            if (this.producers == null) {
                this.producers = new ArrayList();
            }
            this.producers.addAll(producers);
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder clearProducers() {
            if (this.producers != null) {
                this.producers.clear();
            }
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder consumer(ConsumerData consumer) {
            if (this.consumers == null) {
                this.consumers = new ArrayList();
            }
            this.consumers.add(consumer);
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder consumers(Collection<? extends ConsumerData> consumers) {
            if (consumers == null) {
                throw new NullPointerException("consumers cannot be null");
            }
            if (this.consumers == null) {
                this.consumers = new ArrayList();
            }
            this.consumers.addAll(consumers);
            return this;
        }

        @Deprecated
        public AsyncApiDocketBuilder clearConsumers() {
            if (this.consumers != null) {
                this.consumers.clear();
            }
            return this;
        }

        public AsyncApiDocketBuilder defaultContentType(String defaultContentType) {
            this.defaultContentType$value = defaultContentType;
            this.defaultContentType$set = true;
            return this;
        }

        public AsyncApiDocketBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AsyncApiDocket build() {
            Map<Object, Object> servers;
            switch (this.servers$key == null ? 0 : this.servers$key.size()) {
                case 0: {
                    servers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    servers = Collections.singletonMap(this.servers$key.get(0), this.servers$value.get(0));
                    break;
                }
                default: {
                    servers = new LinkedHashMap(this.servers$key.size() < 0x40000000 ? 1 + this.servers$key.size() + (this.servers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.servers$key.size(); ++$i) {
                        servers.put(this.servers$key.get($i), this.servers$value.get($i));
                    }
                    servers = Collections.unmodifiableMap(servers);
                }
            }
            List<ProducerData> producers = switch (this.producers == null ? 0 : this.producers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.producers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ProducerData>(this.producers));
            };
            List<ConsumerData> consumers = switch (this.consumers == null ? 0 : this.consumers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.consumers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ConsumerData>(this.consumers));
            };
            String defaultContentType$value = this.defaultContentType$value;
            if (!this.defaultContentType$set) {
                defaultContentType$value = AsyncApiDocket.$default$defaultContentType();
            }
            return new AsyncApiDocket(this.basePackage, this.info, servers, producers, consumers, defaultContentType$value, this.id);
        }

        public String toString() {
            return "AsyncApiDocket.AsyncApiDocketBuilder(basePackage=" + this.basePackage + ", info=" + this.info + ", servers$key=" + this.servers$key + ", servers$value=" + this.servers$value + ", producers=" + this.producers + ", consumers=" + this.consumers + ", defaultContentType$value=" + this.defaultContentType$value + ", id=" + this.id + ")";
        }
    }
}

