/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.schemas.example;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import io.github.stavshamir.springwolf.schemas.example.ExampleGenerator;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(name={"springwolf.example-generator"}, havingValue="buildin-json", matchIfMissing=true)
public class ExampleJsonGenerator
implements ExampleGenerator {
    private static final Logger log = LoggerFactory.getLogger(ExampleJsonGenerator.class);
    private static final ObjectMapper objectMapper = Json.mapper();
    private static final Double DEFAULT_NUMBER_EXAMPLE = 1.1;
    private static final Integer DEFAULT_INTEGER_EXAMPLE = 0;
    private static final BooleanNode DEFAULT_BOOLEAN_EXAMPLE = BooleanNode.TRUE;
    private static final String DEFAULT_DATE_EXAMPLE = "2015-07-20";
    private static final String DEFAULT_DATE_TIME_EXAMPLE = "2015-07-20T15:49:04-07:00";
    private static final String DEFAULT_PASSWORD_EXAMPLE = "string-password";
    private static final String DEFAULT_BYTE_EXAMPLE = "YmFzZTY0LWV4YW1wbGU=";
    private static final String DEFAULT_BINARY_EXAMPLE = "0111010001100101011100110111010000101101011000100110100101101110011000010110010001111001";
    private static final String DEFAULT_STRING_EXAMPLE = "string";
    private static final String DEFAULT_EMAIL_EXAMPLE = "example@example.com";
    private static final String DEFAULT_UUID_EXAMPLE = "3fa85f64-5717-4562-b3fc-2c963f66afa6";

    private static String DEFAULT_UNKNOWN_SCHEMA_EXAMPLE(String type) {
        return "unknown schema type: " + type;
    }

    private static String DEFAULT_UNKNOWN_SCHEMA_STRING_EXAMPLE(String format) {
        return "unknown string schema format: " + format;
    }

    @Override
    public Object fromSchema(Schema schema, Map<String, Schema> definitions) {
        try {
            return ExampleJsonGenerator.buildSchemaInternal(schema, definitions, new HashSet<Schema>());
        }
        catch (ExampleGenerator.ExampleGeneratingException ex) {
            log.info("Failed to build json example for schema {}", (Object)schema.getName(), (Object)ex);
            return null;
        }
    }

    static String buildSchema(Schema schema, Map<String, Schema> definitions) {
        return ExampleJsonGenerator.buildSchemaInternal(schema, definitions, new HashSet<Schema>()).toString();
    }

    private static JsonNode buildSchemaInternal(Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        String type;
        JsonNode exampleValue = ExampleJsonGenerator.getExampleValueFromSchemaAnnotation(schema);
        if (exampleValue != null) {
            return exampleValue;
        }
        String ref = schema.get$ref();
        if (ref != null) {
            String schemaName = StringUtils.substringAfterLast((String)ref, (String)"/");
            Schema resolvedSchema = definitions.get(schemaName);
            if (resolvedSchema == null) {
                throw new ExampleGenerator.ExampleGeneratingException("Missing schema during example json generation: " + schemaName);
            }
            return ExampleJsonGenerator.buildSchemaInternal(resolvedSchema, definitions, visited);
        }
        return switch (type = schema.getType()) {
            case "array" -> ExampleJsonGenerator.handleArraySchema(schema, definitions, visited);
            case "boolean" -> DEFAULT_BOOLEAN_EXAMPLE;
            case "integer" -> new IntNode(DEFAULT_INTEGER_EXAMPLE.intValue());
            case "number" -> new DoubleNode(DEFAULT_NUMBER_EXAMPLE.doubleValue());
            case "object" -> ExampleJsonGenerator.handleObject(schema, definitions, visited);
            case DEFAULT_STRING_EXAMPLE -> JsonNodeFactory.instance.textNode(ExampleJsonGenerator.handleStringSchema(schema));
            default -> JsonNodeFactory.instance.textNode(ExampleJsonGenerator.DEFAULT_UNKNOWN_SCHEMA_EXAMPLE(type));
        };
    }

    private static JsonNode getExampleValueFromSchemaAnnotation(Schema schema) {
        StringSchema additionalPropertiesSchema;
        Object exampleValueString;
        Object exampleValue = schema.getExample();
        if (exampleValue == null) {
            return null;
        }
        if (exampleValue instanceof JsonNode) {
            return (JsonNode)exampleValue;
        }
        ObjectNode exampleNode = objectMapper.createObjectNode();
        Object additionalProperties = schema.getAdditionalProperties();
        if (additionalProperties instanceof StringSchema && (exampleValueString = (additionalPropertiesSchema = (StringSchema)additionalProperties).getExample()) != null) {
            try {
                exampleNode = objectMapper.readTree(exampleValueString.toString());
            }
            catch (JsonProcessingException ex) {
                log.debug("Unable to convert example to JSON: %s".formatted(exampleValue.toString()), (Throwable)ex);
            }
            return exampleNode;
        }
        if (exampleValue instanceof Map) {
            return null;
        }
        if (exampleValue instanceof Boolean) {
            return (Boolean)exampleValue != false ? BooleanNode.TRUE : BooleanNode.FALSE;
        }
        if (exampleValue instanceof Number) {
            double doubleValue = ((Number)exampleValue).doubleValue();
            if (doubleValue == (double)((int)doubleValue)) {
                return new IntNode((int)doubleValue);
            }
            return new DoubleNode(doubleValue);
        }
        try {
            exampleNode = JsonNodeFactory.instance.textNode(exampleValue.toString());
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to convert example to JSON: %s".formatted(exampleValue.toString()), (Throwable)ex);
        }
        return exampleNode;
    }

    private static ArrayNode handleArraySchema(Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        List<JsonNode> list = Arrays.asList(ExampleJsonGenerator.buildSchemaInternal(schema.getItems(), definitions, visited));
        for (JsonNode node : list) {
            arrayNode.add(node);
        }
        return arrayNode;
    }

    private static String handleStringSchema(Schema schema) {
        String firstEnumValue = ExampleJsonGenerator.getFirstEnumValue(schema);
        if (firstEnumValue != null) {
            return firstEnumValue;
        }
        String format = schema.getFormat();
        if (format == null) {
            return DEFAULT_STRING_EXAMPLE;
        }
        return switch (format) {
            case "date" -> DEFAULT_DATE_EXAMPLE;
            case "date-time" -> DEFAULT_DATE_TIME_EXAMPLE;
            case "email" -> DEFAULT_EMAIL_EXAMPLE;
            case "password" -> DEFAULT_PASSWORD_EXAMPLE;
            case "byte" -> DEFAULT_BYTE_EXAMPLE;
            case "binary" -> DEFAULT_BINARY_EXAMPLE;
            case "uuid" -> DEFAULT_UUID_EXAMPLE;
            default -> ExampleJsonGenerator.DEFAULT_UNKNOWN_SCHEMA_STRING_EXAMPLE(format);
        };
    }

    private static String getFirstEnumValue(Schema schema) {
        Optional firstEnumEntry;
        List enums = schema.getEnum();
        if (enums != null && (firstEnumEntry = enums.stream().findFirst()).isPresent()) {
            return (String)firstEnumEntry.get();
        }
        return null;
    }

    private static JsonNode handleObject(Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        Map properties = schema.getProperties();
        if (properties != null && !visited.contains(schema)) {
            visited.add(schema);
            ObjectNode example = ExampleJsonGenerator.handleObjectProperties(properties, definitions, visited);
            visited.remove(schema);
            return example;
        }
        if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
            List schemas = schema.getAllOf();
            return ExampleJsonGenerator.buildSchemaInternal((Schema)schemas.get(0), definitions, visited);
        }
        if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
            List schemas = schema.getAnyOf();
            return ExampleJsonGenerator.buildSchemaInternal((Schema)schemas.get(0), definitions, visited);
        }
        if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
            List schemas = schema.getOneOf();
            return ExampleJsonGenerator.buildSchemaInternal((Schema)schemas.get(0), definitions, visited);
        }
        return objectMapper.createObjectNode();
    }

    private static ObjectNode handleObjectProperties(Map<String, Schema> properties, Map<String, Schema> definitions, Set<Schema> visited) {
        ObjectNode objectNode = objectMapper.createObjectNode();
        properties.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            String propertyKey = (String)entry.getKey();
            RawValue propertyRawValue = new RawValue((JsonSerializable)ExampleJsonGenerator.buildSchemaInternal((Schema)entry.getValue(), definitions, visited));
            objectNode.putRawValue(propertyKey, propertyRawValue);
        });
        return objectNode;
    }
}

