/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.schemas.postprocessor;

import io.github.stavshamir.springwolf.schemas.example.ExampleGenerator;
import io.github.stavshamir.springwolf.schemas.postprocessor.SchemasPostProcessor;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGeneratorPostProcessor
implements SchemasPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExampleGeneratorPostProcessor.class);
    private final ExampleGenerator exampleGenerator;

    @Override
    public void process(Schema schema, Map<String, Schema> definitions) {
        if (schema.getExample() == null) {
            log.debug("Generate example for {}", (Object)schema.getName());
            Object example = this.exampleGenerator.fromSchema(schema, definitions);
            schema.setExample(example);
        }
    }

    public ExampleGeneratorPostProcessor(ExampleGenerator exampleGenerator) {
        this.exampleGenerator = exampleGenerator;
    }
}

