/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.examples.walkers;

import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.core.asyncapi.components.examples.walkers.ExampleValueGenerator;
import io.github.springwolf.core.asyncapi.components.examples.walkers.PropertyExample;
import io.github.springwolf.core.asyncapi.components.examples.walkers.SchemaWalker;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaWalker<T, R>
implements SchemaWalker<R> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemaWalker.class);
    private final ExampleValueGenerator<T, R> exampleValueGenerator;

    @Override
    public boolean canHandle(String contentType) {
        return this.exampleValueGenerator.canHandle(contentType);
    }

    @Override
    public R fromSchema(Schema schema, Map<String, Schema> definitions) {
        this.exampleValueGenerator.initialize();
        String schemaName = this.exampleValueGenerator.lookupSchemaName(schema);
        try {
            T generatedExample = this.buildExample(schemaName, schema, definitions, new HashSet<Schema>());
            return this.exampleValueGenerator.prepareForSerialization(schema, generatedExample);
        }
        catch (SchemaWalker.ExampleGeneratingException ex) {
            log.info("Failed to build example for schema {}", (Object)schemaName, (Object)ex);
            return null;
        }
    }

    private T buildExample(String name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        String type;
        T exampleValue = this.getExampleValueFromSchemaAnnotation(schema);
        if (exampleValue != null) {
            return exampleValue;
        }
        Optional<Schema<?>> resolvedSchema = this.resolveSchemaFromRef(schema, definitions);
        if (resolvedSchema.isPresent()) {
            return this.buildExample(name, resolvedSchema.get(), definitions, visited);
        }
        return switch (type = schema.getType()) {
            case "array" -> this.buildArrayExample(schema, definitions, visited);
            case "boolean" -> this.exampleValueGenerator.createBooleanExample();
            case "integer" -> this.exampleValueGenerator.createIntegerExample();
            case "number" -> this.exampleValueGenerator.createDoubleExample();
            case "object" -> this.buildFromObjectSchema(name, schema, definitions, visited);
            case "string" -> this.buildFromStringSchema(schema);
            default -> this.exampleValueGenerator.createUnknownSchemaStringTypeExample(type);
        };
    }

    private T getExampleValueFromSchemaAnnotation(Schema schema) {
        StringSchema additionalPropertiesSchema;
        Object exampleValueString;
        Object exampleValue = schema.getExample();
        if (exampleValue == null) {
            return null;
        }
        T processedExample = this.exampleValueGenerator.getExampleOrNull(this.exampleValueGenerator.lookupSchemaName(schema), exampleValue);
        if (processedExample != null) {
            return processedExample;
        }
        Object additionalProperties = schema.getAdditionalProperties();
        if (additionalProperties instanceof StringSchema && (exampleValueString = (additionalPropertiesSchema = (StringSchema)additionalProperties).getExample()) != null) {
            return this.exampleValueGenerator.createRaw(exampleValueString);
        }
        if (exampleValue instanceof Map) {
            return null;
        }
        if (exampleValue instanceof Boolean) {
            return this.exampleValueGenerator.createBooleanExample((Boolean)exampleValue);
        }
        if (exampleValue instanceof Number) {
            double doubleValue = ((Number)exampleValue).doubleValue();
            if (doubleValue == (double)((int)doubleValue)) {
                return this.exampleValueGenerator.createIntegerExample((int)doubleValue);
            }
            return this.exampleValueGenerator.createDoubleExample(doubleValue);
        }
        try {
            return this.exampleValueGenerator.createStringExample(exampleValue.toString());
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to convert example to JSON: %s".formatted(exampleValue.toString()), (Throwable)ex);
            return this.exampleValueGenerator.createEmptyObjectExample();
        }
    }

    private T buildArrayExample(Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        String name = this.exampleValueGenerator.lookupSchemaName(schema);
        T arrayItem = this.buildExample(name, schema.getItems(), definitions, visited);
        return this.exampleValueGenerator.createArrayExample(arrayItem);
    }

    private T buildFromStringSchema(Schema schema) {
        String firstEnumValue = this.getFirstEnumValue(schema);
        if (firstEnumValue != null) {
            return this.exampleValueGenerator.createEnumExample(firstEnumValue);
        }
        String format = schema.getFormat();
        if (format == null) {
            return this.exampleValueGenerator.createStringExample();
        }
        return switch (format) {
            case "date" -> this.exampleValueGenerator.createDateExample();
            case "date-time" -> this.exampleValueGenerator.createDateTimeExample();
            case "email" -> this.exampleValueGenerator.createEmailExample();
            case "password" -> this.exampleValueGenerator.createPasswordExample();
            case "byte" -> this.exampleValueGenerator.createByteExample();
            case "binary" -> this.exampleValueGenerator.createBinaryExample();
            case "uuid" -> this.exampleValueGenerator.createUuidExample();
            default -> this.exampleValueGenerator.createUnknownSchemaStringFormatExample(format);
        };
    }

    private String getFirstEnumValue(Schema schema) {
        Optional firstEnumEntry;
        List enums = schema.getEnum();
        if (enums != null && (firstEnumEntry = enums.stream().findFirst()).isPresent()) {
            return (String)firstEnumEntry.get();
        }
        return null;
    }

    private T buildFromObjectSchema(String name, Schema schema, Map<String, Schema> definitions, Set<Schema> visited) {
        Map properties = schema.getProperties();
        if (properties != null && !visited.contains(schema)) {
            visited.add(schema);
            List<PropertyExample<T>> propertyList = this.buildPropertyExampleListFromSchema(properties, definitions, visited);
            T example = this.exampleValueGenerator.createObjectExample(name, propertyList);
            visited.remove(schema);
            return example;
        }
        if (schema.getAllOf() != null && !schema.getAllOf().isEmpty()) {
            List schemas = schema.getAllOf();
            List<PropertyExample<T>> mergedProperties = this.buildPropertyExampleListFromSchemas(schemas, definitions, visited);
            return this.exampleValueGenerator.createObjectExample(name, mergedProperties);
        }
        if (schema.getAnyOf() != null && !schema.getAnyOf().isEmpty()) {
            List schemas = schema.getAnyOf();
            Schema anyOfSchema = (Schema)schemas.get(0);
            return this.buildExample(name, anyOfSchema, definitions, visited);
        }
        if (schema.getOneOf() != null && !schema.getOneOf().isEmpty()) {
            List schemas = schema.getOneOf();
            Schema oneOfSchema = (Schema)schemas.get(0);
            return this.buildExample(name, oneOfSchema, definitions, visited);
        }
        return this.exampleValueGenerator.createEmptyObjectExample();
    }

    private List<PropertyExample<T>> buildPropertyExampleListFromSchema(Map<String, Schema> properties, Map<String, Schema> definitions, Set<Schema> visited) {
        return properties.entrySet().stream().map(entry -> {
            String propertyKey = (String)entry.getKey();
            T propertyValue = this.buildExample(propertyKey, (Schema)entry.getValue(), definitions, visited);
            return new PropertyExample<T>(propertyKey, propertyValue);
        }).sorted(Comparator.comparing(PropertyExample::name)).toList();
    }

    private List<PropertyExample<T>> buildPropertyExampleListFromSchemas(List<Schema> schemas, Map<String, Schema> definitions, Set<Schema> visited) {
        return schemas.stream().map(schema -> this.resolveSchemaFromRef((Schema)schema, definitions).orElse((Schema<?>)schema)).map(Schema::getProperties).filter(Objects::nonNull).flatMap(propertiesFromSchema -> this.buildPropertyExampleListFromSchema((Map<String, Schema>)propertiesFromSchema, definitions, visited).stream()).sorted(Comparator.comparing(PropertyExample::name)).toList();
    }

    private Optional<Schema<?>> resolveSchemaFromRef(Schema schema, Map<String, Schema> definitions) {
        String ref = schema.get$ref();
        if (ref != null) {
            String schemaName = MessageReference.extractRefName((String)ref);
            Schema resolvedSchema = definitions.get(schemaName);
            if (resolvedSchema == null) {
                throw new SchemaWalker.ExampleGeneratingException("Missing schema during example json generation: " + schemaName);
            }
            return Optional.of(resolvedSchema);
        }
        return Optional.empty();
    }

    public DefaultSchemaWalker(ExampleValueGenerator<T, R> exampleValueGenerator) {
        this.exampleValueGenerator = exampleValueGenerator;
    }
}

