/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.examples.walkers.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.springwolf.core.asyncapi.components.examples.walkers.ExampleValueGenerator;
import io.github.springwolf.core.asyncapi.components.examples.walkers.PropertyExample;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleJsonValueGenerator
implements ExampleValueGenerator<JsonNode, JsonNode> {
    private static final Logger log = LoggerFactory.getLogger(ExampleJsonValueGenerator.class);
    private static final Set<String> SUPPORTED_CONTENT_TYPES = Set.of("application/json");
    private static final BooleanNode DEFAULT_BOOLEAN_EXAMPLE = BooleanNode.valueOf((boolean)ExampleValueGenerator.DEFAULT_BOOLEAN_EXAMPLE);
    private static final ObjectMapper objectMapper = Json.mapper();

    @Override
    public boolean canHandle(String contentType) {
        return SUPPORTED_CONTENT_TYPES.contains(contentType);
    }

    @Override
    public void initialize() {
    }

    @Override
    public String lookupSchemaName(Schema schema) {
        return schema.getName();
    }

    @Override
    @NotNull
    public JsonNode createBooleanExample() {
        return DEFAULT_BOOLEAN_EXAMPLE;
    }

    @Override
    @NotNull
    public JsonNode createBooleanExample(Boolean value) {
        return BooleanNode.valueOf((boolean)value);
    }

    @Override
    public JsonNode createIntegerExample() {
        return new IntNode(DEFAULT_INTEGER_EXAMPLE.intValue());
    }

    @Override
    public JsonNode createDoubleExample() {
        return new DoubleNode(DEFAULT_NUMBER_EXAMPLE.doubleValue());
    }

    @Override
    public JsonNode createIntegerExample(Integer value) {
        return new IntNode(value.intValue());
    }

    @Override
    public JsonNode createDoubleExample(Double value) {
        return new DoubleNode(value.doubleValue());
    }

    @Override
    public JsonNode createStringExample() {
        return JsonNodeFactory.instance.textNode("string");
    }

    @Override
    public JsonNode createStringExample(String value) {
        return JsonNodeFactory.instance.textNode(value);
    }

    @Override
    public JsonNode createEnumExample(String anEnumValue) {
        return JsonNodeFactory.instance.textNode(anEnumValue);
    }

    @Override
    public JsonNode createDateExample() {
        return JsonNodeFactory.instance.textNode("2015-07-20");
    }

    @Override
    public JsonNode createDateTimeExample() {
        return JsonNodeFactory.instance.textNode("2015-07-20T15:49:04-07:00");
    }

    @Override
    public JsonNode createEmailExample() {
        return JsonNodeFactory.instance.textNode("example@example.com");
    }

    @Override
    public JsonNode createPasswordExample() {
        return JsonNodeFactory.instance.textNode("string-password");
    }

    @Override
    public JsonNode createByteExample() {
        return JsonNodeFactory.instance.textNode("YmFzZTY0LWV4YW1wbGU=");
    }

    @Override
    public JsonNode createBinaryExample() {
        return JsonNodeFactory.instance.textNode("0111010001100101011100110111010000101101011000100110100101101110011000010110010001111001");
    }

    @Override
    public JsonNode createUuidExample() {
        return JsonNodeFactory.instance.textNode("3fa85f64-5717-4562-b3fc-2c963f66afa6");
    }

    @Override
    public JsonNode createUnknownSchemaStringTypeExample(String type) {
        return JsonNodeFactory.instance.textNode("unknown schema type: " + type);
    }

    @Override
    public JsonNode createUnknownSchemaStringFormatExample(String schemaFormat) {
        return JsonNodeFactory.instance.textNode("unknown string schema format: " + schemaFormat);
    }

    @Override
    public JsonNode createArrayExample(JsonNode arrayItem) {
        ArrayNode array = objectMapper.createArrayNode();
        array.add(arrayItem);
        return array;
    }

    @Override
    public JsonNode prepareForSerialization(Schema schema, JsonNode exampleObject) {
        return exampleObject;
    }

    @Override
    public JsonNode createRaw(Object exampleValue) {
        try {
            return objectMapper.readTree(exampleValue.toString());
        }
        catch (JsonProcessingException e) {
            log.info("Unable to parse example to JsonNode: {}", exampleValue, (Object)e);
            return null;
        }
    }

    @Override
    public JsonNode getExampleOrNull(String name, Object example) {
        if (example instanceof JsonNode) {
            return (JsonNode)example;
        }
        return null;
    }

    @Override
    public JsonNode createObjectExample(String name, List<PropertyExample<JsonNode>> properties) {
        ObjectNode objectNode = objectMapper.createObjectNode();
        properties.forEach(property -> objectNode.set(property.name(), (JsonNode)property.example()));
        return objectNode;
    }

    @Override
    public JsonNode createEmptyObjectExample() {
        return objectMapper.createObjectNode();
    }
}

