/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.headers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.List;

public class AsyncHeaderSchema
extends StringSchema {
    @JsonIgnore
    private final String headerName;

    public AsyncHeaderSchema(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    private static AsyncHeaderSchema createHeader(String headerName, String description, String example, List<String> enumValue) {
        AsyncHeaderSchema header = new AsyncHeaderSchema(headerName);
        header.setDescription(description);
        header.setExample(example);
        header.setEnum(enumValue);
        return header;
    }

    public static AsyncHeaderSchemaBuilder headerBuilder() {
        return new AsyncHeaderSchemaBuilder();
    }

    public static class AsyncHeaderSchemaBuilder {
        private String headerName;
        private String description;
        private String example;
        private List<String> enumValue;

        AsyncHeaderSchemaBuilder() {
        }

        public AsyncHeaderSchemaBuilder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public AsyncHeaderSchemaBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AsyncHeaderSchemaBuilder example(String example) {
            this.example = example;
            return this;
        }

        public AsyncHeaderSchemaBuilder enumValue(List<String> enumValue) {
            this.enumValue = enumValue;
            return this;
        }

        public AsyncHeaderSchema build() {
            return AsyncHeaderSchema.createHeader(this.headerName, this.description, this.example, this.enumValue);
        }

        public String toString() {
            return "AsyncHeaderSchema.AsyncHeaderSchemaBuilder(headerName=" + this.headerName + ", description=" + this.description + ", example=" + this.example + ", enumValue=" + this.enumValue + ")";
        }
    }
}

