/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.components.postprocessors;

import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.core.asyncapi.components.postprocessors.SchemasPostProcessor;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.springframework.util.StringUtils;

public class AvroSchemaPostProcessor
implements SchemasPostProcessor {
    private static final String SCHEMA_PROPERTY = "schema";
    private static final String SPECIFIC_DATA_PROPERTY = "specificData";
    private static final String SCHEMA_REF = "org.apache.avro.Schema";
    private static final String SPECIFIC_DAT_REF = "org.apache.avro.specific.SpecificData";

    @Override
    public void process(Schema schema, Map<String, Schema> definitions, String contentType) {
        this.removeAvroSchemas(definitions);
        this.removeAvroProperties(schema, definitions);
    }

    private void removeAvroProperties(Schema schema, Map<String, Schema> definitions) {
        Map properties;
        String schemaName;
        if (schema.get$ref() != null && definitions.containsKey(schemaName = MessageReference.extractRefName((String)schema.get$ref()))) {
            this.removeAvroProperties(definitions.get(schemaName), definitions);
        }
        if ((properties = schema.getProperties()) != null) {
            Schema schemaPropertySchema = properties.getOrDefault(SCHEMA_PROPERTY, null);
            Schema specificDataPropertySchema = properties.getOrDefault(SPECIFIC_DATA_PROPERTY, null);
            if (schemaPropertySchema != null && specificDataPropertySchema != null && StringUtils.endsWithIgnoreCase((String)schemaPropertySchema.get$ref(), (String)SCHEMA_REF) && StringUtils.endsWithIgnoreCase((String)specificDataPropertySchema.get$ref(), (String)SPECIFIC_DAT_REF)) {
                properties.remove(SCHEMA_PROPERTY);
                properties.remove(SPECIFIC_DATA_PROPERTY);
            }
            properties.forEach((key, value) -> this.removeAvroProperties((Schema)value, definitions));
        }
    }

    private void removeAvroSchemas(Map<String, Schema> definitions) {
        definitions.entrySet().removeIf(entry -> StringUtils.startsWithIgnoreCase((String)((String)entry.getKey()), (String)"org.apache.avro"));
    }
}

